/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.BooleanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.account.api.service.ImAccountRpcService;
import com.els.modules.account.rpc.service.ImAccountInvokeSupplierRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.AccountRoleVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ImAccountBeanServiceImpl
implements ImAccountRpcService {
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private PermissionService permissionService;
    @Resource
    private ImAccountInvokeSupplierRpcService imAccountInvokeSupplierRpcService;

    public List<ImUserDTO> getUsersByUserId(List<String> userList) {
        if (CollUtil.isEmpty(userList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getAvatar, ElsSubAccount::getEmail, ElsSubAccount::getStatus, ElsSubAccount::getTelephone, BaseEntity::getCreateBy, BaseEntity::getCreateTime, ElsSubAccount::getPost, ElsSubAccount::getPostcode});
        wrapper.in(BaseEntity::getId, userList);
        List list = this.elsSubAccountService.list((Wrapper)wrapper);
        return Convert.toList(ImUserDTO.class, (Object)list);
    }

    public ImUserDTO getImUserByLoginName(String elsAccount, String subAccount) {
        ElsSubAccount byAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        return (ImUserDTO)Convert.convert(ImUserDTO.class, (Object)byAccount);
    }

    public ImUserDTO getImUserByUid(String userId) {
        ElsSubAccount account = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)userId));
        return (ImUserDTO)Convert.convert(ImUserDTO.class, (Object)account);
    }

    public List<ImUserDTO> getImUserByLoginNames(Set<String> account) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"concat(els_account,'_',sub_account)", account);
        List list = this.elsSubAccountService.list((Wrapper)queryWrapper);
        return Convert.toList(ImUserDTO.class, (Object)list);
    }

    public ImUserDTO getImUserById(String userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getAvatar, ElsSubAccount::getEmail, ElsSubAccount::getStatus, ElsSubAccount::getTelephone, BaseEntity::getCreateBy, BaseEntity::getCreateTime, ElsSubAccount::getPost, ElsSubAccount::getPostcode});
        wrapper.eq(BaseEntity::getId, (Object)userId);
        ElsSubAccount one = (ElsSubAccount)this.elsSubAccountService.getOne((Wrapper)wrapper);
        return (ImUserDTO)Convert.convert(ImUserDTO.class, (Object)one);
    }

    public List<ImUserDTO> getAllUsers(String name) {
        LoginUser loginUser = SysUtil.getLoginUser();
        AccountRoleVO accountRoleVO = this.permissionService.checkAccountRole(loginUser.getElsAccount(), loginUser.getSubAccount(), null);
        ArrayList<String> elsAccount = new ArrayList<String>();
        if (accountRoleVO.isSale()) {
            List supplierToElsAccount = this.imAccountInvokeSupplierRpcService.getSupplierToElsAccount(name);
            elsAccount.addAll(supplierToElsAccount);
        }
        if (accountRoleVO.isPurchase()) {
            List supplierElsAccount = this.imAccountInvokeSupplierRpcService.getSupplierElsAccount(name);
            elsAccount.addAll(supplierElsAccount);
        }
        elsAccount.add(TenantContext.getTenant());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getAvatar, ElsSubAccount::getEmail, ElsSubAccount::getStatus, ElsSubAccount::getTelephone, BaseEntity::getCreateBy, BaseEntity::getCreateTime, ElsSubAccount::getPost, ElsSubAccount::getPostcode});
        ((LambdaQueryWrapper)wrapper.in(BaseEntity::getElsAccount, elsAccount)).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(BaseEntity::getElsAccount, (Object)name)).or()).like(ElsSubAccount::getRealname, (Object)name);
        });
        List userList = this.elsSubAccountService.list((Wrapper)wrapper);
        return Convert.toList(ImUserDTO.class, (Object)userList);
    }

    public boolean checkIfKefu(String toUserId) {
        ElsSubAccount byId = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)toUserId));
        if (null == byId) {
            return false;
        }
        if (!"100000".equals(byId.getElsAccount())) {
            return false;
        }
        if ("100000".equals(byId.getElsAccount()) && "admin".equals(byId.getSubAccount())) {
            return true;
        }
        Boolean customerRoleFlag = ((UserRoleService)SpringContextUtils.getBean(UserRoleService.class)).getCustomerRoleFlag(byId.getElsAccount(), byId.getSubAccount());
        return BooleanUtil.isTrue((Boolean)customerRoleFlag);
    }
}

