/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.InterfaceConverterUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.google.common.base.Functions;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="findColumnBySubAccountConverter")
public class FindColumnBySubAccountConverter
implements InterfaceConverter {
    private static final String REDIS_PREFIX = "srm:findColumnBySubAccountConverter_";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private ElsSubAccountService elsSubAccountService;

    public Object convertData(Object data, Object obj, String ... args) throws Exception {
        String searData = (String)data;
        String elsAccount = TenantContext.getTenant();
        String searColumn = args[0];
        String outColumn = args[1];
        if (StringUtils.isNotBlank((CharSequence)searData)) {
            List dbAccount = (List)this.redisUtil.get(REDIS_PREFIX + elsAccount);
            Map<Object, Object> dbMap = new HashMap();
            if (CollectionUtils.isEmpty((Collection)dbAccount)) {
                dbAccount = ((LambdaQueryChainWrapper)this.elsSubAccountService.lambdaQuery().select(new SFunction[]{ElsSubAccount::getSubAccount, BaseEntity::getId, ElsSubAccount::getRealname, ElsSubAccount::getWorkNo, ElsSubAccount::getSourceId}).eq(ElsSubAccount::getElsAccount, (Object)elsAccount)).list();
                if (CollectionUtils.isEmpty((Collection)dbAccount)) {
                    return "";
                }
                this.redisUtil.set(REDIS_PREFIX + elsAccount, (Object)dbAccount, 300L);
            }
            if ("realname".equals(searColumn)) {
                dbMap = dbAccount.stream().collect(Collectors.toMap(ElsSubAccount::getRealname, Functions.identity()));
            } else if ("sourceId".equals(searColumn)) {
                dbMap = dbAccount.stream().collect(Collectors.toMap(ElsSubAccount::getSourceId, Functions.identity()));
            } else if ("subAccount_realname".equals(searColumn)) {
                dbMap = dbAccount.stream().collect(Collectors.toMap(account -> account.getSubAccount() + "_" + account.getRealname(), Functions.identity()));
            }
            if (dbMap.containsKey(searData)) {
                if (outColumn.indexOf("_") > 0) {
                    String[] columns = outColumn.split("_");
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < columns.length; ++i) {
                        sb.append(InterfaceConverterUtil.findName((String)columns[i], (Object)dbMap.get(searData)));
                        if (i == columns.length) continue;
                        sb.append("_");
                    }
                    return InterfaceConverterUtil.findName((String)outColumn, (Object)sb.toString());
                }
                return InterfaceConverterUtil.findName((String)outColumn, (Object)dbMap.get(searData));
            }
            return "";
        }
        return searData;
    }
}

