/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.util.InterfaceConverterUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="findColumnBySubAccountConverter")
public class FindColumnBySubAccountConverter
implements InterfaceConverter {
    private static final String REDIS_PREFIX = "srm:findColumnBySubAccountConverter_";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private ElsSubAccountService elsSubAccountService;

    public Object convertData(Object data, Object obj, String ... args) throws Exception {
        String searData = (String)data;
        String elsAccount = TenantContext.getTenant();
        String searColumn = args[0];
        String outColumn = args[1];
        if (StringUtils.isNotBlank((CharSequence)searData)) {
            Map<String, ElsSubAccount> dbMap;
            List dbAccount = (List)this.redisUtil.get(REDIS_PREFIX + elsAccount);
            if (CollectionUtils.isEmpty((Collection)dbAccount)) {
                dbAccount = ((LambdaQueryChainWrapper)this.elsSubAccountService.lambdaQuery().eq(ElsSubAccount::getElsAccount, (Object)elsAccount)).list();
                if (CollectionUtils.isEmpty((Collection)dbAccount)) {
                    return "";
                }
                this.redisUtil.set(REDIS_PREFIX + elsAccount, (Object)dbAccount, 300L);
            }
            if ((dbMap = this.getSearKeyMap(searColumn, JSON.parseArray((String)JSON.toJSONString((Object)dbAccount), (Feature[])new Feature[0]))).containsKey(searData)) {
                if (outColumn.indexOf("_") > 0) {
                    String[] columns = outColumn.split("_");
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < columns.length; ++i) {
                        sb.append(InterfaceConverterUtil.findName((String)columns[i], (Object)dbMap.get(searData)));
                        if (i == columns.length) continue;
                        sb.append("_");
                    }
                    return InterfaceConverterUtil.findName((String)outColumn, (Object)sb.toString());
                }
                return InterfaceConverterUtil.findName((String)outColumn, (Object)dbMap.get(searData));
            }
            return "";
        }
        return searData;
    }

    private Map<String, ElsSubAccount> getSearKeyMap(String searColumn, JSONArray arrays) {
        HashMap<String, ElsSubAccount> result = new HashMap<String, ElsSubAccount>();
        for (int i = 0; i < arrays.size(); ++i) {
            JSONObject obj = arrays.getJSONObject(i);
            if (searColumn.indexOf("_") > 0) {
                String[] columns = searColumn.split("_");
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < columns.length; ++j) {
                    sb.append(obj.getString(columns[j]));
                    if (j == columns.length - 1) continue;
                    sb.append("_");
                }
                result.put(sb.toString(), (ElsSubAccount)JSON.parseObject((String)obj.toJSONString(), ElsSubAccount.class));
                continue;
            }
            if (!obj.containsKey((Object)searColumn)) continue;
            String key = obj.getString(searColumn);
            result.put(key, (ElsSubAccount)JSON.parseObject((String)obj.toJSONString(), ElsSubAccount.class));
        }
        return result;
    }
}

