/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SsoTokenServiceImpl
implements SimpleOpenApiRpcService {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private RedisUtil redisUtil;

    public JSONObject invoke(JSONObject param) {
        String subAccount;
        String elsAccount = TenantContext.getTenant();
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount = param.getString("subAccount"));
        if (elsSubAccount == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JeyxMKW_ff3f2765", (String)"\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728\uff01"));
        }
        JSONObject result = new JSONObject();
        result.put("token", (Object)this.saveToken(elsSubAccount));
        return result;
    }

    private String saveToken(ElsSubAccount account) {
        String token = JwtUtil.sign((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword());
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 1800L);
        return token;
    }
}

