/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.util.RedisUtil;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.service.ElsEnterpriseInfoService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="elsAccountToEnterpriseNameConverter")
public class ElsAccountToEnterpriseNameConverter
implements InterfaceConverter {
    private static final Logger log = LoggerFactory.getLogger(ElsAccountToEnterpriseNameConverter.class);
    private static final String REDIS_PREFIX = "srm:elsAccountToEnterpriseNameConvertor_";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private ElsEnterpriseInfoService elsEnterpriseInfoService;

    public Object convertData(Object data, Object obj, String ... args) {
        String elsAccount = (String)data;
        if (StringUtils.isNotBlank((CharSequence)elsAccount)) {
            ElsEnterpriseInfo elsEnterpriseInfo = (ElsEnterpriseInfo)this.redisUtil.get(REDIS_PREFIX + elsAccount);
            if (elsEnterpriseInfo == null && (elsEnterpriseInfo = (ElsEnterpriseInfo)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsEnterpriseInfoService.lambdaQuery().select(new SFunction[]{ElsEnterpriseInfo::getElsAccount, ElsEnterpriseInfo::getName}).eq(ElsEnterpriseInfo::getElsAccount, (Object)elsAccount)).last("limit 1")).one()) != null) {
                this.redisUtil.set(REDIS_PREFIX + elsAccount, (Object)elsEnterpriseInfo, 300L);
            }
            if (elsEnterpriseInfo != null) {
                return elsEnterpriseInfo.getName();
            }
        }
        return elsAccount;
    }
}

