/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.api.dto.BaseDTO;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.service.ImAccountRpcService;
import com.els.modules.account.rpc.service.ImAccountInvokeSupplierRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.AccountRoleVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ImAccountBeanServiceImpl
implements ImAccountRpcService {
    @Resource
    @Lazy
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private ElsTenantService elsTenantServiceImpl;
    @Resource
    private PermissionService permissionService;
    @Autowired
    private ImAccountInvokeSupplierRpcService imAccountInvokeSupplierRpcService;

    public List<ImUserDTO> getUsersByUserId(List<String> userList) {
        if (CollUtil.isEmpty(userList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getAvatar, ElsSubAccount::getEmail, ElsSubAccount::getStatus, ElsSubAccount::getTelephone, BaseEntity::getCreateBy, BaseEntity::getCreateTime, ElsSubAccount::getPost, ElsSubAccount::getPostcode});
        wrapper.in(BaseEntity::getId, userList);
        List list = this.elsSubAccountService.list((Wrapper)wrapper);
        List elsAccountList = list.stream().map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
        List imUserDTOList = Convert.toList(ImUserDTO.class, (Object)list);
        if (CollUtil.isNotEmpty(elsAccountList)) {
            LambdaQueryWrapper wrapper1 = Wrappers.lambdaQuery();
            wrapper1.select(new SFunction[]{ElsTenant::getCompanyName, ElsTenant::getCompanyShortName, BaseEntity::getElsAccount});
            wrapper1.in(BaseEntity::getElsAccount, elsAccountList);
            List tenantList = this.elsTenantServiceImpl.list((Wrapper)wrapper1);
            Map<String, String> stringMap = tenantList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, ElsTenant::getCompanyName, (v1, v2) -> v2));
            for (ImUserDTO u : imUserDTOList) {
                String name = stringMap.get(u.getElsAccount()) + "_" + u.getElsAccount() + "_" + u.getSubAccount();
                u.setEnterpriseName(CharSequenceUtil.emptyToDefault((CharSequence)name, (String)u.getRealname()));
            }
        }
        return imUserDTOList;
    }

    public ImUserDTO getImUserByLoginName(String elsAccount, String subAccount) {
        ElsSubAccount byAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        return (ImUserDTO)Convert.convert(ImUserDTO.class, (Object)byAccount);
    }

    public ImUserDTO getImUserByUid(String userId) {
        ElsSubAccount account = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)userId));
        return (ImUserDTO)Convert.convert(ImUserDTO.class, (Object)account);
    }

    public List<ImUserDTO> getImUserByLoginNames(Set<String> account) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"els_account||'_'||sub_account)", account);
        List list = this.elsSubAccountService.list((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        List elsAccountList = list.stream().map(BaseEntity::getElsAccount).collect(Collectors.toList());
        List tenantList = ((ElsTenantService)SpringContextUtils.getBean(ElsTenantService.class)).getTenantList(elsAccountList);
        List imUserDTOS = Convert.toList(ImUserDTO.class, (Object)list);
        Map<String, String> map = tenantList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, ElsTenantDTO::getCompanyName, (v1, v2) -> v2));
        for (ImUserDTO im : imUserDTOS) {
            String s = map.get(im.getElsAccount());
            if (CharSequenceUtil.isEmpty((CharSequence)s)) {
                s = "-";
            }
            im.setEnterpriseName(s);
        }
        return imUserDTOS;
    }

    public ImUserDTO getImUserById(String userId) {
        ElsSubAccount one = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)userId));
        one.setPassword(null);
        one.setSalt(null);
        return (ImUserDTO)Convert.convert(ImUserDTO.class, (Object)one);
    }

    public List<ImUserDTO> getAllUsers(String name) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        AccountRoleVO accountRoleVO = this.permissionService.checkAccountRole(loginUser.getElsAccount(), loginUser.getSubAccount(), null);
        ArrayList<String> elsAccount = new ArrayList<String>();
        if (accountRoleVO.isPurchase() || SysUtil.getPurchaseAccount().equals(SysUtil.getLoginUser().getElsAccount())) {
            List supplierToElsAccount = this.imAccountInvokeSupplierRpcService.getSupplierToElsAccount(name);
            elsAccount.addAll(supplierToElsAccount);
        }
        if (accountRoleVO.isSale() || !SysUtil.getPurchaseAccount().equals(SysUtil.getLoginUser().getElsAccount()) && !SysUtil.getPurchaseAccount().equals("100000")) {
            List supplierElsAccount = this.imAccountInvokeSupplierRpcService.getSupplierElsAccount(name);
            elsAccount.addAll(supplierElsAccount);
        }
        elsAccount.add(TenantContext.getTenant());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getAvatar, ElsSubAccount::getEmail, ElsSubAccount::getStatus, ElsSubAccount::getTelephone, BaseEntity::getCreateBy, BaseEntity::getCreateTime, ElsSubAccount::getPost, ElsSubAccount::getPostcode});
        ((LambdaQueryWrapper)wrapper.in(BaseEntity::getElsAccount, elsAccount)).and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(BaseEntity::getElsAccount, (Object)name)).or()).like(ElsSubAccount::getRealname, (Object)name));
        List userList = this.elsSubAccountService.list((Wrapper)wrapper);
        List imUserDTOList = Convert.toList(ImUserDTO.class, (Object)userList);
        List elsAccountList = imUserDTOList.stream().map(ImUserDTO::getElsAccount).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(elsAccountList)) {
            LambdaQueryWrapper tenantWrapper = Wrappers.lambdaQuery();
            tenantWrapper.select(new SFunction[]{BaseEntity::getElsAccount, ElsTenant::getCompanyName, ElsTenant::getCompanyShortName, ElsTenant::getCompanyLogo});
            tenantWrapper.in(BaseEntity::getElsAccount, elsAccountList);
            List tenants = this.elsTenantServiceImpl.list((Wrapper)tenantWrapper);
            Map tenantMap = tenants.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity(), (v1, v2) -> v2));
            for (ImUserDTO dto : imUserDTOList) {
                ElsTenant elsTenant = (ElsTenant)tenantMap.get(dto.getElsAccount());
                if (null == elsTenant) continue;
                dto.setEnterpriseName(elsTenant.getCompanyName());
                dto.setEnterpriseLogo(elsTenant.getCompanyLogo());
            }
        }
        return imUserDTOList;
    }

    public boolean checkIfKefu(String toUserId) {
        ElsSubAccount byId = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)toUserId));
        if (null == byId) {
            return false;
        }
        if (!"100000".equals(byId.getElsAccount())) {
            return false;
        }
        if ("100000".equals(byId.getElsAccount()) && "admin".equals(byId.getSubAccount())) {
            return true;
        }
        Boolean customerRoleFlag = ((UserRoleService)SpringContextUtils.getBean(UserRoleService.class)).getCustomerRoleFlag(byId.getElsAccount(), byId.getSubAccount());
        return BooleanUtil.isTrue((Boolean)customerRoleFlag);
    }

    public ImUserDTO getLoginUser(String userId) {
        ElsSubAccount byId = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)userId));
        byId.setPassword(null);
        byId.setSalt(null);
        ElsTenant byElsAccount = this.elsTenantServiceImpl.findByElsAccount(byId.getElsAccount());
        ImUserDTO userDTO = (ImUserDTO)Convert.convert(ImUserDTO.class, (Object)byId);
        if (null != byElsAccount) {
            userDTO.setEnterpriseName(byElsAccount.getCompanyName());
        }
        return userDTO;
    }

    public List<String> loadElsAccountId(List<String> elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(BaseEntity::getElsAccount, elsAccount);
        wrapper.select(new SFunction[]{BaseEntity::getId});
        List list = this.elsSubAccountService.list((Wrapper)wrapper);
        return list.stream().map(BaseEntity::getId).collect(Collectors.toList());
    }

    public boolean checkIfSameElsAccount(String elsAccount, String userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getId, (Object)userId);
        return this.elsSubAccountService.count((Wrapper)wrapper) > 0;
    }

    public List<ImUserDTO> loadElsAccount(List<String> userId) {
        List subAccountList = this.elsSubAccountService.listByIds(userId);
        return Convert.toList(ImUserDTO.class, (Object)subAccountList);
    }

    public Map<String, List<String>> loadElsAccountIdToMap(List<String> elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(BaseEntity::getElsAccount, elsAccount);
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount});
        List list = this.elsSubAccountService.list((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount, Collectors.mapping(BaseEntity::getId, Collectors.toList())));
    }

    public List<ImUserDTO> listUser(List<String> userIds) {
        List list = this.elsSubAccountService.listByIds(userIds);
        return Convert.toList(ImUserDTO.class, (Object)list);
    }

    public List<ImUserDTO> listSubAccountList(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getAvatar, ElsSubAccount::getEmail, ElsSubAccount::getStatus, ElsSubAccount::getTelephone, BaseEntity::getCreateBy, BaseEntity::getCreateTime, ElsSubAccount::getPost, ElsSubAccount::getPostcode}).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsSubAccount::getStatus, (Object)"1");
        List list = this.elsSubAccountService.list((Wrapper)wrapper);
        return Convert.toList(ImUserDTO.class, (Object)list);
    }
}

