/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="subAccountToSourceIdConverter")
public class SubAccountToSourceIdConverter
implements InterfaceConverter {
    private static final Logger log = LoggerFactory.getLogger(SubAccountToSourceIdConverter.class);
    private static final String REDIS_PREFIX = "srm:subAccountToSourceIdConverter_";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private ElsSubAccountService elsSubAccountService;

    public Object convertData(Object data, Object obj, String ... args) {
        String account = (String)data;
        if (StrUtil.isNotBlank((CharSequence)account)) {
            ElsSubAccount subAccount = (ElsSubAccount)this.redisUtil.get(REDIS_PREFIX + account);
            if (subAccount == null && (subAccount = (ElsSubAccount)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsSubAccountService.lambdaQuery().select(new SFunction[]{ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getWorkNo, ElsSubAccount::getSourceId}).eq(ElsSubAccount::getSubAccount, (Object)account)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).one()) != null) {
                this.redisUtil.set(REDIS_PREFIX + account, (Object)subAccount, 300L);
            }
            if (subAccount != null) {
                return subAccount.getSourceId();
            }
        }
        return account;
    }
}

