/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterprise.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.entity.ElsEnterpriseInfoRecord;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoRecordMapper;
import com.els.modules.enterprise.rpc.service.EnterpriseInvokeBaseRpcService;
import com.els.modules.enterprise.rpc.service.EnterpriseInvokeSupplierRpcService;
import com.els.modules.enterprise.service.ElsEnterpriseInfoService;
import com.els.modules.enterprise.vo.EnterpriseInfoVo;
import com.els.modules.supplier.api.dto.SupplierAddressInfoDTO;
import com.els.modules.supplier.api.dto.SupplierBankInfoDTO;
import com.els.modules.supplier.api.dto.SupplierContactsInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.CompanyService;
import com.els.modules.system.service.ElsSubAccountService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsEnterpriseInfoServiceImpl
extends ServiceImpl<ElsEnterpriseInfoMapper, ElsEnterpriseInfo>
implements ElsEnterpriseInfoService,
CompanyService {
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private EnterpriseInvokeSupplierRpcService invokeSupplierRpcService;
    @Autowired
    private ElsEnterpriseInfoRecordMapper elsEnterpriseInfoRecordMapper;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private EnterpriseInvokeBaseRpcService enterpriseInvokeBaseRpcService;

    @Override
    public void saveElsEnterpriseInfo(ElsEnterpriseInfo elsEnterpriseInfo) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).insert((Object)elsEnterpriseInfo);
    }

    @Override
    public void updateElsEnterpriseInfo(ElsEnterpriseInfo elsEnterpriseInfo) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).updateById((Object)elsEnterpriseInfo);
    }

    @Override
    public void delElsEnterpriseInfo(String id) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsEnterpriseInfo(List<String> idList) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsEnterpriseInfo getByElsAccount(String elsAccount) {
        return this.elsEnterpriseInfoMapper.getByElsAccount(elsAccount);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void update(EnterpriseInfoVo enterpriseInfoVo) {
        List<SupplierMasterDataDTO> datas;
        ArrayList<SupplierContactsInfoDTO> insertItems;
        EnterpriseInfoVo infoRecord = this.insertInfoRecord(enterpriseInfoVo);
        ElsEnterpriseInfo elsEnterpriseInfo = new ElsEnterpriseInfo();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVo), (Object)((Object)elsEnterpriseInfo));
        this.updateById((Object)elsEnterpriseInfo);
        if (enterpriseInfoVo.getSupplierContactsInfoList() != null) {
            this.invokeSupplierRpcService.deleteContactsByElsAccount(enterpriseInfoVo.getElsAccount());
            insertItems = new ArrayList<SupplierContactsInfoDTO>();
            for (SupplierContactsInfoDTO supplierContactsInfoDTO : enterpriseInfoVo.getSupplierContactsInfoList()) {
                supplierContactsInfoDTO.setId(null);
                supplierContactsInfoDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierContactsInfoDTO.setCreateTime(new Date());
                insertItems.add(supplierContactsInfoDTO);
            }
            if (!insertItems.isEmpty()) {
                this.invokeSupplierRpcService.insertContactsBatchSomeColumn(insertItems);
            }
        }
        if (enterpriseInfoVo.getSupplierBankInfoList() != null) {
            this.invokeSupplierRpcService.deleteBankByElsAccount(enterpriseInfoVo.getElsAccount());
            insertItems = new ArrayList();
            for (SupplierBankInfoDTO supplierBankInfoDTO : enterpriseInfoVo.getSupplierBankInfoList()) {
                supplierBankInfoDTO.setId(null);
                supplierBankInfoDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierBankInfoDTO.setCreateTime(new Date());
                insertItems.add((SupplierContactsInfoDTO)supplierBankInfoDTO);
            }
            if (!insertItems.isEmpty()) {
                this.invokeSupplierRpcService.insertBankBatchSomeColumn(insertItems);
            }
        }
        if (enterpriseInfoVo.getSupplierAddressInfoList() != null) {
            this.invokeSupplierRpcService.deleteAddressByElsAccount(enterpriseInfoVo.getElsAccount());
            insertItems = new ArrayList();
            for (SupplierAddressInfoDTO supplierAddressInfoDTO : enterpriseInfoVo.getSupplierAddressInfoList()) {
                supplierAddressInfoDTO.setId(null);
                supplierAddressInfoDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierAddressInfoDTO.setCreateTime(new Date());
                insertItems.add((SupplierContactsInfoDTO)supplierAddressInfoDTO);
            }
            if (!insertItems.isEmpty()) {
                this.invokeSupplierRpcService.insertAddressBatchSomeColumn(insertItems);
            }
        }
        if ((datas = this.invokeSupplierRpcService.listByToElsAccount(enterpriseInfoVo.getElsAccount())) != null && datas.size() > 0) {
            for (SupplierMasterDataDTO supplierMasterDataDTO : datas) {
                if (!supplierMasterDataDTO.getSupplierName().equals(elsEnterpriseInfo.getName())) {
                    supplierMasterDataDTO.setSupplierName(elsEnterpriseInfo.getName());
                    this.invokeSupplierRpcService.updateById(supplierMasterDataDTO);
                }
                if (!"2".equals(supplierMasterDataDTO.getSupplierStatus())) continue;
                MqUtil.sendBusMsg((String)this.parameterAssemble(supplierMasterDataDTO.getElsAccount(), StringUtils.isNotBlank((CharSequence)supplierMasterDataDTO.getPrincipal()) ? supplierMasterDataDTO.getPrincipal().split("_")[0] : "1001", infoRecord, enterpriseInfoVo).toString());
            }
        }
    }

    private JSONObject parameterAssemble(String elsAccount, String subAccount, EnterpriseInfoVo infoRecord, EnterpriseInfoVo infoVo) {
        String id;
        List<TemplateConfigHeadDTO> enterpriseList;
        JSONObject msgObj = new JSONObject();
        msgObj.put("msgKey", (Object)IdWorker.getIdStr());
        msgObj.put("busAccount", (Object)elsAccount);
        msgObj.put("businessType", (Object)"SupplierInfoChange");
        msgObj.put("operateType", (Object)"confirm");
        LoginUser user = SysUtil.getLoginUser();
        msgObj.put("sendObj", JSONObject.parse((String)user.toString()));
        ArrayList<ElsSubAccount> accountList = new ArrayList<ElsSubAccount>();
        ElsSubAccount subAccountInfo = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        accountList.add(subAccountInfo);
        JSONObject receiveJson = new JSONObject();
        receiveJson.put("toElsAccount", (Object)elsAccount);
        receiveJson.put("toSubAccountList", (Object)JSONArray.parseArray((String)((Object)accountList).toString()));
        msgObj.put("receiveList", (Object)receiveJson);
        Result result = Result.ok((Object)((Object)infoRecord));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        JSONObject oldObject = (JSONObject)result.getResult();
        result = Result.ok((Object)((Object)infoVo));
        dictAspect.parseDictText((Object)result);
        JSONObject newObject = (JSONObject)result.getResult();
        Set properties = newObject.keySet();
        List<TemplateHeadDTO> headList = this.enterpriseInvokeBaseRpcService.getDefaultTemplateByType("enterprise");
        HashMap enterpriseColumn = new HashMap();
        if (!headList.isEmpty() && (enterpriseList = this.enterpriseInvokeBaseRpcService.selectByMainId(id = headList.get(0).getId())) != null && enterpriseList.size() > 0) {
            for (TemplateConfigHeadDTO templateConfigHead : enterpriseList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("label", templateConfigHead.getFieldLabel());
                map.put("type", templateConfigHead.getFieldType());
                enterpriseColumn.put(templateConfigHead.getFieldName(), map);
            }
        }
        JSONObject data = new JSONObject();
        data.put("supplierAddressInfoList", (Object)new JSONArray());
        data.put("supplierBankInfoList", (Object)new JSONArray());
        data.put("supplierCertificatedInfoList", (Object)new JSONArray());
        data.put("supplierContactsInfoList", (Object)new JSONArray());
        data.put("supplierAddressInfoListOld", (Object)new JSONArray());
        data.put("supplierBankInfoListOld", (Object)new JSONArray());
        data.put("supplierCertificatedInfoListOld", (Object)new JSONArray());
        data.put("supplierContactsInfoListOld", (Object)new JSONArray());
        JSONArray array = new JSONArray();
        SimpleDateFormat dateStr = new SimpleDateFormat("yyyy-MM-dd");
        for (String string : properties) {
            String newValue = StringUtils.isNotBlank((CharSequence)newObject.getString(string + "_dictText")) ? newObject.getString(string + "_dictText") : newObject.getString(string);
            if (!StringUtils.isNotBlank((CharSequence)newValue)) continue;
            try {
                JSONArray oldArray;
                JSONArray tabArray = JSONObject.parseArray((String)newObject.getString(string));
                if (tabArray != null) {
                    for (Object object1 : tabArray) {
                        JSONObject jsonObject = JSONObject.parseObject((String)object1.toString());
                        Set keys = jsonObject.keySet();
                        for (Object key : keys) {
                            if (!StringUtils.isNotBlank((CharSequence)jsonObject.getString((String)key + "_dictText"))) continue;
                            jsonObject.put((String)key, (Object)jsonObject.getString((String)key + "_dictText"));
                        }
                    }
                }
                if ((oldArray = JSONObject.parseArray((String)oldObject.getString(string))) != null) {
                    Object object1;
                    object1 = oldArray.iterator();
                    while (object1.hasNext()) {
                        Object key;
                        Object object12 = object1.next();
                        JSONObject jsonObject = JSONObject.parseObject((String)object12.toString());
                        Set keys = jsonObject.keySet();
                        key = keys.iterator();
                        while (key.hasNext()) {
                            String key2 = (String)key.next();
                            if (!StringUtils.isNotBlank((CharSequence)jsonObject.getString(key2 + "_dictText"))) continue;
                            jsonObject.put(key2, (Object)jsonObject.getString(key2 + "_dictText"));
                        }
                    }
                }
                if ("supplierAddressInfoList".equals(string)) {
                    data.put("supplierAddressInfoList", (Object)tabArray);
                    data.put("supplierAddressInfoListOld", (Object)oldArray);
                }
                if ("supplierBankInfoList".equals(string)) {
                    data.put("supplierBankInfoList", (Object)tabArray);
                    data.put("supplierBankInfoListOld", (Object)oldArray);
                }
                if ("supplierCertificatedInfoList".equals(string)) {
                    data.put("supplierCertificatedInfoList", (Object)tabArray);
                    data.put("supplierCertificatedInfoListOld", (Object)oldArray);
                }
                if (!"supplierContactsInfoList".equals(string)) continue;
                data.put("supplierContactsInfoList", (Object)tabArray);
                data.put("supplierContactsInfoListOld", (Object)oldArray);
            }
            catch (Exception e) {
                Map map;
                String oldValue = StringUtils.isNotBlank((CharSequence)oldObject.getString(string + "_dictText")) ? oldObject.getString(string + "_dictText") : oldObject.getString(string);
                if (newValue.equals(oldValue) || "updateTime".equals(string) || "createTime".equals(string) || (map = (Map)enterpriseColumn.get(string)) == null) continue;
                JSONObject object = new JSONObject();
                if ("date".equals(map.get("type"))) {
                    Long newTime = null;
                    Long oldTime = null;
                    try {
                        newTime = dateStr.parse(newValue).getTime();
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                    if (StringUtils.isNotBlank((CharSequence)oldValue)) {
                        try {
                            oldTime = dateStr.parse(oldValue).getTime();
                        }
                        catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                        if (oldTime.equals(newTime)) continue;
                        object.put("column", map.get("label"));
                        object.put("old", (Object)dateStr.format(new Date(oldTime)));
                        object.put("new", (Object)dateStr.format(new Date(newTime)));
                        array.add((Object)object);
                        continue;
                    }
                    object.put("column", map.get("label"));
                    object.put("old", (Object)"");
                    object.put("new", (Object)dateStr.format(newTime));
                    array.add((Object)object);
                    continue;
                }
                object.put("column", map.get("label"));
                object.put("old", (Object)oldValue);
                object.put("new", (Object)newValue);
                array.add((Object)object);
            }
        }
        data.put("enterpriseInfoList", (Object)array);
        msgObj.put("businessObj", (Object)data);
        return msgObj;
    }

    public EnterpriseInfoVo insertInfoRecord(EnterpriseInfoVo enterpriseInfoVo) {
        ElsEnterpriseInfo elsEnterpriseOldInfo = this.getByElsAccount(enterpriseInfoVo.getElsAccount());
        if (elsEnterpriseOldInfo != null) {
            EnterpriseInfoVo enterpriseInfoOldVo = new EnterpriseInfoVo();
            BeanUtils.copyProperties((Object)((Object)elsEnterpriseOldInfo), (Object)((Object)enterpriseInfoOldVo));
            List<SupplierContactsInfoDTO> contactsInfo = this.invokeSupplierRpcService.getContactsDataOnlyAccount(enterpriseInfoVo.getElsAccount());
            enterpriseInfoOldVo.setSupplierContactsInfoList(contactsInfo);
            List<SupplierAddressInfoDTO> addressInfo = this.invokeSupplierRpcService.getAddressDataOnlyAccount(enterpriseInfoVo.getElsAccount());
            enterpriseInfoOldVo.setSupplierAddressInfoList(addressInfo);
            List<SupplierBankInfoDTO> bankInfo = this.invokeSupplierRpcService.getBankDataOnlyAccount(enterpriseInfoVo.getElsAccount());
            enterpriseInfoOldVo.setSupplierBankInfoList(bankInfo);
            int version = this.elsEnterpriseInfoRecordMapper.getMaxVersionByAccount(enterpriseInfoVo.getElsAccount());
            ElsEnterpriseInfoRecord infoRecord = new ElsEnterpriseInfoRecord();
            infoRecord.setElsAccount(enterpriseInfoVo.getElsAccount());
            infoRecord.setVersion(version);
            infoRecord.setInfo(JSONObject.toJSONString((Object)((Object)enterpriseInfoOldVo)));
            this.elsEnterpriseInfoRecordMapper.insert((Object)infoRecord);
            return enterpriseInfoOldVo;
        }
        return null;
    }

    @Override
    public Map<String, String> getCompanyName(String elsAccount) {
        HashMap<String, String> map = new HashMap<String, String>();
        ElsEnterpriseInfo info = this.elsEnterpriseInfoMapper.getByElsAccount(elsAccount);
        if (info != null) {
            map.put("fullName", info.getName());
            map.put("shortName", info.getAlias());
        }
        return map;
    }
}

