/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.appreciation.entity.ElsAppreciationService;
import com.els.modules.appreciation.enumerate.AppreciationServiceTypeEnum;
import com.els.modules.appreciation.service.ElsAppreciationServiceService;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.esign.entity.ElsEnterpriseCertificationInfo;
import com.els.modules.esign.enumerate.EsignInterfaceEnum;
import com.els.modules.esign.mapper.ElsEnterpriseCertificationInfoMapper;
import com.els.modules.esign.service.ElsEnterpriseCertificationInfoService;
import com.els.modules.esign.vo.EnterpriseAuthCallBakVO;
import com.els.modules.esign.vo.EnterpriseAuthenticationEO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ElsEnterpriseCertificationInfoServiceImpl
extends BaseServiceImpl<ElsEnterpriseCertificationInfoMapper, ElsEnterpriseCertificationInfo>
implements ElsEnterpriseCertificationInfoService {
    @Value(value="${els.service.address}")
    private String address;
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeBaseRpcService callInterfaceService;
    @Autowired
    private ElsAppreciationServiceService elsAppreciationServiceService;
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;

    @Override
    public void saveElsEnterpriseCertificationInfo(ElsEnterpriseCertificationInfo elsEnterpriseCertificationInfo) {
        PurchaseOrganizationInfoDTO organizationInfo;
        elsEnterpriseCertificationInfo.setBusAccount("100000");
        elsEnterpriseCertificationInfo.setCertificationStatus("0");
        ElsEnterpriseInfo enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            elsEnterpriseCertificationInfo.setEnterpriseId(enterpriseInfo.getId());
            elsEnterpriseCertificationInfo.setEnterpriseName(enterpriseInfo.getName());
        }
        if ("1".equals(elsEnterpriseCertificationInfo.getLoadingCompany()) && (organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", elsEnterpriseCertificationInfo.getCompanyCode())) != null) {
            elsEnterpriseCertificationInfo.setCompanyName(organizationInfo.getOrgName());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"company_name", (Object)elsEnterpriseCertificationInfo.getCompanyName());
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        if (StringUtils.isNotBlank((CharSequence)elsEnterpriseCertificationInfo.getCreatedAccount())) {
            wrapper.eq((Object)"created_account", (Object)elsEnterpriseCertificationInfo.getCreatedAccount());
        } else {
            wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"created_account")).or()).eq((Object)"created_account", (Object)""));
        }
        if (!this.list((Wrapper)wrapper).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).insert((Object)elsEnterpriseCertificationInfo);
    }

    @Override
    public void updateElsEnterpriseCertificationInfo(ElsEnterpriseCertificationInfo elsEnterpriseCertificationInfo) {
        PurchaseOrganizationInfoDTO organizationInfo;
        if ("1".equals(elsEnterpriseCertificationInfo.getLoadingCompany()) && (organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", elsEnterpriseCertificationInfo.getCompanyCode())) != null) {
            elsEnterpriseCertificationInfo.setCompanyName(organizationInfo.getOrgName());
        }
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).updateById((Object)elsEnterpriseCertificationInfo);
    }

    @Override
    public void delElsEnterpriseCertificationInfo(String id) {
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsEnterpriseCertificationInfo(List<String> idList) {
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<?> submitCertification(ElsEnterpriseCertificationInfo certificationInfo) {
        ElsAppreciationService service = null;
        service = StringUtils.isNotBlank((CharSequence)certificationInfo.getCreatedAccount()) ? this.elsAppreciationServiceService.getByElsAccountAndServiceType(certificationInfo.getCreatedAccount(), AppreciationServiceTypeEnum.ESIGN.getValue()) : this.elsAppreciationServiceService.getByElsAccountAndServiceType(TenantContext.getTenant(), AppreciationServiceTypeEnum.ESIGN.getValue());
        if (service == null) {
            return Result.error((String)"\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
        }
        if (StringUtils.isBlank((CharSequence)certificationInfo.getId())) {
            this.saveElsEnterpriseCertificationInfo(certificationInfo);
        } else {
            this.updateElsEnterpriseCertificationInfo(certificationInfo);
        }
        Result response = null;
        if (StringUtils.isBlank((CharSequence)certificationInfo.getOrgId())) {
            response = this.callInterfaceService.callEsignCommonPost(EsignInterfaceEnum.ENTERPRISE_ACCOUNT_CREATE.getValue(), JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)certificationInfo))), service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
            if (response.isSuccess()) {
                JSONObject jsonObject = JSONObject.parseObject((String)response.getMessage());
                certificationInfo.setOrgId(jsonObject.getString("orgId"));
                this.updateById((Object)certificationInfo);
            } else {
                return Result.error((String)("\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:" + response.getMessage()));
            }
        }
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/elsEnterpriseCertificationInfo/callback/enterprise" : this.address + "/els/esign/elsEnterpriseCertificationInfo/callback/enterprise";
        EnterpriseAuthenticationEO authenticationEO = new EnterpriseAuthenticationEO(certificationInfo, notifyUrl);
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("accountId", (Object)certificationInfo.getOrgId());
        requestJSON.put("bascis", (Object)bascis);
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)authenticationEO)));
        response = this.callInterfaceService.callEsignCommonPost(EsignInterfaceEnum.ENTERPRISE_CERTIFICATION.getValue(), requestJSON, service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
        if (!response.isSuccess()) {
            return Result.error((String)("\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:" + response.getMessage()));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)response.getMessage());
        certificationInfo.setShortLink(jsonObject.getString("shortLink"));
        certificationInfo.setLongLink(jsonObject.getString("url"));
        certificationInfo.setCertificationFlowId(jsonObject.getString("flowId"));
        certificationInfo.setCertificationStartTime(new Date());
        this.updateById((Object)certificationInfo);
        return Result.ok((String)"\u8ba4\u8bc1\u63d0\u4ea4\u6210\u529f");
    }

    @Override
    public void enterpriseCallBack(JSONObject object) {
        EnterpriseAuthCallBakVO authCallBakVO = (EnterpriseAuthCallBakVO)JSON.parseObject((String)object.toJSONString(), EnterpriseAuthCallBakVO.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"certification_flow_id", (Object)authCallBakVO.getFlowId());
        List certificationInfos = this.list((Wrapper)wrapper);
        if (!certificationInfos.isEmpty() && authCallBakVO.isSuccess()) {
            ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)((Object)certificationInfos.get(0));
            certificationInfo.setCertificationStatus("1");
            certificationInfo.setVerifyCode(authCallBakVO.getVerifycode());
            this.updateById((Object)certificationInfo);
        }
    }

    @Override
    public Result<?> modifyAuthInfo(ElsEnterpriseCertificationInfo certificationInfo) {
        ElsAppreciationService service = null;
        service = StringUtils.isNotBlank((CharSequence)certificationInfo.getCreatedAccount()) ? this.elsAppreciationServiceService.getByElsAccountAndServiceType(certificationInfo.getCreatedAccount(), AppreciationServiceTypeEnum.ESIGN.getValue()) : this.elsAppreciationServiceService.getByElsAccountAndServiceType(TenantContext.getTenant(), AppreciationServiceTypeEnum.ESIGN.getValue());
        if (service == null) {
            return Result.error((String)"\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
        }
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("orgId", (Object)certificationInfo.getOrgId());
        requestJSON.put("bascis", (Object)bascis);
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)certificationInfo))));
        Result response = this.callInterfaceService.callEsignCommonPost(EsignInterfaceEnum.ENTERPRISE_ACCOUNT_MODIFY.getValue(), requestJSON, service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
        if (!response.isSuccess()) {
            return Result.error((String)("\u4fee\u6539\u5931\u8d25:" + response.getMessage()));
        }
        this.updateById((Object)certificationInfo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }
}

