/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.appreciation.entity.ElsAppreciationService;
import com.els.modules.appreciation.enumerate.AppreciationServiceTypeEnum;
import com.els.modules.appreciation.service.ElsAppreciationServiceService;
import com.els.modules.esign.entity.ElsSigners;
import com.els.modules.esign.enumerate.EsignInterfaceEnum;
import com.els.modules.esign.mapper.ElsSignersMapper;
import com.els.modules.esign.service.ElsSignersService;
import com.els.modules.esign.vo.EsignKeyWordVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsSignersServiceImpl
extends BaseServiceImpl<ElsSignersMapper, ElsSigners>
implements ElsSignersService {
    @Autowired
    private ElsSignersMapper elsSignersMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsAppreciationServiceService elsAppreciationServiceService;

    @Override
    public List<ElsSigners> selectByMainId(String mainId) {
        return this.elsSignersMapper.selectByMainId(mainId);
    }

    @Override
    public Result<?> keyWordToAera(ElsSigners signers) {
        ElsAppreciationService service = this.elsAppreciationServiceService.getByElsAccountAndServiceType(signers.getElsAccount(), AppreciationServiceTypeEnum.ESIGN.getValue());
        if (service == null) {
            return Result.error((String)"\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
        }
        Result response = null;
        if (StringUtils.isNotBlank((CharSequence)signers.getSignWord())) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("fileId", (Object)signers.getFilesId());
            bascis.put("keywords", (Object)signers.getSignWord());
            requestJSON.put("bascis", (Object)bascis);
            response = this.invokeBaseRpcService.callEsignCommonPost(EsignInterfaceEnum.KEYWORD_SEARCH.getValue(), requestJSON, service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
            if (response.isSuccess()) {
                JSONArray array = JSONArray.parseArray((String)response.getMessage());
                if (array.size() == 0) {
                    return Result.error((String)("\u3010" + signers.getSignWord() + "\u3011 \u5173\u952e\u5b57\u641c\u7d22\u672a\u5b9a\u4f4d\u5230\u5177\u4f53\u4f4d\u7f6e"));
                }
                ArrayList<EsignKeyWordVO> keyWordVOs = new ArrayList<EsignKeyWordVO>();
                for (Object object : array) {
                    JSONObject objectJsonObject = JSONObject.parseObject((String)object.toString());
                    JSONArray positionList = JSONArray.parseArray((String)objectJsonObject.getString("positionList"));
                    for (Object object2 : positionList) {
                        JSONObject jsonObject = JSONObject.parseObject((String)object2.toString());
                        int pageNo = jsonObject.getIntValue("pageIndex");
                        JSONArray coordinateList = JSONArray.parseArray((String)jsonObject.getString("coordinateList"));
                        for (Object object3 : coordinateList) {
                            JSONObject vaule = JSONObject.parseObject((String)object3.toString());
                            String posx = vaule.getString("posx");
                            String posy = vaule.getString("posy");
                            keyWordVOs.add(new EsignKeyWordVO(pageNo, posx, posy));
                        }
                    }
                }
                JSONObject result = new JSONObject();
                result.put("current", (Object)1);
                result.put("pages", (Object)1);
                result.put("records", keyWordVOs);
                result.put("size", (Object)100);
                result.put("total", (Object)keyWordVOs.size());
                return Result.ok((Object)result);
            }
            return Result.error((String)("\u641c\u7d22\u5931\u8d25:" + response.getMessage()));
        }
        return null;
    }
}

