/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.appreciation.entity.ElsAppreciationService;
import com.els.modules.appreciation.enumerate.AppreciationServiceTypeEnum;
import com.els.modules.appreciation.service.ElsAppreciationServiceService;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.esign.entity.ElsSubaccountCertificationInfo;
import com.els.modules.esign.enumerate.EsignInterfaceEnum;
import com.els.modules.esign.mapper.ElsSubaccountCertificationInfoMapper;
import com.els.modules.esign.service.ElsSubaccountCertificationInfoService;
import com.els.modules.esign.vo.PersonAuthCallBakVO;
import com.els.modules.esign.vo.PersonAuthenticationEO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ElsSubaccountCertificationInfoServiceImpl
extends BaseServiceImpl<ElsSubaccountCertificationInfoMapper, ElsSubaccountCertificationInfo>
implements ElsSubaccountCertificationInfoService {
    @Value(value="${els.service.address}")
    private String address;
    @Value(value="${interface.esign.sms-sign}")
    private String sign;
    @Value(value="${interface.esign.sms-code}")
    private String code;
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsAppreciationServiceService elsAppreciationServiceService;

    @Override
    public void saveElsSubaccountCertificationInfo(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"sub_account_id", (Object)elsSubaccountCertificationInfo.getSubAccountId());
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        if (StringUtils.isNotBlank((CharSequence)elsSubaccountCertificationInfo.getCreatedAccount())) {
            wrapper.eq((Object)"created_account", (Object)elsSubaccountCertificationInfo.getCreatedAccount());
        } else {
            wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"created_account")).or()).eq((Object)"created_account", (Object)""));
        }
        if (!this.list((Wrapper)wrapper).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u8ba4\u8bc1\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        elsSubaccountCertificationInfo.setBusAccount("100000");
        elsSubaccountCertificationInfo.setCertificationStatus("0");
        ElsEnterpriseInfo enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            elsSubaccountCertificationInfo.setCompanyName(enterpriseInfo.getName());
        }
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).insert((Object)elsSubaccountCertificationInfo);
    }

    @Override
    public void updateElsSubaccountCertificationInfo(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).updateById((Object)elsSubaccountCertificationInfo);
    }

    @Override
    public void delElsSubaccountCertificationInfo(String id) {
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsSubaccountCertificationInfo(List<String> idList) {
        ((ElsSubaccountCertificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<?> submintCertification(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        ElsAppreciationService service = null;
        service = StringUtils.isNotBlank((CharSequence)elsSubaccountCertificationInfo.getCreatedAccount()) ? this.elsAppreciationServiceService.getByElsAccountAndServiceType(elsSubaccountCertificationInfo.getCreatedAccount(), AppreciationServiceTypeEnum.ESIGN.getValue()) : this.elsAppreciationServiceService.getByElsAccountAndServiceType(TenantContext.getTenant(), AppreciationServiceTypeEnum.ESIGN.getValue());
        if (service == null) {
            return Result.error((String)"\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
        }
        if (StringUtils.isBlank((CharSequence)elsSubaccountCertificationInfo.getId())) {
            this.saveElsSubaccountCertificationInfo(elsSubaccountCertificationInfo);
        } else {
            this.updateElsSubaccountCertificationInfo(elsSubaccountCertificationInfo);
        }
        Result response = null;
        if (StringUtils.isBlank((CharSequence)elsSubaccountCertificationInfo.getAccountId())) {
            response = this.invokeBaseRpcService.callEsignCommonPost(EsignInterfaceEnum.PERSONAL_ACCOUNT_CREATE.getValue(), JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)elsSubaccountCertificationInfo))), service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
            if (response.isSuccess()) {
                ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)JSON.parseObject((String)response.getMessage(), ElsSubaccountCertificationInfo.class));
                elsSubaccountCertificationInfo.setAccountId(certificationInfo.getAccountId());
                this.updateById((Object)elsSubaccountCertificationInfo);
            } else {
                return Result.error((String)("\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:" + response.getMessage()));
            }
        }
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/elsSubaccountCertificationInfo/callback/person" : this.address + "/els/esign/elsSubaccountCertificationInfo/callback/person";
        PersonAuthenticationEO authenticationEO = new PersonAuthenticationEO(elsSubaccountCertificationInfo, notifyUrl);
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("accountId", (Object)elsSubaccountCertificationInfo.getAccountId());
        requestJSON.put("bascis", (Object)bascis);
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)authenticationEO)));
        response = this.invokeBaseRpcService.callEsignCommonPost(EsignInterfaceEnum.PERSONAL_CERTIFICATION.getValue(), requestJSON, service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
        if (!response.isSuccess()) {
            return Result.error((String)("\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:" + response.getMessage()));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)response.getMessage());
        elsSubaccountCertificationInfo.setShortLink(jsonObject.getString("shortLink"));
        elsSubaccountCertificationInfo.setLongLink(jsonObject.getString("url"));
        elsSubaccountCertificationInfo.setEsignFlowId(jsonObject.getString("flowId"));
        elsSubaccountCertificationInfo.setCertificationStartTime(new Date());
        this.updateById((Object)elsSubaccountCertificationInfo);
        return Result.ok((String)"\u8ba4\u8bc1\u63d0\u4ea4\u6210\u529f");
    }

    @Override
    public void personCallBack(JSONObject object) {
        PersonAuthCallBakVO authCallBakVO = (PersonAuthCallBakVO)JSON.parseObject((String)object.toJSONString(), PersonAuthCallBakVO.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"esign_flow_id", (Object)authCallBakVO.getFlowId());
        List certificationInfos = this.list((Wrapper)wrapper);
        if (!certificationInfos.isEmpty()) {
            ElsSubaccountCertificationInfo certificationInfo = (ElsSubaccountCertificationInfo)((Object)certificationInfos.get(0));
            JSONObject obj = new JSONObject();
            if (authCallBakVO.isSuccess()) {
                certificationInfo.setCertificationStatus("1");
                certificationInfo.setVerifyCode(authCallBakVO.getVerifycode());
                this.updateById((Object)certificationInfo);
                obj.put("authResult", (Object)"\u6210\u529f");
            } else {
                obj.put("authResult", (Object)"\u5931\u8d25");
            }
        }
    }

    @Override
    public Result<?> modifyAuthInfo(ElsSubaccountCertificationInfo elsSubaccountCertificationInfo) {
        ElsAppreciationService service = null;
        service = StringUtils.isNotBlank((CharSequence)elsSubaccountCertificationInfo.getCreatedAccount()) ? this.elsAppreciationServiceService.getByElsAccountAndServiceType(elsSubaccountCertificationInfo.getCreatedAccount(), AppreciationServiceTypeEnum.ESIGN.getValue()) : this.elsAppreciationServiceService.getByElsAccountAndServiceType(TenantContext.getTenant(), AppreciationServiceTypeEnum.ESIGN.getValue());
        if (service == null) {
            return Result.error((String)"\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
        }
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("accountId", (Object)elsSubaccountCertificationInfo.getAccountId());
        requestJSON.put("bascis", (Object)bascis);
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)elsSubaccountCertificationInfo))));
        Result response = this.invokeBaseRpcService.callEsignCommonPost(EsignInterfaceEnum.PERSONAL_ACCOUNT_MODIFY.getValue(), requestJSON, service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
        if (!response.isSuccess()) {
            return Result.error((String)("\u4fee\u6539\u5931\u8d25:" + response.getMessage()));
        }
        this.updateById((Object)elsSubaccountCertificationInfo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }
}

