/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import com.alibaba.fastjson.JSON;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.service.AbstractExcelHandler;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionDataImprotImpl
extends AbstractExcelHandler {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private PermissionDataService permissionDataService;

    @Override
    public void importExcel(List<Map<String, Object>> dataList) {
        String elsAccount = TenantContext.getTenant();
        HashMap<String, String> accountMap = new HashMap<String, String>();
        ArrayList<PermissionData> list = new ArrayList<PermissionData>();
        for (Map<String, Object> data : dataList) {
            PermissionData permissionData = (PermissionData)((Object)JSON.parseObject((String)JSON.toJSONString(data), PermissionData.class));
            permissionData.setElsAccount(elsAccount);
            permissionData.setDeleted(CommonConstant.DEL_FLAG_0);
            permissionData.setCreateTime(new Date());
            String subAccount = permissionData.getSubAccount();
            if (accountMap.containsKey(subAccount)) {
                permissionData.setUserId((String)accountMap.get(subAccount));
            } else {
                ElsSubAccount account = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
                if (account == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u5b50\u8d26\u53f7\uff1a" + subAccount + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01")));
                }
                accountMap.put(subAccount, account.getId());
                permissionData.setUserId(account.getId());
            }
            list.add(permissionData);
        }
        if (!list.isEmpty()) {
            this.permissionDataService.batchSave(list);
        }
    }
}

