/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.appreciation.entity.ElsAppreciationService;
import com.els.modules.appreciation.enumerate.AppreciationServiceTypeEnum;
import com.els.modules.appreciation.service.ElsAppreciationServiceService;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.SaleContractHeadDTO;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.esign.entity.ElsEsign;
import com.els.modules.esign.entity.ElsSigners;
import com.els.modules.esign.enumerate.EsignBusTypeEnum;
import com.els.modules.esign.enumerate.EsignInterfaceEnum;
import com.els.modules.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.esign.enumerate.EsignSignerStatusEmun;
import com.els.modules.esign.enumerate.EsignStatusEmun;
import com.els.modules.esign.enumerate.SignerVindicateStatusEnum;
import com.els.modules.esign.mapper.ElsEsignMapper;
import com.els.modules.esign.mapper.ElsSignersMapper;
import com.els.modules.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.esign.service.ElsEsignService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsEsignServiceImpl
extends BaseServiceImpl<ElsEsignMapper, ElsEsign>
implements ElsEsignService {
    @Autowired
    private ElsEsignMapper elsEsignMapper;
    @Autowired
    private ElsSignersMapper elsSignersMapper;
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private EsignInvokeContractRpcService esignInvokeContractRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsAppreciationServiceService elsAppreciationServiceService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ElsEsign elsEsign, List<ElsSigners> purchaseSignersList, List<ElsSigners> saleSignersList) {
        PurchaseContractHeadDTO contractHead;
        JSONObject object;
        ElsEnterpriseInfo enterpriseInfo;
        elsEsign.setBusAccount("100000");
        elsEsign.setDeleted(CommonConstant.DEL_FLAG_0);
        elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
        if (StringUtils.isBlank((CharSequence)elsEsign.getPurchaseName()) && (enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(TenantContext.getTenant())) != null) {
            elsEsign.setPurchaseName(enterpriseInfo.getName());
        }
        if (StringUtils.isBlank((CharSequence)elsEsign.getSupplierName()) && (enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(elsEsign.getToElsAccount())) != null) {
            elsEsign.setSupplierName(enterpriseInfo.getName());
        }
        if ((object = SysUtil.getLoginUser().getCompanySet()) != null && StringUtils.isNotBlank((CharSequence)object.getString("defaultValue")) && object.getString("defaultValue").contains(EsignBusTypeEnum.CONTRACT.getValue())) {
            elsEsign.setOnlineSealed("1");
        }
        this.elsEsignMapper.insert((Object)elsEsign);
        if (EsignBusTypeEnum.CONTRACT.getValue().equals(elsEsign.getBusType()) && (contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(elsEsign.getRelationId())) != null) {
            if ("1".equals(contractHead.getStartSign())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            contractHead.setStartSign("1");
            this.esignInvokeContractRpcService.updatePurchaseEntityById(contractHead);
            SaleContractHeadDTO saleContractHead = this.esignInvokeContractRpcService.getSaleContractById(contractHead.getRelationId());
            if (saleContractHead != null) {
                saleContractHead.setStartSign("1");
                this.esignInvokeContractRpcService.updateSaleEntityById(saleContractHead);
            }
        }
        this.insertData(elsEsign, purchaseSignersList, saleSignersList, null);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ElsEsign elsEsign, List<ElsSigners> purchaseSignersList, List<ElsSigners> saleSignersList, List<SaleAttachmentDTO> attachments) {
        this.elsEsignMapper.updateById((Object)elsEsign);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)elsEsign.getId());
        wrapper.eq((Object)"role_type", (Object)elsEsign.getModifyPerson());
        this.elsSignersMapper.delete((Wrapper)wrapper);
        this.insertData(elsEsign, purchaseSignersList, saleSignersList, attachments);
    }

    private void insertData(ElsEsign elsEsign, List<ElsSigners> purchaseSignersList, List<ElsSigners> saleSignersList, List<SaleAttachmentDTO> attachments) {
        boolean purchaseFlag = false;
        boolean saleFlag = false;
        if (EsignRoleTypeEnum.PURCHASE.getValue().equals(elsEsign.getModifyPerson())) {
            if (purchaseSignersList != null) {
                for (ElsSigners entity : purchaseSignersList) {
                    entity.setId(null);
                    entity.setHeadId(elsEsign.getId());
                    entity.setFilesId(elsEsign.getFilesId());
                    entity.setFilesName(elsEsign.getFilesName());
                    entity.setFlowId(elsEsign.getFlowId());
                    entity.setRoleType("0");
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsEsign);
                }
                if (!purchaseSignersList.isEmpty()) {
                    this.elsSignersMapper.insertBatchSomeColumn(purchaseSignersList);
                    purchaseFlag = true;
                }
            }
            if (saleSignersList != null && saleSignersList.size() > 0) {
                saleFlag = true;
            }
        } else {
            if (saleSignersList != null) {
                for (ElsSigners entity : saleSignersList) {
                    entity.setId(null);
                    entity.setHeadId(elsEsign.getId());
                    entity.setFilesId(elsEsign.getFilesId());
                    entity.setFilesName(elsEsign.getFilesName());
                    entity.setRoleType("1");
                    entity.setFlowId(elsEsign.getFlowId());
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsEsign);
                }
                if (!saleSignersList.isEmpty()) {
                    this.elsSignersMapper.insertBatchSomeColumn(saleSignersList);
                    saleFlag = true;
                }
            }
            if (purchaseSignersList != null && purchaseSignersList.size() > 0) {
                purchaseFlag = true;
            }
        }
        if (attachments != null) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(elsEsign.getId());
            for (SaleAttachmentDTO saleAttachment : attachments) {
                PurchaseAttachmentDTO attachment = (PurchaseAttachmentDTO)SysUtil.copyProperties((Object)saleAttachment, PurchaseAttachmentDTO.class);
                attachment.setElsAccount(elsEsign.getElsAccount());
                attachment.setHeadId(elsEsign.getId());
                attachment.setRelationId(saleAttachment.getId());
                this.invokeBaseRpcService.insertPurchaseAttachment(attachment);
                saleAttachment.setRelationId(attachment.getId());
                saleAttachment.setSendStatus("1");
                this.invokeBaseRpcService.updateSaleAttachment(saleAttachment);
            }
        }
        if ("1".equals(elsEsign.getOnlineSealed())) {
            if (!purchaseFlag && !saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
            } else if (purchaseFlag && saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            } else if (!purchaseFlag && saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
            } else if (purchaseFlag && !saleFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.SALE_NO_MAINTENANCE.getValue());
            }
        } else {
            if (!purchaseFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
            } else if (purchaseFlag) {
                elsEsign.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            }
            if (!EsignRoleTypeEnum.PURCHASE.getValue().equals(elsEsign.getModifyPerson())) {
                elsEsign.setSaleEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
            }
        }
        this.elsEsignMapper.updateById((Object)elsEsign);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsSignersMapper.deleteByMainId(id);
        this.elsEsignMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsSignersMapper.deleteByMainId(serializable.toString());
            this.elsEsignMapper.deleteById(serializable);
        }
    }

    @Override
    public Result<?> sendBack(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            PurchaseContractHeadDTO contractHead;
            if ("1".equals(esign.getLaunch())) {
                return Result.ok((String)"\u7b7e\u7f72\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u9000\u56de");
            }
            if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType()) && (contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId())) != null) {
                contractHead.setStartSign("0");
                this.esignInvokeContractRpcService.updatePurchaseEntityById(contractHead);
                SaleContractHeadDTO saleContractHead = this.esignInvokeContractRpcService.getSaleContractById(contractHead.getRelationId());
                if (saleContractHead != null) {
                    saleContractHead.setStartSign(contractHead.getStartSign());
                    this.esignInvokeContractRpcService.updateSaleEntityById(saleContractHead);
                }
            }
        } else {
            return Result.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548");
        }
        esign.setSendBack("1");
        this.updateById((Object)esign);
        return Result.ok((String)"\u9000\u56de\u6210\u529f");
    }

    @Override
    public Result<?> backout(String id, String reason) {
        ElsEsign esign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            PurchaseContractHeadDTO contractHead;
            ElsAppreciationService service = this.elsAppreciationServiceService.getByElsAccountAndServiceType(esign.getElsAccount(), AppreciationServiceTypeEnum.ESIGN.getValue());
            if (service == null) {
                return Result.error((String)"\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
            }
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("bascis", (Object)bascis);
            JSONObject body = new JSONObject();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)esign.getId());
            wrapper.eq((Object)"role_type", (Object)"0");
            List purhcaseSigners = this.elsSignersMapper.selectList((Wrapper)wrapper);
            if (purhcaseSigners != null) {
                body.put("operatorId", (Object)((ElsSigners)((Object)purhcaseSigners.get(0))).getAccountId());
            }
            body.put("revokeReason", (Object)reason);
            requestJSON.put("body", (Object)body);
            Result response = this.invokeBaseRpcService.callEsignCommonPost(EsignInterfaceEnum.FLOW_BACKOUT.getValue(), requestJSON, service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
            if (!response.isSuccess()) {
                return Result.error((String)("\u64a4\u9500\u5931\u8d25:" + response.getMessage()));
            }
            esign.setEsignStatus(EsignStatusEmun.UNDONE.getValue());
            if (!"1".equals(esign.getAutoInitiate())) {
                esign.setInitiate("0");
            }
            esign.setPurchaseEsignStatus(EsignSignerStatusEmun.UNDONE.getValue());
            esign.setReason(reason);
            this.updateById((Object)esign);
            if (EsignBusTypeEnum.CONTRACT.getValue().equals(esign.getBusType()) && (contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId())) != null) {
                contractHead.setEndSign(esign.getEsignStatus());
                this.esignInvokeContractRpcService.updatePurchaseEntityById(contractHead);
                SaleContractHeadDTO saleContractHead = this.esignInvokeContractRpcService.getSaleContractById(contractHead.getRelationId());
                if (saleContractHead != null) {
                    saleContractHead.setEndSign(contractHead.getEndSign());
                    this.esignInvokeContractRpcService.updateSaleEntityById(saleContractHead);
                }
            }
        } else {
            return Result.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548");
        }
        return Result.ok((String)"\u64a4\u9500\u6210\u529f");
    }

    @Override
    public Result<?> signFileDownload(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            ElsAppreciationService service = this.elsAppreciationServiceService.getByElsAccountAndServiceType(esign.getElsAccount(), AppreciationServiceTypeEnum.ESIGN.getValue());
            if (service == null) {
                return Result.error((String)"\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
            }
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("bascis", (Object)bascis);
            Result response = this.invokeBaseRpcService.callEsignCommonPost(EsignInterfaceEnum.DOWNLOAD_FLOW.getValue(), requestJSON, service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
            if (!response.isSuccess()) {
                return Result.error((String)("\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u94fe\u63a5\u83b7\u53d6\u5931\u8d25:" + response.getMessage()));
            }
            JSONObject object = (JSONObject)response.getResult();
            return Result.ok((Object)object.getJSONArray("docs"));
        }
        return Result.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548");
    }

    @Override
    public Result<?> viewEsignFile(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            ElsAppreciationService service = this.elsAppreciationServiceService.getByElsAccountAndServiceType(esign.getElsAccount(), AppreciationServiceTypeEnum.ESIGN.getValue());
            if (service == null) {
                return Result.error((String)"\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
            }
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("fileId", (Object)esign.getFilesId());
            requestJSON.put("bascis", (Object)bascis);
            Result response = this.invokeBaseRpcService.callEsignCommonPost(EsignInterfaceEnum.VIEW_ESIGN_FILE.getValue(), requestJSON, service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
            if (!response.isSuccess()) {
                return Result.error((String)("\u5f85\u7b7e\u7f72\u6587\u4ef6\u94fe\u63a5\u83b7\u53d6\u5931\u8d25:" + response.getMessage()));
            }
            return Result.ok((Object)response.getResult());
        }
        return Result.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548");
    }

    @Override
    public Result<?> busSignFileDownload(String id, String busType) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"relation_id", (Object)id);
        wrapper.eq((Object)"bus_type", (Object)busType);
        wrapper.eq((Object)"is_archiving", (Object)"1");
        wrapper.eq((Object)"is_send_back", (Object)"0");
        wrapper.eq((Object)"is_deleted", (Object)"0");
        List esigns = this.list((Wrapper)wrapper);
        if (!esigns.isEmpty()) {
            return this.signFileDownload(((ElsEsign)((Object)esigns.get(0))).getId());
        }
        return Result.error((String)"\u7b7e\u7ae0\u6d41\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
    }

    @Override
    public ElsAppreciationService getService(String elsAccount, String serviceType) {
        return this.elsAppreciationServiceService.getByElsAccountAndServiceType(elsAccount, serviceType);
    }
}

