/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.UUIDGenerator;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.model.AuthCodeModel;
import com.els.modules.system.model.LoginModel;
import com.els.modules.system.service.ElsSubAccountService;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oauth2"})
public class OAuth2Controller {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String OAUTH2_AUTH_CODE_KEY = "sys:oauth2:authCode:";
    private static final String OAUTH2_TOKEN_KEY = "sys:oauth2:token:";

    @GetMapping(value={"/chekClient"})
    public Result<?> chekClient(@RequestParam(name="clientId", required=true) String clientId) throws IOException {
        ElsSubAccount account = this.elsSubAccountService.getUserByAccount(clientId);
        if (account == null) {
            return Result.ok((String)"false");
        }
        return Result.ok((String)"true");
    }

    @AutoLog(value="Oauth2-\u5ba2\u6237\u7aef\u767b\u5f55", logType=1, operateType=1)
    @RequestMapping(value={"/oauthLogin"})
    public Result<?> oauthLogin(LoginModel loginModel, HttpServletResponse response) throws IOException {
        String elsAccount = loginModel.getElsAccount();
        if (StrUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"ELS \u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String subAccount = loginModel.getSubAccount();
        if (StrUtil.isBlank((CharSequence)subAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b50\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String password = loginModel.getPassword();
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String account = String.valueOf(elsAccount) + "_" + subAccount;
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getUserByAccount(account);
        if (elsSubAccount == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u4e0d\u5b58\u5728\uff01"));
        }
        String userpassword = PasswordUtil.encrypt((String)account, (String)password, (String)elsSubAccount.getSalt());
        String syspassword = elsSubAccount.getPassword();
        if (!syspassword.equals(userpassword)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01"));
        }
        if (CommonConstant.DEL_FLAG_1.intValue() == elsSubAccount.getDeleted().intValue()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u7528\u6237\u5df2\u6ce8\u9500\uff01"));
        }
        if (CommonConstant.USER_FREEZE.equals(elsSubAccount.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3\uff01"));
        }
        String redirectUri = loginModel.getRedirectUri();
        String responseType = loginModel.getResponseType();
        if ("code".equals(responseType)) {
            String authCode = UUIDGenerator.generate();
            this.redisUtil.set(OAUTH2_AUTH_CODE_KEY + authCode, (Object)elsSubAccount, 1800L);
            redirectUri = String.valueOf(redirectUri) + "&authCode=" + authCode;
        } else {
            String token = JwtUtil.sign((String)account, (String)syspassword);
            this.redisUtil.set(OAUTH2_TOKEN_KEY + token, (Object)elsSubAccount, 1800L);
            redirectUri = String.valueOf(redirectUri) + "&token=" + token;
        }
        return Result.ok((String)redirectUri);
    }

    @AutoLog(value="Oauth2-\u5ba2\u6237\u7aef\u83b7\u53d6token", logType=2, operateType=1)
    @PostMapping(value={"/token"})
    public Result<?> getToken(@RequestBody AuthCodeModel codeModel) throws IOException {
        String account = codeModel.getClientId();
        String secret = codeModel.getSecret();
        String authCode = codeModel.getAuthCode();
        if (StrUtil.isBlank((CharSequence)account)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"clientId \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StrUtil.isBlank((CharSequence)secret)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"secret \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StrUtil.isBlank((CharSequence)authCode)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"authCode \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getUserByAccount(account);
        if (elsSubAccount == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"clientId \u4e0d\u5b58\u5728\uff01"));
        }
        String userpassword = PasswordUtil.encrypt((String)account, (String)secret, (String)elsSubAccount.getSalt());
        String syspassword = elsSubAccount.getPassword();
        if (!syspassword.equals(userpassword)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"secret \u9519\u8bef\uff01"));
        }
        ElsSubAccount subAccount = (ElsSubAccount)((Object)this.redisUtil.get(OAUTH2_AUTH_CODE_KEY + authCode));
        if (subAccount == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"authCode \u5df2\u5931\u6548\uff01"));
        }
        String token = JwtUtil.sign((String)(String.valueOf(subAccount.getElsAccount()) + "_" + subAccount.getSubAccount()), (String)subAccount.getPassword());
        this.redisUtil.set(OAUTH2_TOKEN_KEY + token, (Object)subAccount, 1800L);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        return Result.ok((Object)obj);
    }

    @AutoLog(value="Oauth2-\u83b7\u53d6\u7528\u6237\u4fe1\u606f", logType=2, operateType=1)
    @GetMapping(value={"/userInfo"})
    public Result<?> userInfo(@RequestParam(name="token", required=true) String token) throws IOException {
        ElsSubAccount subAccount = (ElsSubAccount)((Object)this.redisUtil.get(OAUTH2_TOKEN_KEY + token));
        if (subAccount == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"token \u5df2\u5931\u6548\uff01"));
        }
        JSONObject obj = new JSONObject();
        obj.put("id", (Object)subAccount.getId());
        obj.put("avatar", (Object)subAccount.getAvatar());
        obj.put("elsAccount", (Object)subAccount.getElsAccount());
        obj.put("subAccount", (Object)subAccount.getSubAccount());
        obj.put("phone", (Object)subAccount.getPhone());
        obj.put("email", (Object)subAccount.getEmail());
        JSONObject object = new JSONObject();
        object.put("userInfo", (Object)obj);
        return Result.ok((Object)object);
    }
}

