/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.thirdParty.controller;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.rpc.service.AccountInvokeInquiryRpcService;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.enumerate.SupplierFrozenStatusEnum;
import com.els.modules.supplier.api.enumerate.SupplierStatusEnum;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.mapper.ElsTenantMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.mapper.RolePermissionMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.thirdParty.entity.ThirdPartyEntityHW;
import com.els.modules.thirdParty.service.ThirdPartyHWService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u534e\u4e3a\u4e91\u63a5\u5165\u5b9e\u4f8b"})
@RestController
@RequestMapping(value={"/thirdParty/thirdPartyHW"})
public class ThirdPartyHWController
extends BaseController<ThirdPartyEntityHW, ThirdPartyHWService> {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyHWController.class);
    private static final String HW_ACCESS_KEY = "64306fde-bb9f-4f42-800f-4114ab6f7e2e";
    private static final String CHARSET = "UTF-8";
    private static final String HWY_SOURCE = "\u534e\u4e3a\u4e91";
    private static final String PASS_WORD = "123456";
    private static final String ENCRYPT_TYPE_128 = "2";
    @Value(value="${els.config.service.address}")
    private String addressName;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ThirdPartyHWService thirdPartyHWService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired(required=false)
    private ImGroupInvokeRpcService baseImGroupService;
    @Autowired
    private ElsTenantMapper elsTenantMapper;
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private RolePermissionMapper rolePermissionMapper;
    @Autowired
    private RoleService roleService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private AccountInvokeInquiryRpcService accountInvokeInquiryRpcService;

    @ApiOperation(value="\u534e\u4e3a\u4e91\u5bf9\u63a5\u63a5\u53e3", notes="\u534e\u4e3a\u4e91\u5bf9\u63a5\u63a5\u53e3")
    @RequestMapping(value={"/accessInterface"})
    public JSONObject accessInterface(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = new JSONObject();
        boolean flag = ThirdPartyHWController.verificationRequestParams(request, HW_ACCESS_KEY);
        if (!flag) {
            jsonObject.put("resultCode", (Object)"000001");
            jsonObject.put("resultMsg", (Object)"\u9274\u6743\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
        } else {
            Map paramsMap = request.getParameterMap();
            String activity = ((String[])paramsMap.get("activity"))[0];
            if ("newInstance".equals(activity)) {
                jsonObject = this.newInstance(paramsMap);
            } else if ("refreshInstance".equals(activity)) {
                jsonObject = this.refreshInstance(paramsMap);
            } else if ("expireInstance".equals(activity)) {
                jsonObject = this.expireInstance(paramsMap);
            } else if ("releaseInstance".equals(activity)) {
                jsonObject = this.releaseInstance(paramsMap);
            } else if ("upgrade".equals(activity)) {
                jsonObject = this.upgrade(paramsMap);
            }
        }
        String needEncryptBody = jsonObject.toJSONString();
        String signature = "";
        try {
            signature = ThirdPartyHWController.generateResponseBodySignature(HW_ACCESS_KEY, needEncryptBody);
            log.info("ThirdPartyHWController.accessInterface: signature->" + signature);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.addHeader("Body-Sign", "sign_type=\"HMAC-SHA256\", signature=\"" + signature + "\"");
        return jsonObject;
    }

    private JSONObject newInstance(Map<String, String[]> paramsMap) {
        log.info("ThirdPartyHWController.newInstance->paramsMap: " + paramsMap.toString());
        JSONObject jsonObject = new JSONObject();
        JSONObject json = new JSONObject();
        String orderId = paramsMap.get("orderId")[0];
        boolean flag = true;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)this.redisUtil.get(orderId)))) {
            flag = false;
        } else {
            this.redisUtil.set(orderId, (Object)orderId);
        }
        if (flag) {
            JSONObject object;
            ThirdPartyEntityHW entity = new ThirdPartyEntityHW();
            entity.setOrderId(orderId);
            entity.setId(UUID.randomUUID().toString().replace("-", ""));
            String customerId = paramsMap.get("customerId")[0];
            entity.setCustomerId(customerId);
            String customerName = paramsMap.get("customerName")[0];
            entity.setCustomerName(customerName);
            String userId = "";
            if (null != paramsMap.get("userId") && paramsMap.get("userId").length > 0) {
                userId = paramsMap.get("userId")[0];
                entity.setUserId(userId);
            }
            String userName = "";
            if (null != paramsMap.get("userName") && paramsMap.get("userName").length > 0) {
                userName = paramsMap.get("userName")[0];
                entity.setUserName(userName);
            }
            if (null != paramsMap.get("mobilePhone") && paramsMap.get("mobilePhone").length > 0) {
                String mobilePhoneStr = paramsMap.get("mobilePhone")[0];
                String mobilePhone = ThirdPartyHWController.decryptMobilePhoneOrEMail(HW_ACCESS_KEY, mobilePhoneStr, ENCRYPT_TYPE_128);
                entity.setMobilephone(mobilePhone);
            }
            if (null != paramsMap.get("email") && paramsMap.get("email").length > 0) {
                String emailStr = paramsMap.get("email")[0];
                String email = ThirdPartyHWController.decryptMobilePhoneOrEMail(HW_ACCESS_KEY, emailStr, ENCRYPT_TYPE_128);
                entity.setEmail(email);
            }
            String businessId = paramsMap.get("businessId")[0];
            entity.setBusinessId(businessId);
            if (null != paramsMap.get("skuCode") && paramsMap.get("skuCode").length > 0) {
                String skuCode = paramsMap.get("skuCode")[0];
                entity.setSkuCode(skuCode);
            }
            String productId = paramsMap.get("productId")[0];
            entity.setProductId(productId);
            if (null != paramsMap.get("testFlag") && paramsMap.get("testFlag").length > 0) {
                String testFlag = paramsMap.get("testFlag")[0];
                entity.setTestFlag(Integer.valueOf(testFlag));
            } else {
                entity.setTestFlag(0);
            }
            if (null != paramsMap.get("trialFlag") && paramsMap.get("trialFlag").length > 0) {
                String trialFlag = paramsMap.get("trialFlag")[0];
                entity.setTrialFlag(Integer.valueOf(trialFlag));
            }
            if (null != paramsMap.get("expireTime") && paramsMap.get("expireTime").length > 0) {
                String expireTime = paramsMap.get("expireTime")[0];
                entity.setExpireTime(expireTime);
            }
            if (null != paramsMap.get("chargingMode") && paramsMap.get("chargingMode").length > 0) {
                String chargingMode = paramsMap.get("chargingMode")[0];
                entity.setChargingMode(Integer.valueOf(chargingMode));
            }
            if (null != paramsMap.get("saasExtendParams") && paramsMap.get("saasExtendParams").length > 0) {
                String saasExtendParams = paramsMap.get("saasExtendParams")[0];
                entity.setSaasExtendParams(saasExtendParams);
            }
            if (null != paramsMap.get("amount") && paramsMap.get("amount").length > 0) {
                String amount = paramsMap.get("amount")[0];
                entity.setAmount(Integer.valueOf(amount));
            }
            if (null != paramsMap.get("diskSize") && paramsMap.get("diskSize").length > 0) {
                String diskSize = paramsMap.get("diskSize")[0];
                entity.setDiskSize(Integer.valueOf(diskSize));
            }
            if (null != paramsMap.get("bandWidth") && paramsMap.get("bandWidth").length > 0) {
                String bandWidth = paramsMap.get("bandWidth")[0];
                entity.setBandWidth(Integer.valueOf(bandWidth));
            }
            if (null != paramsMap.get("periodType") && paramsMap.get("periodType").length > 0) {
                String periodType = paramsMap.get("periodType")[0];
                entity.setPeriodType(periodType);
            }
            if (null != paramsMap.get("periodNumber") && paramsMap.get("periodNumber").length > 0) {
                String periodNumber = paramsMap.get("periodNumber")[0];
                entity.setPeriodNumber(Integer.valueOf(periodNumber));
            }
            if (null != paramsMap.get("orderAmount") && paramsMap.get("orderAmount").length > 0) {
                String orderAmount = paramsMap.get("orderAmount")[0];
                entity.setOrderAmount(new BigDecimal(orderAmount));
            }
            if (null != paramsMap.get("provisionType") && paramsMap.get("provisionType").length > 0) {
                String provisionType = paramsMap.get("provisionType")[0];
                entity.setProvisionType(Integer.valueOf(provisionType));
            }
            if (null != paramsMap.get("acceptanceTime") && paramsMap.get("acceptanceTime").length > 0) {
                String acceptanceTime = paramsMap.get("acceptanceTime")[0];
                entity.setAcceptanceTime(acceptanceTime);
            }
            entity.setOverdue(0);
            entity.setReleased(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            this.thirdPartyHWService.saveThirdPartyHW(entity);
            String interfaceCode = "getEnterpriseInfo";
            JSONObject realBody = new JSONObject();
            JSONObject base = new JSONObject();
            base.put("name", (Object)customerName);
            base.put("els_account", (Object)"307001");
            base.put("app_code", (Object)"srm_dev");
            realBody.put("base", (Object)base);
            Result response = this.invokeBaseRpcService.callInterfacePost(interfaceCode, realBody);
            String elsAccount = "";
            if (response.isSuccess() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response.getMessage()) && org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(object = JSONObject.parseObject((String)response.getMessage())).getString("code")}) && "200".equals(object.getString("code"))) {
                ElsEnterpriseInfo elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)JSON.parseObject((String)object.getString("data"), ElsEnterpriseInfo.class));
                elsEnterpriseInfo.setDeleted(0);
                elsAccount = elsEnterpriseInfo.getElsAccount();
                this.elsEnterpriseInfoMapper.insert((Object)elsEnterpriseInfo);
                this.saveSubAccountInfo(elsAccount, userName);
                this.invokeBaseRpcService.callInterfacePost("add_enterprise_relation", this.makeEnterpriseRelationJson(TenantContext.getTenant(), elsAccount));
                ThirdAccount user = new ThirdAccount();
                user.setDeleted(CommonConstant.DEL_FLAG_0);
                user.setStatus(1);
                user.setThirdType(HWY_SOURCE);
                user.setRealname(elsEnterpriseInfo.getName());
                user.setThirdUserUuid(customerId + "_" + orderId);
                user.setUserId("1001");
                user.setElsAccount(elsAccount);
                user.setCreateTime(new Date());
                this.thirdAccountService.save((Object)user);
            }
            jsonObject.put("instanceId", (Object)entity.getId());
            json.put("userName", (Object)ThirdPartyHWController.generateSaaSUsernameOrPwd(HW_ACCESS_KEY, elsAccount + "_1001", ENCRYPT_TYPE_128));
        } else {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(ThirdPartyEntityHW::getOrderId, (Object)orderId);
            query.eq(ThirdPartyEntityHW::getReleased, (Object)0);
            ThirdPartyEntityHW one = (ThirdPartyEntityHW)this.thirdPartyHWService.getOne((Wrapper)query);
            jsonObject.put("instanceId", (Object)one.getId());
            ThirdAccount account = this.queryElsAccount(one.getId());
            json.put("userName", (Object)ThirdPartyHWController.generateSaaSUsernameOrPwd(HW_ACCESS_KEY, account.getElsAccount() + "_1001", ENCRYPT_TYPE_128));
        }
        jsonObject.put("resultCode", (Object)"000000");
        jsonObject.put("resultMsg", (Object)"\u64cd\u4f5c\u6210\u529f\uff01");
        jsonObject.put("encryptType", (Object)ENCRYPT_TYPE_128);
        json.put("frontEndUrl", (Object)this.addressName);
        json.put("adminUrl", (Object)this.addressName);
        json.put("password", (Object)ThirdPartyHWController.generateSaaSUsernameOrPwd(HW_ACCESS_KEY, PASS_WORD, ENCRYPT_TYPE_128));
        json.put("memo", (Object)("userName\uff1a" + ThirdPartyHWController.gbEncoding("ELS\u8d26\u53f7_\u5b50\u8d26\u53f7")));
        jsonObject.put("appInfo", (Object)json);
        log.info("ThirdPartyHWController.newInstance-> jsonObject: " + jsonObject.toJSONString());
        return jsonObject;
    }

    private JSONObject refreshInstance(Map<String, String[]> paramsMap) {
        String testFlag;
        log.info("ThirdPartyHWController.refreshInstance->paramsMap: " + paramsMap.toString());
        JSONObject jsonObject = new JSONObject();
        ThirdPartyEntityHW entity = new ThirdPartyEntityHW();
        String orderId = paramsMap.get("orderId")[0];
        String instanceId = paramsMap.get("instanceId")[0];
        String productId = paramsMap.get("productId")[0];
        String expireTime = paramsMap.get("expireTime")[0];
        if (null != paramsMap.get("testFlag") && paramsMap.get("testFlag").length > 0) {
            testFlag = paramsMap.get("testFlag")[0];
            entity.setTestFlag(Integer.valueOf(testFlag));
        }
        if (null != paramsMap.get("trialToFormal") && paramsMap.get("trialToFormal").length > 0) {
            testFlag = paramsMap.get("trialToFormal")[0];
        }
        if (null != paramsMap.get("periodType") && paramsMap.get("periodType").length > 0) {
            String periodType = paramsMap.get("periodType")[0];
            entity.setPeriodType(periodType);
        }
        if (null != paramsMap.get("periodNumber") && paramsMap.get("periodNumber").length > 0) {
            String periodNumber = paramsMap.get("periodNumber")[0];
            entity.setPeriodNumber(Integer.valueOf(periodNumber));
        }
        if (null != paramsMap.get("orderAmount") && paramsMap.get("orderAmount").length > 0) {
            String orderAmount = paramsMap.get("orderAmount")[0];
            entity.setOrderAmount(new BigDecimal(orderAmount));
        }
        entity.setId(instanceId);
        entity.setExpireTime(expireTime);
        entity.setUpdateTime(new Date());
        boolean result = this.thirdPartyHWService.updateById(entity);
        if (!result) {
            jsonObject.put("resultCode", (Object)"000005");
            jsonObject.put("resultMsg", (Object)"\u64cd\u4f5c\u5931\u8d25\uff01");
            return jsonObject;
        }
        jsonObject.put("resultCode", (Object)"000000");
        jsonObject.put("resultMsg", (Object)"\u64cd\u4f5c\u6210\u529f\uff01");
        ThirdAccount account = this.queryElsAccount(instanceId);
        if (null == account) {
            jsonObject.put("resultCode", (Object)"000005");
            jsonObject.put("resultMsg", (Object)("\u627e\u4e0d\u5230\u5b9e\u4f8b\uff1a" + instanceId + "\u5bf9\u5e94\u7684\u8d26\u53f7\uff01"));
            return jsonObject;
        }
        String elsAccount = account.getElsAccount();
        ElsTenant elsTenant = new ElsTenant();
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setAccountStatus("1");
        LambdaQueryWrapper param = new LambdaQueryWrapper();
        param.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        this.elsTenantMapper.update((Object)elsTenant, (Wrapper)param);
        return jsonObject;
    }

    private JSONObject expireInstance(Map<String, String[]> paramsMap) {
        log.info("ThirdPartyHWController.expireInstance->paramsMap: " + paramsMap.toString());
        JSONObject jsonObject = new JSONObject();
        ThirdPartyEntityHW entity = new ThirdPartyEntityHW();
        String instanceId = paramsMap.get("instanceId")[0];
        String orderId = paramsMap.get("orderId")[0];
        if (null != paramsMap.get("testFlag") && paramsMap.get("testFlag").length > 0) {
            String testFlag = paramsMap.get("testFlag")[0];
            entity.setTestFlag(Integer.valueOf(testFlag));
        }
        entity.setId(instanceId);
        entity.setOverdue(1);
        boolean result = this.thirdPartyHWService.updateById(entity);
        if (!result) {
            jsonObject.put("resultCode", (Object)"000005");
            jsonObject.put("resultMsg", (Object)"\u64cd\u4f5c\u5931\u8d25\uff01");
            return jsonObject;
        }
        jsonObject.put("resultCode", (Object)"000000");
        jsonObject.put("resultMsg", (Object)"\u64cd\u4f5c\u6210\u529f\uff01");
        ThirdAccount account = this.queryElsAccount(instanceId);
        if (null == account) {
            jsonObject.put("resultCode", (Object)"000005");
            jsonObject.put("resultMsg", (Object)("\u627e\u4e0d\u5230\u5b9e\u4f8b\uff1a" + instanceId + "\u5bf9\u5e94\u7684\u8d26\u53f7\uff01"));
            return jsonObject;
        }
        String elsAccount = account.getElsAccount();
        ElsTenant elsTenant = new ElsTenant();
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setAccountStatus(ENCRYPT_TYPE_128);
        LambdaQueryWrapper param = new LambdaQueryWrapper();
        param.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        this.elsTenantMapper.update((Object)elsTenant, (Wrapper)param);
        return jsonObject;
    }

    private JSONObject releaseInstance(Map<String, String[]> paramsMap) {
        log.info("ThirdPartyHWController.releaseInstance->paramsMap: " + paramsMap.toString());
        JSONObject jsonObject = new JSONObject();
        String instanceId = paramsMap.get("instanceId")[0];
        ThirdAccount account = this.queryElsAccount(instanceId);
        if (null == account) {
            jsonObject.put("resultCode", (Object)"000005");
            jsonObject.put("resultMsg", (Object)("\u627e\u4e0d\u5230\u5b9e\u4f8b\uff1a" + instanceId + "\u5bf9\u5e94\u7684\u8d26\u53f7\uff01"));
            return jsonObject;
        }
        ThirdPartyEntityHW entity = new ThirdPartyEntityHW();
        entity.setId(instanceId);
        entity.setReleased(1);
        boolean result = this.thirdPartyHWService.updateById(entity);
        if (!result) {
            jsonObject.put("resultCode", (Object)"000005");
            jsonObject.put("resultMsg", (Object)"\u64cd\u4f5c\u5931\u8d25\uff01");
            return jsonObject;
        }
        jsonObject.put("resultCode", (Object)"000000");
        jsonObject.put("resultMsg", (Object)"\u64cd\u4f5c\u6210\u529f\uff01");
        String elsAccount = account.getElsAccount();
        ElsTenant elsTenant = new ElsTenant();
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setAccountStatus(ENCRYPT_TYPE_128);
        LambdaQueryWrapper param = new LambdaQueryWrapper();
        param.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        this.elsTenantMapper.update((Object)elsTenant, (Wrapper)param);
        return jsonObject;
    }

    private JSONObject upgrade(Map<String, String[]> paramsMap) {
        log.info("ThirdPartyHWController.upgrade->paramsMap: " + paramsMap.toString());
        JSONObject jsonObject = new JSONObject();
        ThirdPartyEntityHW entity = new ThirdPartyEntityHW();
        String instanceId = paramsMap.get("instanceId")[0];
        if (null != paramsMap.get("testFlag") && paramsMap.get("testFlag").length > 0) {
            String testFlag = paramsMap.get("testFlag")[0];
            entity.setTestFlag(Integer.valueOf(testFlag));
        }
        String orderId = paramsMap.get("orderId")[0];
        String skuCode = paramsMap.get("skuCode")[0];
        String productId = paramsMap.get("productId")[0];
        String timeStamp = paramsMap.get("timeStamp")[0];
        if (null != paramsMap.get("amount") && paramsMap.get("amount").length > 0) {
            String amount = paramsMap.get("amount")[0];
            entity.setAmount(Integer.valueOf(amount));
        }
        if (null != paramsMap.get("diskSize") && paramsMap.get("diskSize").length > 0) {
            String diskSize = paramsMap.get("diskSize")[0];
            entity.setDiskSize(Integer.valueOf(diskSize));
        }
        if (null != paramsMap.get("bandWidth") && paramsMap.get("bandWidth").length > 0) {
            String bandWidth = paramsMap.get("bandWidth")[0];
            entity.setBandWidth(Integer.valueOf(bandWidth));
        }
        entity.setId(instanceId);
        entity.setSkuCode(skuCode);
        entity.setProductId(productId);
        entity.setUpdateTime(new Date());
        entity.setOverdue(0);
        entity.setReleased(0);
        boolean result = this.thirdPartyHWService.updateById(entity);
        if (!result) {
            jsonObject.put("resultCode", (Object)"000005");
            jsonObject.put("resultMsg", (Object)"\u64cd\u4f5c\u5931\u8d25\uff01");
            return jsonObject;
        }
        jsonObject.put("resultCode", (Object)"000000");
        jsonObject.put("resultMsg", (Object)"\u64cd\u4f5c\u6210\u529f\uff01");
        ThirdAccount account = this.queryElsAccount(instanceId);
        if (null == account) {
            jsonObject.put("resultCode", (Object)"000005");
            jsonObject.put("resultMsg", (Object)("\u627e\u4e0d\u5230\u5b9e\u4f8b\uff1a" + instanceId + "\u5bf9\u5e94\u7684\u8d26\u53f7\uff01"));
            return jsonObject;
        }
        String elsAccount = account.getElsAccount();
        ElsTenant elsTenant = new ElsTenant();
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setAccountStatus("1");
        LambdaQueryWrapper param = new LambdaQueryWrapper();
        param.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        this.elsTenantMapper.update((Object)elsTenant, (Wrapper)param);
        return jsonObject;
    }

    private ThirdAccount queryElsAccount(String instanceId) {
        log.info("ThirdPartyHWController.queryElsAccount->instanceId: " + instanceId);
        ThirdPartyEntityHW entityHW = (ThirdPartyEntityHW)this.thirdPartyHWService.getById((Serializable)((Object)instanceId));
        String customerId = entityHW.getCustomerId();
        String oldOrderId = entityHW.getOrderId();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)(customerId + "_" + oldOrderId));
        ThirdAccount account = (ThirdAccount)((Object)this.thirdAccountService.getOne((Wrapper)query));
        return account;
    }

    public void saveSupplierMasterData(ElsEnterpriseInfo elsEnterpriseInfo, SupplierMasterDataDTO data, String elsAccount) {
        data.setElsAccount(elsAccount);
        data.setToElsAccount(elsEnterpriseInfo.getElsAccount());
        data.setSupplierName(elsEnterpriseInfo.getName());
        data.setSourceType(ENCRYPT_TYPE_128);
        data.setStatus(SupplierFrozenStatusEnum.NORMAL.getValue());
        data.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
        data.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        this.accountInvokeInquiryRpcService.insertSupplierMasterData(data);
    }

    public void saveSubAccountInfo(String elsAccount, String userName) {
        ElsSubAccount account = new ElsSubAccount();
        account.setElsAccount(elsAccount);
        account.setSubAccount("1001");
        account.setRealname(userName);
        account.setStatus(1);
        String salt = ConvertUtils.randomGen((int)8);
        account.setSalt(salt);
        String password = PASS_WORD;
        String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + account.getSubAccount()), (String)password, (String)salt);
        account.setPassword(passwordEncode);
        account.setDeleted(0);
        Role role = new Role();
        role.setElsAccount(elsAccount);
        role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
        role.setRoleCode("yun");
        this.roleMapper.insert(role);
        this.elsSubAccountService.addUserWithRole(account, role.getId());
        try {
            this.baseImGroupService.initGroup(account.getId());
        }
        catch (Exception e) {
            log.error("::: \u521d\u59cb\u5316\u7528\u6237\u5206\u7ec4{}\u5931\u8d25==>{}", (Object)account.getId(), (Object)e.getMessage());
        }
        ElsTenant elsTenant = new ElsTenant();
        elsTenant.setAccountStatus("1");
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setCompanyName(userName);
        elsTenant.setSourceType(ENCRYPT_TYPE_128);
        try {
            elsTenant.setExpiryDate(new SimpleDateFormat("yyyy-MM-dd").parse("2029-12-31"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.elsTenantMapper.insert((Object)elsTenant);
        TenantContext.setTenant((String)"100000");
        LambdaQueryWrapper param = new LambdaQueryWrapper();
        param.eq(Role::getRoleCode, (Object)"yun");
        Role one = (Role)this.roleService.getOne((Wrapper)param);
        if (null != one) {
            List list = this.rolePermissionMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(RolePermission::getRoleId, (Object)one.getId()));
            HashMap<String, String> map = new HashMap<String, String>();
            if (list != null) {
                for (RolePermission rolePermission : list) {
                    RolePermission entity = new RolePermission();
                    entity.setElsAccount(elsAccount);
                    entity.setRoleId(role.getId());
                    entity.setPermissionId(rolePermission.getPermissionId());
                    this.rolePermissionMapper.insert(entity);
                    map.put(rolePermission.getPermissionId(), "1");
                }
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            List permissionList = this.permissionMapper.selectList((Wrapper)queryWrapper);
            if (permissionList != null) {
                ArrayList<CompanyPermission> companyPermissions = new ArrayList<CompanyPermission>();
                for (Permission permission : permissionList) {
                    if (!"1".equals(map.get(permission.getId()))) continue;
                    CompanyPermission companyPermission = new CompanyPermission();
                    companyPermission.setId(IdWorker.getIdStr());
                    companyPermission.setElsAccount(elsAccount);
                    companyPermission.setPermissionId(permission.getId());
                    companyPermission.setName(permission.getName());
                    companyPermission.setSortNo(permission.getSortNo());
                    companyPermission.setIcon(permission.getIcon());
                    companyPermission.setIconColor(permission.getIconColor());
                    companyPermission.setRuleFlag(permission.getRuleFlag());
                    companyPermission.setStatus(permission.getStatus());
                    companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
                    companyPermission.setUpdateTime(new Date());
                    companyPermissions.add(companyPermission);
                }
                if (!companyPermissions.isEmpty()) {
                    this.permissionMapper.insertCompanyMeunBatch(companyPermissions);
                }
            }
        }
    }

    public JSONObject makeEnterpriseRelationJson(String purchaseAccount, String providerAccount) {
        JSONObject base = new JSONObject();
        base.put("purchaser_els_account", (Object)purchaseAccount);
        base.put("provider_els_account", (Object)providerAccount);
        base.put("els_account", (Object)TenantContext.getTenant());
        base.put("app_code", (Object)"7eceb23fe36a4a9c9de4098f7b4b244b");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("header", (Object)this.makeHeader());
        jsonObject.put("base", (Object)base);
        return jsonObject;
    }

    public JSONObject makeHeader() {
        JSONObject header = new JSONObject();
        header.put("app-security", (Object)"de324586-8180-11eb-89be-506b4bdb8f79");
        header.put("app-key", (Object)"caa7b92f-8180-11eb-89be-506b4bdb8f79");
        header.put("app-code", (Object)"interface_platform");
        return header;
    }

    public static boolean verificationRequestParams(HttpServletRequest request, String accessKey) {
        String[] authTokenArray;
        Map paramsMap = request.getParameterMap();
        log.info("ThirdPartyHWController.verificationRequestParams->paramsMap: " + paramsMap.toString());
        String timeStamp = "";
        String authToken = "";
        String[] timeStampArray = (String[])paramsMap.get("timeStamp");
        if (null != timeStampArray && timeStampArray.length > 0) {
            timeStamp = timeStampArray[0];
        }
        if (null != (authTokenArray = (String[])paramsMap.get("authToken")) && authTokenArray.length > 0) {
            String authTokenStr = authTokenArray[0];
            authToken = URLDecoder.decode(authTokenStr);
        }
        TreeMap sortedMap = new TreeMap();
        sortedMap.putAll(paramsMap);
        sortedMap.remove("authToken");
        StringBuffer strBuffer = new StringBuffer();
        Set keySet = sortedMap.keySet();
        for (String key : keySet) {
            String value = ((String[])sortedMap.get(key))[0];
            strBuffer.append("&").append(key).append("=").append(value);
        }
        String reqParams = strBuffer.toString().substring(1);
        String key = accessKey + timeStamp;
        String signature = null;
        try {
            String signatureStr = ThirdPartyHWController.generateResponseBodySignature(key, reqParams);
            signature = URLDecoder.decode(signatureStr);
        }
        catch (UnsupportedEncodingException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException exception) {
            // empty catch block
        }
        log.info("ThirdPartyHWController.verificationRequestParams->authToken: " + authToken + ", signature: " + signature);
        return authToken.equals(signature);
    }

    public static String generateResponseBodySignature(String key, String body) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        log.info("ThirdPartyHWController.generateResponseBodySignature->key: " + key + ",body: " + body);
        return ThirdPartyHWController.base_64(ThirdPartyHWController.hmacSHA256(key, body));
    }

    public static byte[] hmacSHA256(String macKey, String macData) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, UnsupportedEncodingException {
        log.info("ThirdPartyHWController.hmacSHA256->mackey: " + macKey + ",macData: " + macData);
        SecretKeySpec secret = new SecretKeySpec(macKey.getBytes(CHARSET), "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(secret);
        byte[] doFinal = mac.doFinal(macData.getBytes(CHARSET));
        return doFinal;
    }

    public static String base_64(byte[] bytes) {
        try {
            return new String(Base64.encodeBase64((byte[])bytes), CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String generateSaaSUsernameOrPwd(String key, String str, String type) {
        log.info("ThirdPartyHWController.generateSaaSUsernameOrPwd->key: " + key + ",str: " + str + ", type: " + type);
        String iv = ThirdPartyHWController.getRandomChars(16);
        String afterEncryptStr = "";
        int encryptLength = 256;
        if (!"1".equals(type)) {
            encryptLength = 128;
        }
        try {
            afterEncryptStr = ThirdPartyHWController.encryptAESCBCEncode(str, key, iv, encryptLength);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        System.out.println(afterEncryptStr);
        return iv + afterEncryptStr;
    }

    public static String getRandomChars(int length) {
        String randomChars = "";
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            if (random.nextInt(2) % 2 == 0) {
                int letterIndex = random.nextInt(2) % 2 == 0 ? 65 : 97;
                randomChars = randomChars + (char)(random.nextInt(26) + letterIndex);
                continue;
            }
            randomChars = randomChars + String.valueOf(random.nextInt(10));
        }
        return randomChars;
    }

    public static String encryptAESCBCEncode(String content, String key, String iv, int encryptLength) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if (StringUtils.isEmpty((String)content) || StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)iv)) {
            return null;
        }
        try {
            return ThirdPartyHWController.base_64(ThirdPartyHWController.encryptAESCBC(content.getBytes(CHARSET), key.getBytes(CHARSET), iv.getBytes(CHARSET), encryptLength));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptAESCBC(byte[] content, byte[] keyBytes, byte[] iv, int encryptLength) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyBytes);
        keyGenerator.init(encryptLength, secureRandom);
        SecretKey key = keyGenerator.generateKey();
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)key, new IvParameterSpec(iv));
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static String decryptMobilePhoneOrEMail(String key, String str, String type) {
        if (null != str && str.length() > 16) {
            String iv = str.substring(0, 16);
            String encryptStr = str.substring(16);
            String result = null;
            int encryptLength = 256;
            if (!"1".equals(type)) {
                encryptLength = 128;
            }
            try {
                result = ThirdPartyHWController.decryptAESCBCEncode(encryptStr, key, iv, encryptLength);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                e.printStackTrace();
                log.error("ThirdPartyHWController.decryptMobilePhoneOrEMail has erro: ", (Object)e.getMessage());
            }
            return result;
        }
        return null;
    }

    public static String decryptAESCBCEncode(String content, String key, String iv, int encryptType) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if (StringUtils.isEmpty((String)content) || StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)iv)) {
            return null;
        }
        return new String(ThirdPartyHWController.decryptAESCBC(Base64.decodeBase64((byte[])content.getBytes()), key.getBytes(), iv.getBytes(), encryptType));
    }

    public static byte[] decryptAESCBC(byte[] content, byte[] keyBytes, byte[] iv, int encryptType) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyBytes);
        keyGenerator.init(encryptType, secureRandom);
        SecretKey key = keyGenerator.generateKey();
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static String gbEncoding(String str) {
        char[] utfBytes = str.toCharArray();
        String unicodeBytes = "";
        for (int i = 0; i < utfBytes.length; ++i) {
            String hexB = Integer.toHexString(utfBytes[i]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes = unicodeBytes + "\\u" + hexB;
        }
        return unicodeBytes;
    }
}

