/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.els.common.util.AssertI18nUtil;
import com.els.common.util.I18nUtil;
import com.els.modules.system.enums.PwComplexityVerifyEnum;
import com.els.modules.system.enums.i18n.I18nElsPwSecurityEnum;
import com.els.modules.system.util.LocalDateTimeUtil;
import java.util.Date;
import java.util.Map;

public class PwVerifyUtil {
    private PwVerifyUtil() {
    }

    public static void pwComplexityVerify(Map<String, Integer> pwComplexityItem, String pwString) {
        if (pwComplexityItem.isEmpty()) {
            return;
        }
        Map<String, PwComplexityVerifyEnum> enumMap = PwComplexityVerifyEnum.getEnumMap();
        for (Map.Entry<String, Integer> entry : pwComplexityItem.entrySet()) {
            if (!enumMap.containsKey(entry.getKey()) || entry.getValue() == null || entry.getValue() == 0) continue;
            PwComplexityVerifyEnum pwComplexityVerifyEnum = enumMap.get(entry.getKey());
            AssertI18nUtil.isTrue((!pwComplexityVerifyEnum.verify(pwString) ? 1 : 0) != 0, (Enum)pwComplexityVerifyEnum.ii18nEnum());
        }
    }

    public static void pwMinLengthVerify(String pwString, int minLength) {
        AssertI18nUtil.isTrue((minLength != 0 && pwString.length() < minLength ? 1 : 0) != 0, (Enum)I18nElsPwSecurityEnum.I18N_MIN_LENGTH);
    }

    public static String pwModifyIntervalVerify(Date lastModifyDate, int modifyInterval) {
        if (modifyInterval == 0 || !LocalDateTimeUtil.compareMonthLater(lastModifyDate, modifyInterval)) {
            return null;
        }
        return I18nUtil.translate((Enum)I18nElsPwSecurityEnum.I18N_MODIFY_INTERVAL, (String[])new String[]{String.valueOf(modifyInterval)});
    }
}

