/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.UserRoleAspectVO;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRoleServiceImpl
extends ServiceImpl<UserRoleMapper, UserRole>
implements UserRoleService {
    @Autowired
    private ElsSubAccountService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public Map<String, String> queryUserRole() {
        List uRoleList = this.list();
        List userList = this.userService.list();
        List roleList = this.roleService.list();
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        String userId = "";
        String roleId = "";
        String roleName = "";
        if (uRoleList != null && uRoleList.size() > 0) {
            for (UserRole uRole : uRoleList) {
                roleId = uRole.getRoleId();
                for (ElsSubAccount user : userList) {
                    userId = user.getId();
                    if (!uRole.getUserId().equals(userId)) continue;
                    roleName = this.searchByRoleId(roleList, roleId);
                    map.put(userId, roleName);
                }
            }
            return map;
        }
        return map;
    }

    private String searchByRoleId(List<Role> roleList, String roleId) {
        Role role;
        block0: while (true) {
            Iterator<Role> iterator = roleList.iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!roleId.equals((role = iterator.next()).getId()));
            break;
        }
        return role.getRoleName();
    }

    @Override
    public String getAdminFlag(String elsAccount, String subAccount) {
        List<String> roleCodes = ((UserRoleMapper)this.baseMapper).getRoleByUserName(elsAccount, subAccount);
        if (!roleCodes.isEmpty()) {
            if (roleCodes.contains("admin")) {
                return "1";
            }
            if (roleCodes.contains("companyAdmin")) {
                return "1";
            }
        }
        return "0";
    }

    @Override
    public List<UserRoleAspectVO> getUserRoleByELSAccountAndSubAccount(LoginUser sysUser) {
        List userRoleList = null;
        if (this.redisUtil.hasKey("ELSACCOUNT_SUBACCOUNT" + sysUser.getElsAccount() + sysUser.getSubAccount())) {
            userRoleList = (List)this.redisUtil.get("ELSACCOUNT_SUBACCOUNT" + sysUser.getElsAccount() + sysUser.getSubAccount());
        } else {
            userRoleList = this.userRoleMapper.getUserRoleByELSAccountAndSubAccount(sysUser.getElsAccount(), sysUser.getSubAccount());
            this.redisUtil.set("ELSACCOUNT_SUBACCOUNT" + sysUser.getElsAccount() + sysUser.getSubAccount(), (Object)userRoleList);
        }
        return userRoleList;
    }

    @Override
    public Boolean getCustomerRoleFlag(String elsAccount, String subAccount) {
        List<String> roleCodes = ((UserRoleMapper)this.baseMapper).getRoleByUserName(elsAccount, subAccount);
        return roleCodes.contains("qqtCustomerRole");
    }

    @Override
    public ElsSubAccount getCustomerRoleUser() {
        String currentAccount = TenantContext.getTenant();
        TenantContext.setTenant((String)"100000");
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{Role::getId});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(Role::getRoleCode, (Object)"qqtCustomerRole")).eq(Role::getElsAccount, (Object)"100000")).last(" limit 1");
        Role one = (Role)this.roleService.getOne((Wrapper)wrapper);
        TenantContext.setTenant((String)currentAccount);
        if (null == one) {
            return this.getAdmin();
        }
        LambdaQueryWrapper ur = Wrappers.lambdaQuery();
        ur.select(new SFunction[]{UserRole::getUserId});
        ur.eq(UserRole::getRoleId, (Object)one.getId());
        List userRoles = this.userRoleMapper.selectList((Wrapper)ur);
        if (CollUtil.isEmpty((Collection)userRoles)) {
            return this.getAdmin();
        }
        LambdaQueryWrapper u = Wrappers.lambdaQuery();
        u.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getAvatar, ElsSubAccount::getWorkNo, ElsSubAccount::getRealname});
        ((LambdaQueryWrapper)u.in(BaseEntity::getId, (Collection)userRoles.stream().map(UserRole::getUserId).collect(Collectors.toList()))).eq(BaseEntity::getElsAccount, (Object)"100000");
        List list = this.userService.list((Wrapper)u);
        Random rand = new Random();
        return CollUtil.isEmpty((Collection)list) ? this.getAdmin() : (ElsSubAccount)((Object)list.get(rand.nextInt(list.size())));
    }

    private ElsSubAccount getAdmin() {
        LambdaQueryWrapper q = Wrappers.lambdaQuery();
        q.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getAvatar, ElsSubAccount::getWorkNo, ElsSubAccount::getRealname});
        ((LambdaQueryWrapper)q.eq(BaseEntity::getElsAccount, (Object)"100000")).eq(ElsSubAccount::getSubAccount, (Object)"admin");
        return (ElsSubAccount)((Object)this.userService.getOne((Wrapper)q));
    }
}

