/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="accountExportServiceImpl")
public class AccountExportServiceImpl
extends BaseExportService<ElsSubAccount, ElsSubAccountVO> {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;

    public List<ElsSubAccountVO> queryExportData(QueryWrapper<ElsSubAccount> queryWrapper, Map<String, Object> paramMap) {
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List pageList = this.elsSubAccountService.list((Wrapper)queryWrapper);
        List result = Convert.toList(ElsSubAccountVO.class, (Object)pageList);
        List<String> codes = result.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getOrgCode())).flatMap(x -> Arrays.stream(x.getOrgCode().split(","))).distinct().collect(Collectors.toList());
        Map<String, String> orgMap = this.systemInvokeOrganizationInfoRpcService.listDeptOrganization(codes);
        for (ElsSubAccountVO elsSubAccount : result) {
            String orgCode = elsSubAccount.getOrgCode();
            if (!StrUtil.isNotEmpty((CharSequence)orgCode)) continue;
            ArrayList ids = Lists.newArrayList((Object[])orgCode.split(","));
            String org = ids.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
            elsSubAccount.setOrgCode_dictText(org);
        }
        return result;
    }
}

