/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.qip.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.modules.qip.entity.QipProductAttribute;
import com.els.modules.qip.entity.QipProductData;
import com.els.modules.qip.service.QipProductAttributeService;
import com.els.modules.qip.service.QipProductBillingItemService;
import com.els.modules.qip.service.QipProductControlConditionService;
import com.els.modules.qip.service.QipProductDataService;
import com.els.modules.qip.vo.QipProductAttributeVO;
import com.els.modules.qip.vo.QipProductDataVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/qip/qipProductData"})
@Api(tags={"QIP\u4ea7\u54c1\u4e3b\u6570\u636e"})
public class QipProductDataController
extends BaseController<QipProductData, QipProductDataService> {
    @Autowired
    private QipProductDataService qipProductDataService;
    @Autowired
    private QipProductAttributeService qipProductAttributeService;
    @Autowired
    private QipProductBillingItemService qipProductBillingItemService;
    @Autowired
    private QipProductControlConditionService qipProductControlConditionService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(QipProductData qipProductData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)qipProductData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.qipProductDataService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="QIP\u4ea7\u54c1\u4e3b\u6570\u636e", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody QipProductDataVO qipProductDataPage) {
        QipProductData qipProductData = new QipProductData();
        BeanUtils.copyProperties((Object)((Object)qipProductDataPage), (Object)((Object)qipProductData));
        this.qipProductDataService.saveMain(qipProductData, qipProductDataPage.getProductAttributeList());
        return Result.ok((Object)((Object)qipProductData));
    }

    @AutoLog(busModule="QIP\u4ea7\u54c1\u4e3b\u6570\u636e", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody QipProductDataVO qipProductDataPage) {
        QipProductData qipProductData = new QipProductData();
        BeanUtils.copyProperties((Object)((Object)qipProductDataPage), (Object)((Object)qipProductData));
        this.qipProductDataService.updateMain(qipProductData, qipProductDataPage.getProductAttributeList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="QIP\u4ea7\u54c1\u4e3b\u6570\u636e", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.qipProductDataService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="QIP\u4ea7\u54c1\u4e3b\u6570\u636e", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.qipProductDataService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        QipProductData qipProductData = (QipProductData)((Object)this.qipProductDataService.getById((Serializable)((Object)id)));
        QipProductDataVO qipProductDataVO = new QipProductDataVO();
        BeanUtils.copyProperties((Object)((Object)qipProductData), (Object)((Object)qipProductDataVO));
        List<QipProductAttribute> qipProductAttributeList = this.qipProductAttributeService.selectByMainId(id);
        if (!qipProductAttributeList.isEmpty()) {
            ArrayList attributes = SysUtil.copyProperties(qipProductAttributeList, QipProductAttributeVO.class);
            for (QipProductAttributeVO attributeVO : attributes) {
                attributeVO.setBillingItemList(this.qipProductBillingItemService.selectByMainId(attributeVO.getId()));
                attributeVO.setControlCondtionList(this.qipProductControlConditionService.selectByMainId(attributeVO.getId()));
            }
            qipProductDataVO.setProductAttributeList(attributes);
        }
        return Result.ok((Object)((Object)qipProductDataVO));
    }

    @ApiOperation(value="\u901a\u8fc7QIP\u4ea7\u54c1\u4e3b\u6570\u636eid\u67e5\u8be2QIP\u4ea7\u54c1\u5c5e\u6027", notes="\u901a\u8fc7QIP\u4ea7\u54c1\u4e3b\u6570\u636eid\u67e5\u8be2QIP\u4ea7\u54c1\u5c5e\u6027")
    @GetMapping(value={"/queryQipProductAttributeByMainId"})
    public Result<?> queryQipProductAttributeListByMainId(@RequestParam(name="id") String id) {
        List<QipProductAttribute> qipProductAttributeList = this.qipProductAttributeService.selectByMainId(id);
        return Result.ok(qipProductAttributeList);
    }

    @AutoLog(busModule="QIP\u4ea7\u54c1\u4e3b\u6570\u636e", value="\u63a5\u6536\u4ea7\u54c1\u4e3b\u6570\u636e")
    @ApiOperation(value="\u63a5\u6536\u4ea7\u54c1\u4e3b\u6570\u636e", notes="\u63a5\u6536\u4ea7\u54c1\u4e3b\u6570\u636e")
    @PostMapping(value={"/noToken/receiveProductData"})
    public Result<?> receiveProductData(@RequestBody QipProductDataVO qipProductDataPage) {
        this.qipProductDataService.handleReceiveData(qipProductDataPage);
        return this.commonSuccessResult(3);
    }
}

