/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.thirdParty.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.modules.account.rpc.service.AccountInvokeInquiryRpcService;
import com.els.modules.demand.api.dto.PurchaseRequestHeadDTO;
import com.els.modules.demand.api.dto.PurchaseRequestItemDTO;
import com.els.modules.inquiry.api.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.thirdParty.dto.DApiAssureOrderReceive;
import com.els.modules.thirdParty.dto.DApiChangeOrderStatus;
import com.els.modules.thirdParty.dto.DApiMessage;
import com.els.modules.thirdParty.dto.DApiOrder;
import com.els.modules.thirdParty.dto.DApiOrderApprove;
import com.els.modules.thirdParty.dto.DApiOrderCommit;
import com.els.modules.thirdParty.dto.DApiOrderInterfaceLog;
import com.els.modules.thirdParty.dto.DApiOrderInvoice;
import com.els.modules.thirdParty.dto.DApiOrderPayment;
import com.els.modules.thirdParty.dto.DApiOrderReceive;
import com.els.modules.thirdParty.dto.DApiOrderShipment;
import com.els.modules.thirdParty.dto.DApiOrderSku;
import com.els.modules.thirdParty.dto.DApiPaymentOrder;
import com.els.modules.thirdParty.dto.DApiPurchaseOrderReceive;
import com.els.modules.thirdParty.dto.DApiSinoPrItem;
import com.els.modules.thirdParty.dto.EpecResult;
import com.els.modules.thirdParty.dto.EpecToken;
import com.els.modules.thirdParty.util.EpecApiUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6613\u6d3e\u5ba2sdk\u5bf9\u63a5"})
@RestController
@RequestMapping(value={"/account/sdk"})
public class SDKController {
    private static final Logger log = LoggerFactory.getLogger(SDKController.class);
    @Resource
    private AccountInvokeInquiryRpcService accountInvokeInquiryRpcService;
    private static final String urlAddress = "http://uat-api.epec.com";
    private static String clientId = "40247380";
    private static String clientSecret = "51d94982-0731-4fe6-9909-8a8287663085";
    private static String companyId = "128986";
    private static String userName = "api_40247380";
    private static String pd = "18f9c94564fc4654ae47888e6b006317";
    private static String tenantId = "991";
    private static String CORPCODE = "40247380";

    @PostMapping(value={"/addPurchaseApply"})
    public Result<?> addPurchaseApply(@RequestBody List<PurchaseRequestItemDTO> purchaseRequestItems) {
        log.info("\u8f93\u5165\u53c2\u6570:[{}]", (Object)purchaseRequestItems.toString());
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        ArrayList<DApiSinoPrItem> orderList = new ArrayList<DApiSinoPrItem>();
        for (PurchaseRequestItemDTO requestItem : purchaseRequestItems) {
            DApiSinoPrItem item = new DApiSinoPrItem();
            item.setIntqty(requestItem.getQuantity());
            item.setPurchaseRequestType("1");
            item.setUnit(requestItem.getBaseUnit());
            item.setRequestno(requestItem.getRequestNumber());
            item.setItemno(requestItem.getItemNumber());
            item.setCorpcode(CORPCODE);
            if (requestItem.getDeliveryDate() != null) {
                item.setNeeddate(this.formatString(requestItem.getDeliveryDate()));
            } else {
                item.setNeeddate("20210529");
            }
            item.setApimaterNo(requestItem.getMaterialNumber());
            item.setProdname(requestItem.getMaterialDesc());
            item.setSpeco(requestItem.getMaterialSpec());
            item.setResourcefrom(requestItem.getFactory());
            item.setConaddr(requestItem.getStorageLocation());
            item.setProjectnm(requestItem.getProjectName());
            item.setProjectno(requestItem.getProjectNumber());
            orderList.add(item);
        }
        String data = JSONArray.toJSONString(orderList);
        EpecResult result = EpecApiUtil.invokeAPI("http://uat-api.epec.com/apigate/v2/order/addPurchaseApply", accessToken, data);
        if (!result.isSuccess()) {
            return Result.error((String)result.getMessage());
        }
        this.accountInvokeInquiryRpcService.updatePurchaseRequestItemStatus(purchaseRequestItems, PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue());
        return Result.ok((String)JSONObject.toJSONString((Object)result));
    }

    private String formatString(Date date) {
        LocalDateTime today = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        return dtf.format(today);
    }

    public static void main(String[] args) {
        SDKController.refreshToken();
        SDKController.getMessages();
        SDKController.removeMessages();
        SDKController.TestAddPurchaseApply();
        SDKController.orderApprove();
        SDKController.paymentOrder();
        SDKController.receiveGoods();
        SDKController.getMembers();
        SDKController.orderInterface();
    }

    @GetMapping(value={"/getToken"})
    public static Result<?> getToken() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        log.info("SDKController --> getToken  result:[{}]", (Object)epecToken.toString());
        return Result.ok((String)accessToken);
    }

    @GetMapping(value={"/refreshToken"})
    public static Result<?> refreshToken() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String refreshToken = epecToken.getRefreshToekn();
        EpecToken newToken = EpecApiUtil.refreshToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, refreshToken);
        return Result.ok((String)JSONObject.toJSONString((Object)newToken));
    }

    @GetMapping(value={"/getMessages"})
    public static Result<?> getMessages() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        List<DApiMessage> list = EpecApiUtil.getMessages("http://uat-api.epec.com/apigate/v2/message/getMessage", accessToken, null);
        log.info("SDKController-->getMessages\uff1aDApiMessages[{}]", (Object)JSONArray.toJSONString((Object)list.size()));
        for (DApiMessage dApiMessage : list) {
            Serializable serializable;
            String messageType = dApiMessage.getMessageType();
            String messageBody = dApiMessage.getMessageBody();
            Long messageId = dApiMessage.getMessageId();
            if ("orderINFO".equals(messageType) && StringUtils.isNotEmpty((CharSequence)messageBody)) {
                DApiOrderCommit parseObject = (DApiOrderCommit)JSON.parseObject((String)messageBody, DApiOrderCommit.class);
                DApiOrder geteOrder = parseObject.getEOrder();
                List<DApiOrderSku> geteOrderSkulist = parseObject.getEOrderSkulist();
                List<DApiOrderInvoice> geteOrderInvoiceList = parseObject.getEOrderInvoiceList();
                List<DApiOrderShipment> geteOrderShipmentList = parseObject.getEOrderShipmentList();
                String corpcode = geteOrder.getCorpcode();
                System.out.println(corpcode);
                System.out.println(JSON.toJSON((Object)parseObject));
                continue;
            }
            if ("orderStatus".equals(messageType) && StringUtils.isNotEmpty((CharSequence)messageBody)) {
                serializable = (DApiChangeOrderStatus)JSON.parseObject((String)messageBody, DApiChangeOrderStatus.class);
                continue;
            }
            if ("receive".equals(messageType) && StringUtils.isNotEmpty((CharSequence)messageBody)) {
                serializable = (DApiOrderReceive)JSON.parseObject((String)messageBody, DApiOrderReceive.class);
                continue;
            }
            if (messageType.equals("payInfo") && StringUtils.isNotEmpty((CharSequence)messageBody)) {
                serializable = (DApiPaymentOrder)JSON.parseObject((String)messageBody, DApiPaymentOrder.class);
                continue;
            }
            if (!messageType.equals("receiveAssure") || !StringUtils.isNotEmpty((CharSequence)messageBody)) continue;
            serializable = (DApiAssureOrderReceive)JSON.parseObject((String)messageBody, DApiAssureOrderReceive.class);
        }
        return Result.ok();
    }

    @GetMapping(value={"/removeMessages"})
    public static Result<?> removeMessages() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        ArrayList<Long> messageIds = new ArrayList<Long>();
        messageIds.add(401491L);
        messageIds.add(401495L);
        messageIds.add(401496L);
        messageIds.add(401497L);
        messageIds.add(401499L);
        messageIds.add(401500L);
        messageIds.add(401501L);
        messageIds.add(401502L);
        messageIds.add(401503L);
        EpecResult result = EpecApiUtil.removeMessages("http://uat-api.epec.com/apigate/v2/message/removeMessages", accessToken, messageIds);
        return Result.ok((String)JSONObject.toJSONString((Object)result));
    }

    public static void TestAddPurchaseApply() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        ArrayList<DApiSinoPrItem> orderList = new ArrayList<DApiSinoPrItem>();
        DApiSinoPrItem item = new DApiSinoPrItem();
        item.setConaddr("\u6d4b\u8bd5");
        item.setIntqty(new BigDecimal("100"));
        item.setNeeddate("20190119");
        item.setApimaterNo("YB24500A000003S11");
        item.setProdname("\u67f4\u6cb9\u6297\u78e8\u5242QSHCG65\u8102\u80aa\u9178\u578b");
        item.setProjectnm("\u63a5\u53e3\u6d4b\u8bd5");
        item.setProjectno("27333221");
        item.setPurchaseRequestType("1");
        item.setResourcefrom("YSM1");
        item.setSpeco("Q/SHCG57/\u8102\u80aa\u9178\u578b");
        item.setUnit("\u5428");
        item.setCorpcode(CORPCODE);
        item.setRequestno("1234567");
        item.setItemno("00001");
        orderList.add(item);
        String data = JSONArray.toJSONString(orderList);
        EpecResult result = EpecApiUtil.invokeAPI("http://uat-api.epec.com/apigate/v2/order/addPurchaseApply", accessToken, data);
        System.out.println("\u8fd4\u56de\u6570\u636e\u4e3a\uff1a" + result.toString());
    }

    public DApiSinoPrItem changeDApiSinoPrItem(PurchaseRequestHeadDTO head) {
        List<PurchaseRequestItemDTO> items = this.accountInvokeInquiryRpcService.selectPurchaseRequestItemListByMainId(head.getId());
        BigDecimal intqty = BigDecimal.ZERO;
        for (PurchaseRequestItemDTO item : items) {
            intqty = intqty.add(item.getQuantity());
        }
        DApiSinoPrItem result = new DApiSinoPrItem();
        result.setConaddr(clientId);
        result.setIntqty(intqty);
        result.setNeeddate("20190119");
        result.setApimaterNo("YB24500A000003S11");
        result.setProdname("\u67f4\u6cb9\u6297\u78e8\u5242QSHCG65\u8102\u80aa\u9178\u578b");
        result.setProjectnm("\u63a5\u53e3\u6d4b\u8bd5");
        result.setProjectno("27333221");
        result.setPurchaseRequestType("1");
        result.setResourcefrom("YSM1");
        result.setSpeco("Q/SHCG57/\u8102\u80aa\u9178\u578b");
        result.setUnit("\u5428");
        result.setCorpcode(CORPCODE);
        result.setRequestno("1234567");
        result.setItemno("00001");
        return result;
    }

    @GetMapping(value={"/orderApprove"})
    public static Result<?> orderApprove() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        DApiOrderApprove dApiOrderApprove = new DApiOrderApprove();
        dApiOrderApprove.setOrderId(3907388L);
        dApiOrderApprove.setOrderStatus("13");
        dApiOrderApprove.setPurchaseCompanyId(143910L);
        dApiOrderApprove.setReturnCheckTime(new SimpleDateFormat("yyyy-MM-DD HH:mm:ss").format(new Date()));
        dApiOrderApprove.setCmisUnapproveReason("\u5ba1\u6279\u901a\u8fc7");
        dApiOrderApprove.setRemark("\u5ba1\u6279\u5907\u6ce8");
        EpecResult result = EpecApiUtil.invokeAPI("http://uat-api.epec.com/apigate/v2/order/approve", accessToken, JSON.toJSONString((Object)dApiOrderApprove));
        return Result.ok((String)JSONObject.toJSONString((Object)result));
    }

    @GetMapping(value={"/paymentOrder"})
    public static Result<?> paymentOrder() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        DApiOrderPayment dOrder = new DApiOrderPayment();
        dOrder.setOrderId(3907349L);
        dOrder.setPurchaseCompanyId(115194L);
        String jsonString = JSONObject.toJSONString((Object)dOrder);
        EpecResult result = EpecApiUtil.invokeAPI("http://uat-api.epec.com/apigate/v2/order/pay", accessToken, jsonString);
        return Result.ok((String)JSONObject.toJSONString((Object)result));
    }

    @GetMapping(value={"/receiveGoods"})
    public static Result<?> receiveGoods() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        DApiPurchaseOrderReceive api = new DApiPurchaseOrderReceive();
        api.setCorpcode(clientId);
        api.setOrderId(3907353L);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        api.setCreateTime(sd.format(new Date()));
        api.setReceiveName("aaaa");
        api.setIsAllReceive((short)0);
        api.setPurchaseCompanyId(1135726L);
        api.setOrderReceiveIds("4400597,4500625");
        String data = JSON.toJSONString((Object)api);
        EpecResult result = EpecApiUtil.invokeAPI("http://uat-api.epec.com/apigate/v2/order/receiveGoods", accessToken, data);
        return Result.ok((String)JSONObject.toJSONString((Object)result));
    }

    @GetMapping(value={"/getMembers"})
    public static Result<?> getMembers() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        EpecResult result = EpecApiUtil.invokeAPI("http://uat-api.epec.com/apigate/v2/user/getMembers", accessToken, null);
        System.out.println(JSONObject.toJSONString((Object)result));
        return Result.ok((String)JSONObject.toJSONString((Object)result));
    }

    @GetMapping(value={"/orderInterface"})
    public static Result<?> orderInterface() {
        EpecToken epecToken = EpecApiUtil.getToken("http://uat-api.epec.com/apigate/oauth/token", clientId, clientSecret, companyId, userName, pd);
        String accessToken = epecToken.getAccessToken();
        log.info("SDK-->orderInterface\uff1aaccessToken\uff1a[{}]", (Object)accessToken);
        DApiOrderInterfaceLog dApiOrderInterfaceLog = new DApiOrderInterfaceLog();
        dApiOrderInterfaceLog.setOrderid(3907355L);
        dApiOrderInterfaceLog.setPurchasecompanyid(115194L);
        dApiOrderInterfaceLog.setPurchasecompanyname("\u4f73\u6728\u65af\u7535\u673a\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        dApiOrderInterfaceLog.setOrderno("20181106000003804833");
        dApiOrderInterfaceLog.setUploadstatus((short)3);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String format = sd.format(new Date());
        dApiOrderInterfaceLog.setUploadtime(format);
        dApiOrderInterfaceLog.setLogdetail("\u8ba2\u5355\u4e0a\u4f20\u6210\u529f");
        EpecResult result = EpecApiUtil.invokeAPI("http://uat-api.epec.com/apigate/v2/order/interfaceLog", accessToken, JSON.toJSONString((Object)dApiOrderInterfaceLog));
        return Result.ok((String)JSONObject.toJSONString((Object)result));
    }
}

