/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.appreciation.entity.ElsAppreciationService;
import com.els.modules.appreciation.enumerate.AppreciationServiceTypeEnum;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.esign.entity.ElsEsign;
import com.els.modules.esign.entity.ElsSigners;
import com.els.modules.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.esign.service.ElsEnterpriseCertificationInfoService;
import com.els.modules.esign.service.ElsEsignService;
import com.els.modules.esign.service.ElsSignersService;
import com.els.modules.esign.vo.ElsEsignVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.micrometer.core.instrument.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/esign/elsEsign"})
@Api(tags={"\u7535\u5b50\u7b7e\u7ae0"})
public class ElsEsignController
extends BaseController<ElsEsign, ElsEsignService> {
    private static final Logger log = LoggerFactory.getLogger(ElsEsignController.class);
    @Autowired
    private ElsEsignService elsEsignService;
    @Autowired
    private ElsSignersService elsSignersService;
    @Autowired
    private ElsEnterpriseCertificationInfoService elsEnterpriseCertificationInfoService;
    @Autowired
    @Lazy
    private EsignInvokeContractRpcService esignInvokeContractRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsEsign elsEsign, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsEsign), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.elsEsignService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/saleList"})
    public Result<?> saleList(ElsEsign elsEsign, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsEsign), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"send_status", (Object)"1");
        IPage pageList = this.elsEsignService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsEsignVO elsEsignPage) {
        ElsAppreciationService appreciationService = this.elsEsignService.getService(TenantContext.getTenant(), AppreciationServiceTypeEnum.ESIGN.getValue());
        if (appreciationService == null) {
            return Result.error((String)"\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1\u672a\u5f00\u901a");
        }
        ElsEsign elsEsign = new ElsEsign();
        BeanUtils.copyProperties((Object)((Object)elsEsignPage), (Object)((Object)elsEsign));
        this.elsEsignService.saveMain(elsEsign, elsEsignPage.getPurchaseSignersList(), elsEsignPage.getSaleSignersList());
        return Result.ok((Object)((Object)elsEsign));
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsEsignVO elsEsignPage) {
        ElsEsign elsEsign = new ElsEsign();
        BeanUtils.copyProperties((Object)((Object)elsEsignPage), (Object)((Object)elsEsign));
        this.elsEsignService.updateMain(elsEsign, elsEsignPage.getPurchaseSignersList(), elsEsignPage.getSaleSignersList(), elsEsignPage.getSaleAttachments());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsEsignService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.elsEsignService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsEsign elsEsign = (ElsEsign)((Object)this.elsEsignService.getById((Serializable)((Object)id)));
        ElsEsignVO elsEsignVO = new ElsEsignVO();
        BeanUtils.copyProperties((Object)((Object)elsEsign), (Object)((Object)elsEsignVO));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)id);
        wrapper.eq((Object)"role_type", (Object)"0");
        elsEsignVO.setPurchaseSignersList(this.elsSignersService.list((Wrapper)wrapper));
        wrapper.clear();
        wrapper.eq((Object)"head_id", (Object)id);
        wrapper.eq((Object)"role_type", (Object)"1");
        elsEsignVO.setSaleSignersList(this.elsSignersService.list((Wrapper)wrapper));
        elsEsignVO.setPurchaseAttachments(this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(elsEsign.getId()));
        elsEsignVO.setSaleAttachments(this.invokeBaseRpcService.selectSaleAttachmentByMainId(elsEsign.getId()));
        return Result.ok((Object)((Object)elsEsignVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u7535\u5b50\u7b7e\u7ae0id\u67e5\u8be2\u7b7e\u7f72\u4eba", notes="\u901a\u8fc7\u7535\u5b50\u7b7e\u7ae0id\u67e5\u8be2\u7b7e\u7f72\u4eba")
    @GetMapping(value={"/queryElsSignersByMainId"})
    public Result<?> queryElsSignersListByMainId(@RequestParam(name="id", required=true) String id) {
        List<ElsSigners> elsSignersList = this.elsSignersService.selectByMainId(id);
        return Result.ok(elsSignersList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/getSignerlist"})
    public Result<?> getSignerlist(@RequestParam(name="id", required=true) String id, @RequestParam(name="signer", required=true) String signer, @RequestParam(name="createdAccount", required=false) String createdAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        PurchaseContractHeadDTO contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(id);
        if (contractHead == null) {
            return Result.error((String)"\u5408\u540c\u4e0d\u5b58\u5728");
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        if ("purchase".equals(signer)) {
            wrapper.eq((Object)"els_account", (Object)contractHead.getElsAccount());
        } else {
            wrapper.eq((Object)"els_account", (Object)contractHead.getToElsAccount());
        }
        if (StringUtils.isNotBlank((String)createdAccount)) {
            wrapper.eq((Object)"created_account", (Object)createdAccount);
        }
        wrapper.isNotNull((Object)"org_id");
        IPage pageList = this.elsEnterpriseCertificationInfoService.page((IPage)page, (Wrapper)wrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u5173\u952e\u5b57\u5b9a\u4f4d")
    @ApiOperation(value="\u5173\u952e\u5b57\u5b9a\u4f4d", notes="\u5173\u952e\u5b57\u5b9a\u4f4d")
    @GetMapping(value={"/keyWordToAera"})
    public Result<?> keyWordToAera(@RequestParam(name="elsAccount", required=true) String elsAccount, @RequestParam(name="filesId", required=true) String filesId, @RequestParam(name="signWord", required=true) String signWord) {
        ElsSigners signers = new ElsSigners();
        signers.setElsAccount(elsAccount);
        signers.setFilesId(filesId);
        signers.setSignWord(signWord);
        return this.elsSignersService.keyWordToAera(signers);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u9000\u56de")
    @ApiOperation(value="\u9000\u56de", notes="\u9000\u56de")
    @GetMapping(value={"/sendBack"})
    public Result<?> sendBack(@RequestParam(name="id", required=true) String id) {
        return this.elsEsignService.sendBack(id);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u64a4\u9500")
    @ApiOperation(value="\u64a4\u9500", notes="\u64a4\u9500")
    @GetMapping(value={"/backout"})
    public Result<?> backout(@RequestParam(name="id", required=true) String id, @RequestParam(name="reason", required=true) String reason) {
        return this.elsEsignService.backout(id, reason);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @ApiOperation(value="\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d", notes="\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @GetMapping(value={"/signFileDownload"})
    public Result<?> signFileDownload(@RequestParam(name="id", required=true) String id) {
        return this.elsEsignService.signFileDownload(id);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u5f85\u7b7e\u7f72\u6587\u6863\u9884\u89c8")
    @ApiOperation(value="\u5f85\u7b7e\u7f72\u6587\u6863\u9884\u89c8", notes="\u5f85\u7b7e\u7f72\u6587\u6863\u9884\u89c8")
    @GetMapping(value={"/viewEsignFile"})
    public Result<?> viewEsignFile(@RequestParam(name="id", required=true) String id) {
        return this.elsEsignService.viewEsignFile(id);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u5355\u636e\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @ApiOperation(value="\u5355\u636e\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d", notes="\u5355\u636e\u7b7e\u7f72\u6587\u6863\u4e0b\u8f7d")
    @GetMapping(value={"/busSignFileDownload"})
    public Result<?> busSignFileDownload(@RequestParam(name="id", required=true) String id, @RequestParam(name="busType", required=true) String busType) {
        return this.elsEsignService.busSignFileDownload(id, busType);
    }

    @AutoLog(busModule="\u7535\u5b50\u7b7e\u7ae0", value="\u6d41\u7a0b\u67e5\u8be2")
    @ApiOperation(value="\u64a4\u9500", notes="\u6d41\u7a0b\u67e5\u8be2")
    @GetMapping(value={"/flowQuery"})
    public Result<?> flowQuery(@RequestParam(name="id", required=true) String id) {
        return this.elsEsignService.flowQuery(id);
    }
}

