/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.mapper.PersonalSettingMapper;
import com.els.modules.system.service.PersonalSettingService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonalSettingServiceImpl
extends ServiceImpl<PersonalSettingMapper, PersonalSetting>
implements PersonalSettingService {
    @Autowired
    private PersonalSettingMapper personalSettingMapper;

    @Override
    public boolean insert(PersonalSetting personalSetting) {
        return this.personalSettingMapper.insertPersonalSetting(personalSetting);
    }

    @Override
    public boolean deleteBySubAccount(String elsAccount, String subAccount, String receiveType) {
        return this.personalSettingMapper.deleteBySubAccount(elsAccount, subAccount, receiveType);
    }

    @Override
    public List<PersonalSetting> querySettingBySubAccount(String elsAccount, String subAccount) {
        return this.personalSettingMapper.querySettingBySubAccount(elsAccount, subAccount);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveNewSetting(String elsAccount, String subAccount, PersonalSetting personalSetting) {
        String receiveType = personalSetting.getReceiveType();
        this.personalSettingMapper.deleteBySubAccount(elsAccount, subAccount, receiveType);
        personalSetting.setId(IdWorker.getIdStr());
        personalSetting.setElsAccount(elsAccount);
        personalSetting.setSubAccount(subAccount);
        personalSetting.setCreateBy(subAccount);
        personalSetting.setCreateTime(new Date());
        personalSetting.setUpdateBy(subAccount);
        personalSetting.setUpdateTime(new Date());
        this.personalSettingMapper.insertPersonalSetting(personalSetting);
    }
}

