/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.appreciation.entity.ElsAppreciationService;
import com.els.modules.appreciation.enumerate.AppreciationServiceTypeEnum;
import com.els.modules.appreciation.service.ElsAppreciationServiceService;
import com.els.modules.esign.entity.PurchaseEsignSeals;
import com.els.modules.esign.entity.SaleEsignSeals;
import com.els.modules.esign.enumerate.EsignInterfaceEnum;
import com.els.modules.esign.mapper.PurchaseEsignSealsMapper;
import com.els.modules.esign.mapper.SaleEsignSealsMapper;
import com.els.modules.esign.service.PurchaseEsignSealsService;
import com.els.modules.esign.util.EsignFileEncryptUtil;
import com.els.modules.esign.vo.SealVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEsignSealsServiceImpl
extends BaseServiceImpl<PurchaseEsignSealsMapper, PurchaseEsignSeals>
implements PurchaseEsignSealsService {
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Autowired
    private SaleEsignSealsMapper saleEsignSealsMapper;
    @Autowired
    private ElsAppreciationServiceService elsAppreciationServiceService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void savePurchaseEsignSeals(PurchaseEsignSeals purchaseEsignSeals) {
        purchaseEsignSeals.setBusAccount("100000");
        ((PurchaseEsignSealsMapper)this.baseMapper).insert((Object)purchaseEsignSeals);
    }

    @Override
    public void updatePurchaseEsignSeals(PurchaseEsignSeals purchaseEsignSeals) {
        ((PurchaseEsignSealsMapper)this.baseMapper).updateById((Object)purchaseEsignSeals);
    }

    @Override
    public void delPurchaseEsignSeals(String id) {
        ((PurchaseEsignSealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseEsignSeals(List<String> idList) {
        ((PurchaseEsignSealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void send(PurchaseEsignSeals seals) {
        seals.setSendStatus("1");
        SaleEsignSeals saleEsignSeals = (SaleEsignSeals)((Object)SysUtil.copyProperties((Object)((Object)seals), SaleEsignSeals.class));
        saleEsignSeals.setElsAccount(saleEsignSeals.getToElsAccount());
        saleEsignSeals.setToElsAccount(seals.getElsAccount());
        saleEsignSeals.setRelationId(seals.getId());
        saleEsignSeals.setId(null);
        this.saleEsignSealsMapper.insert((Object)saleEsignSeals);
        seals.setRelationId(saleEsignSeals.getId());
        this.updateById((Object)seals);
    }

    @Override
    public Result<?> uploadToEsign(PurchaseEsignSeals seals) {
        ElsAppreciationService service = this.elsAppreciationServiceService.getByElsAccountAndServiceType(seals.getElsAccount(), AppreciationServiceTypeEnum.ESIGN.getValue());
        if (service == null) {
            return Result.error((String)"\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
        }
        if (StringUtils.isNotBlank((CharSequence)seals.getId())) {
            this.updatePurchaseEsignSeals(seals);
        } else {
            this.savePurchaseEsignSeals(seals);
        }
        Result response = null;
        if (StringUtils.isBlank((CharSequence)seals.getSealId())) {
            String data = EsignFileEncryptUtil.fileToBase64(String.valueOf(this.uploadpath) + seals.getFilePath());
            SealVO sealVO = new SealVO(seals, data);
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            if ("1".equals(seals.getSealType())) {
                bascis.put("accountId", (Object)seals.getOrgId());
            } else {
                bascis.put("accountId", (Object)seals.getAccountId());
            }
            requestJSON.put("bascis", (Object)bascis);
            requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sealVO)));
            response = this.invokeBaseRpcService.callEsignCommonPost(EsignInterfaceEnum.SEAL_UPLOAD.getValue(), requestJSON, service.getConsumAccount(), service.getConsumSubAccount(), service.getAppId(), service.getAppSerect());
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                seals.setSealId(jsonObject.getString("sealId"));
                seals.setUploaded("1");
                this.updatePurchaseEsignSeals(seals);
                return Result.ok((String)"\u4e0a\u4f20\u6210\u529f\uff01");
            }
            return Result.error((String)("\u4e0a\u4f20\u5931\u8d25:" + response.getMessage()));
        }
        return Result.error((String)"\u5370\u7ae0\u5df2\u4e0a\u4f20");
    }
}

