/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.ConvertUtils;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.AuthSensitive;
import com.els.modules.system.mapper.AuthSensitiveMapper;
import com.els.modules.system.service.AuthSensitiveService;
import com.els.modules.system.vo.UserRoleAspectVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthSensitiveServiceImpl
extends ServiceImpl<AuthSensitiveMapper, AuthSensitive>
implements AuthSensitiveService {
    @Autowired
    private AuthSensitiveMapper authSensitiveMapper;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(AuthSensitive authSensitive) {
        this.authSensitiveMapper.insert((Object)authSensitive);
        this.insertData(authSensitive);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(AuthSensitive authSensitive) {
        this.authSensitiveMapper.updateById((Object)authSensitive);
        this.insertData(authSensitive);
    }

    private void insertData(AuthSensitive authSensitive) {
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.authSensitiveMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.authSensitiveMapper.deleteById(serializable);
        }
    }

    @Override
    public void saveAuthSensitive(String roleId, String permissionIds, String lastPermissionIds) {
        List<String> delete;
        String elsAccount = TenantContext.getTenant();
        List<String> add = this.getDiff(lastPermissionIds, permissionIds);
        if (add != null && add.size() > 0) {
            ArrayList<AuthSensitive> list = new ArrayList<AuthSensitive>();
            for (String p : add) {
                if (!ConvertUtils.isNotEmpty((Object)p)) continue;
                AuthSensitive rolepms = new AuthSensitive(elsAccount, roleId, p);
                list.add(rolepms);
            }
            this.saveBatch(list);
        }
        if ((delete = this.getDiff(permissionIds, lastPermissionIds)) != null && delete.size() > 0) {
            for (String authValue : delete) {
                this.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(AuthSensitive::getRoleId, (Object)roleId)).eq(AuthSensitive::getAuthValue, (Object)authValue));
            }
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add(roleId);
        List<AuthSensitive> list = this.authSensitiveMapper.selectListByRoleId(items);
        if (list.size() > 0) {
            this.redisUtil.set("AUTH_SENSITIVE" + roleId, list);
        } else {
            this.redisUtil.del(new String[]{"AUTH_SENSITIVE" + roleId});
        }
    }

    @Override
    public List<AuthSensitive> listByRoleId(List<UserRoleAspectVO> list) {
        ArrayList<String> lists = new ArrayList<String>();
        ArrayList<AuthSensitive> listAuth = new ArrayList<AuthSensitive>();
        for (UserRoleAspectVO userRole : list) {
            List authList = (List)this.redisUtil.get("AUTH_SENSITIVE" + userRole.getId());
            if (authList != null) {
                listAuth.addAll(authList);
                continue;
            }
            lists.add(userRole.getId());
            List<AuthSensitive> authSensitivesList = this.authSensitiveMapper.selectListByRoleId(lists);
            this.redisUtil.set("AUTH_SENSITIVE" + userRole.getId(), authSensitivesList);
            listAuth.addAll(authSensitivesList);
        }
        return listAuth;
    }

    private List<String> getDiff(String main, String diff) {
        if (ConvertUtils.isEmpty((Object)diff)) {
            return null;
        }
        if (ConvertUtils.isEmpty((Object)main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] stringArray = mainArr;
        int n = mainArr.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            map.put(string, 1);
            ++n2;
        }
        ArrayList<String> res = new ArrayList<String>();
        String[] stringArray2 = diffArr;
        int n3 = diffArr.length;
        n = 0;
        while (n < n3) {
            String key = stringArray2[n];
            if (ConvertUtils.isNotEmpty((Object)key) && !map.containsKey(key)) {
                res.add(key);
            }
            ++n;
        }
        return res;
    }
}

