/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.vo.ComboModel;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseApiImpl
implements ISysBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(BaseApiImpl.class);
    private static String DB_TYPE = "";
    @Resource
    private ElsSubAccountMapper userMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private RoleMapper roleMapper;
    @Resource
    private InvokeBaseRpcService baseDubboService;

    public void addLog(String LogContent, Integer logType, Integer operatetype) {
    }

    public LoginUser getUserByAccount(String account) {
        if (ConvertUtils.isEmpty((Object)account)) {
            return null;
        }
        String redisKey = String.format("%s::%s", "sys:cache:user", account);
        LoginUser user = (LoginUser)this.redisUtil.get(redisKey);
        if (user != null) {
            return user;
        }
        LoginUser loginUser = new LoginUser();
        ElsSubAccount sysUser = this.userMapper.getUserByAccount(account);
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)((Object)sysUser), (Object)loginUser);
        try {
            Map<String, String> map = this.userMapper.getLogoSetByElsAccount(account.split("_")[0]);
            loginUser.setAliasName(map.get("alias"));
            loginUser.setEnterpriseName(map.get("name"));
            loginUser.setEnterpriseLogo(map.get("default_value") != null && "1".equals(map.get("default_value")) && map.get("enterprise_logo") != null ? map.get("enterprise_logo") : "");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        try {
            List<ElsCompanySetDTO> companySetList = this.baseDubboService.getCompanySetList(account.split("_")[0]);
            JSONObject result = new JSONObject();
            for (ElsCompanySetDTO vo : companySetList) {
                result.put(vo.getItemCode(), (Object)vo.getDefaultValue());
            }
            loginUser.setCompanySet(result);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        this.redisUtil.set(redisKey, (Object)loginUser, 1800L);
        return loginUser;
    }

    public LoginUser getUserById(String id) {
        if (ConvertUtils.isEmpty((Object)id)) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        ElsSubAccount sysUser = (ElsSubAccount)((Object)this.userMapper.selectById((Serializable)((Object)id)));
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)((Object)sysUser), (Object)loginUser);
        return loginUser;
    }

    public List<String> getRolesByUsername(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
    }

    public String getDatabaseType() {
        DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
        return this.getDatabaseTypeByDataSource(dataSource);
    }

    public List<DictModel> queryDictItemsByCode(String code) {
        return null;
    }

    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) throws Exception {
        return null;
    }

    public List<DictModel> queryAllDepartBackDictModel() {
        return null;
    }

    private String getDatabaseTypeByDataSource(DataSource dataSource) {
        block16: {
            if ("".equals(DB_TYPE)) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (Connection connection = dataSource.getConnection();){
                        DatabaseMetaData md = connection.getMetaData();
                        String dbType = md.getDatabaseProductName().toLowerCase();
                        if (dbType.contains("mysql")) {
                            DB_TYPE = "MYSQL";
                            break block16;
                        }
                        if (dbType.contains("oracle")) {
                            DB_TYPE = "ORACLE";
                            break block16;
                        }
                        if (dbType.contains("sqlserver") || dbType.contains("sql server")) {
                            DB_TYPE = "SQLSERVER";
                            break block16;
                        }
                        if (dbType.contains("postgresql")) {
                            DB_TYPE = "POSTGRESQL";
                            break block16;
                        }
                        throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u6570\u636e\u5e93\u7c7b\u578b:[" + dbType + "]\u4e0d\u8bc6\u522b!")));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return DB_TYPE;
    }

    public List<DictModel> queryAllDict() {
        return null;
    }

    public List<DictModel> queryFilterTableDictInfo(String table, String text, String code, String filterSql) {
        return null;
    }

    public List<ComboModel> queryAllUser() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)"1")).eq((Object)"is_deleted", (Object)"0"));
        for (ElsSubAccount user : userList) {
            ComboModel model = new ComboModel();
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            list.add(model);
        }
        return list;
    }

    public List<ComboModel> queryAllUser(String[] userIds) {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)"1")).eq((Object)"is_deleted", (Object)"0"));
        for (ElsSubAccount user : userList) {
            ComboModel model = new ComboModel();
            model.setUsername(user.getSubAccount());
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            if (ConvertUtils.isNotEmpty((Object)userIds)) {
                String[] stringArray = userIds;
                int n = userIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String userId = stringArray[n2];
                    if (userId.equals(user.getId())) {
                        model.setChecked(true);
                    }
                    ++n2;
                }
            }
            list.add(model);
        }
        return list;
    }

    public List<ComboModel> queryAllRole() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (Role role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            list.add(model);
        }
        return list;
    }

    public List<ComboModel> queryAllRole(String[] roleIds) {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (Role role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            if (ConvertUtils.isNotEmpty((Object)roleIds)) {
                String[] stringArray = roleIds;
                int n = roleIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String roleId = stringArray[n2];
                    if (roleId.equals(role.getId())) {
                        model.setChecked(true);
                    }
                    ++n2;
                }
            }
            list.add(model);
        }
        return list;
    }

    public List<String> getRoleIdsByUsername(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleIdByUserName(elsAccount, subAccount);
    }
}

