/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="elsSubAccountExcelHandler")
public class ElsSubAccountExcelHandler
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(ElsSubAccountExcelHandler.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired(required=false)
    private ImGroupInvokeRpcService baseImGroupService;
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;

    public void importExcel(List<Map<String, Object>> dataList) {
        String elsAccount = TenantContext.getTenant();
        ArrayList<ElsSubAccount> accountList = new ArrayList<ElsSubAccount>();
        ArrayList<UserRole> userRoleList = new ArrayList<UserRole>();
        List roleList = this.roleService.list();
        Map<String, String> roleMap = roleList.stream().collect(Collectors.toMap(Role::getRoleCode, Role::getId));
        Map<String, String> deptMap = this.systemInvokeOrganizationInfoRpcService.getDeptOrganization(elsAccount);
        for (Map<String, Object> data : dataList) {
            ElsSubAccount account = (ElsSubAccount)((Object)JSON.parseObject((String)JSON.toJSONString(data), ElsSubAccount.class));
            String roleCode = (String)data.get("roleCode");
            String orgCode = account.getOrgCode();
            account.setId(IdWorker.getIdStr());
            account.setElsAccount(elsAccount);
            account.setOrgCode(deptMap.get(orgCode));
            String salt = ConvertUtils.randomGen((int)8);
            account.setSalt(salt);
            String password = StrUtil.isNotBlank((CharSequence)account.getPassword()) ? account.getPassword() : account.getPhone().substring(account.getPhone().length() - 6);
            String passwordEncode = PasswordUtil.encrypt((String)(String.valueOf(elsAccount) + "_" + account.getSubAccount()), (String)password, (String)salt);
            account.setPassword(passwordEncode);
            account.setStatus(1);
            account.setDeleted(0);
            accountList.add(account);
            Assert.isTrue((roleMap.get(roleCode) != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)("\u89d2\u8272\u7f16\u7801\u9519\u8bef\uff1a" + roleCode)));
            UserRole userRole = new UserRole(account.getId(), roleMap.get(roleCode));
            userRoleList.add(userRole);
        }
        List stringList = accountList.stream().map(ElsSubAccount::getSubAccount).collect(Collectors.toList());
        long count = stringList.stream().distinct().count();
        Assert.isTrue((count == (long)stringList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u7684\u6570\u636e\u6709\u91cd\u590d\u7684\u5b50\u8d26\u53f7"));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(ElsSubAccount::getSubAccount, stringList);
        List checkList = this.elsSubAccountService.list((Wrapper)queryWrapper);
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)checkList), (String)I18nUtil.translate((String)"", (String)("\u7cfb\u7edf\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5b50\u8d26\u53f7\uff1a" + checkList.toString())));
        this.elsSubAccountService.saveBatch(accountList);
        this.userRoleService.saveBatch(userRoleList);
        List userIdList = accountList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        try {
            this.baseImGroupService.initGroupBatch(userIdList);
        }
        catch (Exception e) {
            log.error("::: \u521d\u59cb\u5316\u7528\u6237\u5206\u7ec4{}\u5931\u8d25==>{}", userIdList, (Object)e.getMessage());
        }
    }
}

