/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.modules.esign.entity.ElsSeals;
import com.els.modules.esign.mapper.ElsSealsMapper;
import com.els.modules.esign.service.ElsSealsService;
import com.els.modules.esign.util.EsignFileEncryptUtil;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.vo.SealVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ElsSealsServiceImpl
extends BaseServiceImpl<ElsSealsMapper, ElsSeals>
implements ElsSealsService {
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("esign.service");
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void saveElsSeals(ElsSeals elsSeals) {
        elsSeals.setBusAccount("100000");
        elsSeals.setDeleted(CommonConstant.DEL_FLAG_0);
        ((ElsSealsMapper)this.baseMapper).insert((Object)elsSeals);
    }

    @Override
    public void updateElsSeals(ElsSeals elsSeals) {
        ((ElsSealsMapper)this.baseMapper).updateById((Object)elsSeals);
    }

    @Override
    public void delElsSeals(String id) {
        ((ElsSealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsSeals(List<String> idList) {
        ((ElsSealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<?> uploadToEsign(ElsSeals seals) {
        if (StringUtils.isNotBlank((CharSequence)seals.getId())) {
            this.updateElsSeals(seals);
        } else {
            this.saveElsSeals(seals);
        }
        Result<?> response = null;
        if (StringUtils.isBlank((CharSequence)seals.getSealId())) {
            String data = EsignFileEncryptUtil.fileToBase64(this.uploadpath + seals.getFilePath());
            SealVO sealVO = new SealVO(seals, data);
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("accountId", (Object)seals.getOrgId());
            requestJSON.put("base", (Object)bascis);
            requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sealVO)));
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.configMap.get("esign.create-person-or-org-seal-image"));
            response = EsignResultAnalysisUtil.analysisResult(object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                seals.setSealId(jsonObject.getString("sealId"));
                this.updateElsSeals(seals);
                return Result.ok((String)"\u4e0a\u4f20\u6210\u529f\uff01");
            }
            return Result.error((String)("\u4e0a\u4f20\u5931\u8d25:" + response.getMessage()));
        }
        return Result.error((String)"\u5370\u7ae0\u5df2\u4e0a\u4f20");
    }
}

