/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.qip.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.qip.entity.QipProductAttribute;
import com.els.modules.qip.entity.QipProductBillingItem;
import com.els.modules.qip.entity.QipProductControlCondition;
import com.els.modules.qip.entity.QipProductData;
import com.els.modules.qip.mapper.QipProductAttributeMapper;
import com.els.modules.qip.mapper.QipProductBillingItemMapper;
import com.els.modules.qip.mapper.QipProductControlConditionMapper;
import com.els.modules.qip.mapper.QipProductDataMapper;
import com.els.modules.qip.service.QipProductDataService;
import com.els.modules.qip.vo.QipProductAttributeVO;
import com.els.modules.qip.vo.QipProductDataVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QipProductDataServiceImpl
extends BaseServiceImpl<QipProductDataMapper, QipProductData>
implements QipProductDataService {
    @Autowired
    private QipProductDataMapper qipProductDataMapper;
    @Autowired
    private QipProductAttributeMapper qipProductAttributeMapper;
    @Autowired
    private QipProductBillingItemMapper qipProductBillingItemMapper;
    @Autowired
    private QipProductControlConditionMapper qipProductControlConditionMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(QipProductData qipProductData, List<QipProductAttributeVO> qipProductAttributeList) {
        this.qipProductDataMapper.insert((Object)qipProductData);
        this.insertData(qipProductData, qipProductAttributeList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(QipProductData qipProductData, List<QipProductAttributeVO> qipProductAttributeList) {
        this.qipProductDataMapper.updateById((Object)qipProductData);
        this.qipProductAttributeMapper.deleteByMainId(qipProductData.getId());
        this.qipProductBillingItemMapper.deleteByMainId(qipProductData.getId());
        this.qipProductControlConditionMapper.deleteByMainId(qipProductData.getId());
        this.insertData(qipProductData, qipProductAttributeList);
    }

    private void insertData(QipProductData qipProductData, List<QipProductAttributeVO> qipProductAttributeList) {
        if (qipProductAttributeList != null) {
            Date now = new Date();
            ArrayList<QipProductAttribute> productAttributes = new ArrayList<QipProductAttribute>();
            for (QipProductAttributeVO entity : qipProductAttributeList) {
                List<QipProductControlCondition> conditions;
                QipProductAttribute attribute = new QipProductAttribute();
                BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)attribute));
                attribute.setHeadId(qipProductData.getId());
                attribute.setId(UUID.randomUUID().toString().replace("-", ""));
                attribute.setDeleted(CommonConstant.DEL_FLAG_0);
                attribute.setCreateTime(now);
                attribute.setBusAccount("100000");
                attribute.setElsAccount("100000");
                productAttributes.add(attribute);
                List<QipProductBillingItem> billingItems = entity.getBillingItemList();
                if (billingItems != null) {
                    ArrayList<QipProductBillingItem> productBillingItems = new ArrayList<QipProductBillingItem>();
                    for (QipProductBillingItem billingItem : billingItems) {
                        billingItem.setHeadId(attribute.getId());
                        billingItem.setDeleted(CommonConstant.DEL_FLAG_0);
                        billingItem.setCreateTime(now);
                        billingItem.setBusAccount("100000");
                        billingItem.setElsAccount("100000");
                        productBillingItems.add(billingItem);
                    }
                    if (productBillingItems.size() > 0) {
                        this.qipProductBillingItemMapper.insertBatchSomeColumn(productBillingItems);
                    }
                }
                if ((conditions = entity.getControlCondtionList()) == null) continue;
                ArrayList<QipProductControlCondition> controlConditions = new ArrayList<QipProductControlCondition>();
                for (QipProductControlCondition condition : conditions) {
                    condition.setHeadId(attribute.getId());
                    condition.setDeleted(CommonConstant.DEL_FLAG_0);
                    condition.setCreateTime(now);
                    condition.setBusAccount("100000");
                    condition.setElsAccount("100000");
                    controlConditions.add(condition);
                }
                if (controlConditions.size() <= 0) continue;
                this.qipProductControlConditionMapper.insertBatchSomeColumn(controlConditions);
            }
            if (!productAttributes.isEmpty()) {
                this.qipProductAttributeMapper.insertBatchSomeColumn(productAttributes);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.qipProductAttributeMapper.deleteByMainId(id);
        this.qipProductDataMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.qipProductAttributeMapper.deleteByMainId(serializable.toString());
            this.qipProductDataMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void handleReceiveData(QipProductDataVO dataVO) {
        QipProductData productData = (QipProductData)((Object)SysUtil.copyProperties((Object)((Object)dataVO), QipProductData.class));
        if (StringUtils.isBlank((CharSequence)productData.getProductCode())) {
            throw new ELSBootException("\u4ea7\u54c1\u7f16\u7801\uff08productCode\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        productData.setElsAccount("100000");
        productData.setBusAccount("100000");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"product_code", (Object)productData.getProductCode());
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        QipProductData oldData = (QipProductData)((Object)this.qipProductDataMapper.selectOne((Wrapper)wrapper));
        if (oldData == null) {
            this.qipProductDataMapper.insert((Object)productData);
        } else {
            productData.setId(oldData.getId());
            productData.setCreateTime(oldData.getCreateTime());
            productData.setUpdateTime(new Date());
            this.qipProductDataMapper.updateById((Object)productData);
        }
        List<QipProductAttribute> attributes = this.qipProductAttributeMapper.selectByMainId(productData.getId());
        if (!attributes.isEmpty()) {
            for (QipProductAttribute attribute : attributes) {
                this.qipProductBillingItemMapper.deleteByMainId(attribute.getId());
                this.qipProductControlConditionMapper.deleteByMainId(attribute.getId());
            }
            this.qipProductAttributeMapper.deleteByMainId(productData.getId());
        }
        this.insertData(productData, dataVO.getProductAttributeList());
    }
}

