/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.qip.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.config.mybatis.TenantContext;
import com.els.modules.qip.dto.QipAccountDTO;
import com.els.modules.qip.dto.QipAlreadyBoughtServiceDTO;
import com.els.modules.qip.dto.QipBalanceDTO;
import com.els.modules.qip.dto.QipConsumptionResultDTO;
import com.els.modules.qip.dto.QipOrderDTO;
import com.els.modules.qip.dto.QipRechargeRecordDTO;
import com.els.modules.qip.dto.QipRechargeResultDTO;
import com.els.modules.qip.dto.SellPriceDTO;
import com.els.modules.qip.service.CallQipService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CallQipServiceImpl
implements CallQipService {
    private String HOST;
    private String CREATE_ACCOUNT = "/qip/oauth/srm/createAccount";
    private String QUERY_BALANCE = "/qip/oauth/srm/queryBalance";
    private String ORDER_CREATE = "/qip/order/srm/order";
    private String QUERY_RECHARGE = "/qip/oauth/srm/queryRechargeRecord";
    private String QUERY_COMSUMPTION = "/qip/oauth/srm/usrCostFlow";
    private String QUERY_ALEADY_BOUGHT_SERVICE = "/qip/order/srm/myProduct";
    private String QUERY_SELL_PRICE = "/qip/order/srm/productPrice";
    private final int SUCCESS_CODE = 200;

    @Override
    public void createAccount(QipAccountDTO accountDTO) {
        HttpRequest.post((String)(this.HOST + this.CREATE_ACCOUNT)).body(JSONObject.toJSONString((Object)accountDTO)).execute().body();
    }

    @Override
    public QipBalanceDTO queryBalance(String elsAccount) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("elsAccount", (Object)elsAccount);
        String body = HttpRequest.post((String)(this.HOST + this.QUERY_BALANCE)).body(requestObject.toString()).execute().body();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            return (QipBalanceDTO)JSON.parseObject((String)body, QipBalanceDTO.class);
        }
        throw new ELSBootException("\u67e5\u8be2\u5931\u8d25");
    }

    @Override
    public Result<?> createOrder(QipOrderDTO dto) {
        String body = HttpRequest.post((String)(this.HOST + this.ORDER_CREATE)).body(JSONObject.toJSONString((Object)dto)).execute().body();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            JSONObject object = JSONObject.parseObject((String)body);
            if (200 == object.getIntValue("code")) {
                QipOrderDTO orderDTO = (QipOrderDTO)JSON.parseObject((String)object.getString("data"), QipOrderDTO.class);
                dto.setOrderCode(orderDTO.getOrderCode());
                return Result.ok((Object)dto);
            }
            return Result.error((String)body);
        }
        throw new ELSBootException("qip\u8ba2\u5355\u521b\u5efa\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
    }

    @Override
    public QipRechargeResultDTO queryRechargeRecord(QipRechargeRecordDTO rechargeRecordDTO) {
        String body = HttpRequest.post((String)(this.HOST + this.QUERY_RECHARGE)).body(JSONObject.toJSONString((Object)rechargeRecordDTO)).execute().body();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            return (QipRechargeResultDTO)JSON.parseObject((String)body, QipRechargeResultDTO.class);
        }
        throw new ELSBootException("\u67e5\u8be2\u5931\u8d25");
    }

    @Override
    public QipConsumptionResultDTO queryConsumptionRecord(Integer pageNo, Integer pageSize) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("pageNo", (Object)pageNo);
        requestObject.put("pageSize", (Object)pageSize);
        JSONObject query = new JSONObject();
        query.put("elsAccount", (Object)TenantContext.getTenant());
        requestObject.put("query", (Object)query);
        String body = HttpRequest.post((String)(this.HOST + this.QUERY_COMSUMPTION)).body(requestObject.toString()).execute().body();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            return (QipConsumptionResultDTO)JSON.parseObject((String)body, QipConsumptionResultDTO.class);
        }
        throw new ELSBootException("\u67e5\u8be2\u5931\u8d25");
    }

    @Override
    public QipAlreadyBoughtServiceDTO queryAlreadyBoughtService(String elsAccount, String orderCode) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("orderCode", (Object)orderCode);
        requestObject.put("elsAccount", (Object)elsAccount);
        String body = HttpRequest.post((String)(this.HOST + this.QUERY_ALEADY_BOUGHT_SERVICE)).body(requestObject.toString()).execute().body();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            return (QipAlreadyBoughtServiceDTO)JSON.parseObject((String)body, QipAlreadyBoughtServiceDTO.class);
        }
        throw new ELSBootException("\u67e5\u8be2\u5931\u8d25");
    }

    @Override
    public QipConsumptionResultDTO queryWaterConsumption(Integer pageNo, Integer pageSize, String entitlCode, String month) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("pageNo", (Object)pageNo);
        requestObject.put("pageSize", (Object)pageSize);
        JSONObject query = new JSONObject();
        query.put("entitlCode", (Object)entitlCode);
        query.put("month", (Object)month);
        requestObject.put("query", (Object)query);
        String body = HttpRequest.post((String)(this.HOST + this.QUERY_RECHARGE)).body(requestObject.toString()).execute().body();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            return (QipConsumptionResultDTO)JSON.parseObject((String)body, QipConsumptionResultDTO.class);
        }
        throw new ELSBootException("\u67e5\u8be2\u5931\u8d25");
    }

    @Override
    public SellPriceDTO querySellPrice(String productCode) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("productCode", (Object)productCode);
        String body = HttpRequest.post((String)(this.HOST + this.QUERY_SELL_PRICE)).body(requestObject.toString()).execute().body();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            return (SellPriceDTO)JSON.parseObject((String)body, SellPriceDTO.class);
        }
        throw new ELSBootException("\u67e5\u8be2\u5931\u8d25");
    }
}

