/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.esign.entity.ElsEnterpriseCertificationInfo;
import com.els.modules.esign.mapper.ElsEnterpriseCertificationInfoMapper;
import com.els.modules.esign.service.ElsEnterpriseCertificationInfoService;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.vo.EnterpriseAuthCallBakVO;
import com.els.modules.esign.vo.EnterpriseAuthenticationEO;
import com.els.modules.esign.vo.EsignCreateOrgAccountVO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsEnterpriseCertificationInfoServiceImpl
extends BaseServiceImpl<ElsEnterpriseCertificationInfoMapper, ElsEnterpriseCertificationInfo>
implements ElsEnterpriseCertificationInfoService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("esign.service");
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;

    @Override
    public void saveElsEnterpriseCertificationInfo(ElsEnterpriseCertificationInfo elsEnterpriseCertificationInfo) {
        PurchaseOrganizationInfoDTO organizationInfo;
        elsEnterpriseCertificationInfo.setBusAccount("100000");
        elsEnterpriseCertificationInfo.setCertificationStatus("0");
        ElsEnterpriseInfo enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            elsEnterpriseCertificationInfo.setEnterpriseId(enterpriseInfo.getId());
            elsEnterpriseCertificationInfo.setEnterpriseName(enterpriseInfo.getName());
        }
        if ("1".equals(elsEnterpriseCertificationInfo.getLoadingCompany()) && (organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", elsEnterpriseCertificationInfo.getCompanyCode())) != null) {
            elsEnterpriseCertificationInfo.setCompanyName(organizationInfo.getOrgName());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"company_name", (Object)elsEnterpriseCertificationInfo.getCompanyName());
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        if (StringUtils.isNotBlank((CharSequence)elsEnterpriseCertificationInfo.getCreatedAccount())) {
            wrapper.eq((Object)"created_account", (Object)elsEnterpriseCertificationInfo.getCreatedAccount());
        } else {
            wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"created_account")).or()).eq((Object)"created_account", (Object)""));
        }
        if (!this.list((Wrapper)wrapper).isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        }
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).insert((Object)elsEnterpriseCertificationInfo);
    }

    @Override
    public void updateElsEnterpriseCertificationInfo(ElsEnterpriseCertificationInfo elsEnterpriseCertificationInfo) {
        PurchaseOrganizationInfoDTO organizationInfo;
        if ("1".equals(elsEnterpriseCertificationInfo.getLoadingCompany()) && (organizationInfo = this.systemInvokeOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", elsEnterpriseCertificationInfo.getCompanyCode())) != null) {
            elsEnterpriseCertificationInfo.setCompanyName(organizationInfo.getOrgName());
        }
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).updateById((Object)elsEnterpriseCertificationInfo);
    }

    @Override
    public void delElsEnterpriseCertificationInfo(String id) {
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsEnterpriseCertificationInfo(List<String> idList) {
        ((ElsEnterpriseCertificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<?> submitCertification(ElsEnterpriseCertificationInfo certificationInfo) {
        Result<?> response = null;
        if (StringUtils.isBlank((CharSequence)certificationInfo.getOrgId())) {
            EsignCreateOrgAccountVO accountVO = (EsignCreateOrgAccountVO)SysUtil.copyProperties((Object)((Object)certificationInfo), EsignCreateOrgAccountVO.class);
            accountVO.setThirdPartyUserId(certificationInfo.getId());
            accountVO.setCreator(certificationInfo.getAccountId());
            accountVO.setName(certificationInfo.getCompanyName());
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)accountVO)), this.service, this.configMap.get("esign.create-org-account"));
            response = EsignResultAnalysisUtil.analysisResult(object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                certificationInfo.setOrgId(jsonObject.getString("orgId"));
                this.updateById((Object)certificationInfo);
            } else {
                return Result.error((String)("\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:" + response.getMessage()));
            }
        }
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/elsEnterpriseCertificationInfo/callback/enterprise" : this.address + "/els/esign/elsEnterpriseCertificationInfo/callback/enterprise";
        EnterpriseAuthenticationEO authenticationEO = new EnterpriseAuthenticationEO(certificationInfo, notifyUrl);
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("accountId", (Object)certificationInfo.getOrgId());
        requestJSON.put("base", (Object)bascis);
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)authenticationEO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.configMap.get("esign.get-org-auth-address"));
        response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            return Result.error((String)("\u8ba4\u8bc1\u63d0\u4ea4\u5931\u8d25:" + response.getMessage()));
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        certificationInfo.setShortLink(jsonObject.getString("shortLink"));
        certificationInfo.setLongLink(jsonObject.getString("url"));
        certificationInfo.setCertificationFlowId(jsonObject.getString("flowId"));
        certificationInfo.setCertificationStartTime(new Date());
        this.updateById((Object)certificationInfo);
        return Result.ok((String)"\u8ba4\u8bc1\u63d0\u4ea4\u6210\u529f");
    }

    @Override
    public void enterpriseCallBack(JSONObject object) {
        EnterpriseAuthCallBakVO authCallBakVO = (EnterpriseAuthCallBakVO)JSON.parseObject((String)object.toJSONString(), EnterpriseAuthCallBakVO.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"certification_flow_id", (Object)authCallBakVO.getFlowId());
        List certificationInfos = this.list((Wrapper)wrapper);
        if (!certificationInfos.isEmpty() && authCallBakVO.isSuccess()) {
            ElsEnterpriseCertificationInfo certificationInfo = (ElsEnterpriseCertificationInfo)((Object)certificationInfos.get(0));
            certificationInfo.setCertificationStatus("1");
            certificationInfo.setVerifyCode(authCallBakVO.getVerifycode());
            this.updateById((Object)certificationInfo);
        }
    }

    @Override
    public Result<?> modifyAuthInfo(ElsEnterpriseCertificationInfo certificationInfo) {
        JSONObject requestJSON = new JSONObject();
        JSONObject bascis = new JSONObject();
        bascis.put("orgId", (Object)certificationInfo.getOrgId());
        requestJSON.put("base", (Object)bascis);
        EsignCreateOrgAccountVO accountVO = (EsignCreateOrgAccountVO)SysUtil.copyProperties((Object)((Object)certificationInfo), EsignCreateOrgAccountVO.class);
        accountVO.setThirdPartyUserId(certificationInfo.getId());
        accountVO.setCreator(certificationInfo.getAccountId());
        accountVO.setName(certificationInfo.getCompanyName());
        requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)accountVO)));
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.configMap.get("esign.modify-org-account"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            return Result.error((String)("\u4fee\u6539\u5931\u8d25:" + response.getMessage()));
        }
        this.updateById((Object)certificationInfo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }
}

