/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.RandomUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.modules.sms.api.dto.SmsDto;
import com.els.modules.sms.api.dto.SmsResult;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.rpc.service.InvokeSmsRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ForgetPasswordService;
import com.els.modules.system.vo.ForgetPasswordVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/forgetPassword"})
@Api(tags={"\u5fd8\u8bb0\u5bc6\u7801"})
@CrossOrigin(value={"*"})
public class ForgetPasswordController {
    private static final Logger log = LoggerFactory.getLogger(ForgetPasswordController.class);
    @Autowired
    private ForgetPasswordService forgetPasswordService;
    @Resource
    private InvokeSmsRpcService invokeSmsRpcService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/getUserInfo"})
    public Result<?> getUserInfo(@RequestBody ForgetPasswordVO forgetPasswordVO) {
        return this.forgetPasswordService.getUserInfo(forgetPasswordVO);
    }

    @ApiOperation(value="\u624b\u673a\u53f7\u7801\u8ba4\u8bc1", notes="\u624b\u673a\u53f7\u7801\u8ba4\u8bc1")
    @PostMapping(value={"/verifyUserPhone"})
    public Result<?> verifyUserPhone(@RequestBody ForgetPasswordVO forgetPasswordVO) {
        return this.forgetPasswordService.verifyUserPhone(forgetPasswordVO);
    }

    @AutoLog(value="\u53d1\u77ed\u4fe1\u77ed\u4fe1\u63a5\u53e3", logType=1)
    @PostMapping(value={"/sms"})
    public Result<?> sms(@RequestBody ForgetPasswordVO forgetPasswordVO) {
        if (null == forgetPasswordVO.getPhone()) {
            return Result.error((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        ElsSubAccount userByAccount = this.elsSubAccountService.getUserByAccount(forgetPasswordVO.getAccount());
        Assert.notNull((Object)((Object)userByAccount), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        if (StringUtils.isEmpty((Object)userByAccount.getPhone()) && StringUtils.isEmpty((Object)userByAccount.getEmail())) {
            return Result.error((String)"\u8be5\u8d26\u53f7\u5c1a\u672a\u7ed1\u5b9a\u624b\u673a\u6216\u8005\u90ae\u7bb1\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        if (!userByAccount.getPhone().equals(forgetPasswordVO.getPhone())) {
            return Result.error((String)"\u624b\u673a\u53f7\u7801\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        Result result = this.elsSubAccountService.checkUserIsEffective(userByAccount);
        if (!result.isSuccess()) {
            return Result.error((String)result.getMessage());
        }
        Object object = this.redisUtil.get(userByAccount.getPhone());
        if (object != null) {
            return Result.ok((Object)forgetPasswordVO);
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        SmsDto smsDto = new SmsDto();
        smsDto.setMobile(userByAccount.getPhone());
        smsDto.setSmsmode("2");
        SmsResult smsResult = this.invokeSmsRpcService.sendSms(smsDto);
        if (!smsResult.isSuccess()) {
            throw new ELSBootException(smsResult.getMessage());
        }
        this.redisUtil.set(userByAccount.getPhone(), (Object)captcha, 600L);
        return Result.ok((Object)forgetPasswordVO);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u7801\u6821\u9a8c", notes="\u9a8c\u8bc1\u7801\u6821\u9a8c")
    @PostMapping(value={"/verifyCode"})
    public Result<?> verifyCode(@RequestBody ForgetPasswordVO forgetPasswordVO) {
        return this.forgetPasswordService.verifyCode(forgetPasswordVO);
    }

    @ApiOperation(value="\u90ae\u7bb1\u8ba4\u8bc1", notes="\u90ae\u7bb1\u8ba4\u8bc1")
    @PostMapping(value={"/verifyEmail"})
    public Result<?> verifyEmail(@RequestBody ForgetPasswordVO forgetPasswordVO) {
        return this.forgetPasswordService.verifyEmail(forgetPasswordVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/resetPassword"})
    public Result<?> resetPassword(@RequestBody ForgetPasswordVO forgetPasswordVO) {
        return this.forgetPasswordService.resetPassword(forgetPasswordVO);
    }
}

