/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.contract.dto.PurchaseContractContentItemDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.PurchaseContractItemDTO;
import com.els.modules.contract.dto.SaleContractHeadDTO;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.esign.entity.ElsEsign;
import com.els.modules.esign.entity.ElsSigners;
import com.els.modules.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.esign.enumerate.EsignSignerStatusEmun;
import com.els.modules.esign.enumerate.EsignStatusEmun;
import com.els.modules.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.esign.service.ElsEsignService;
import com.els.modules.esign.service.ElsSignersService;
import com.els.modules.esign.service.EsignOperationService;
import com.els.modules.esign.util.EsignFileEncryptUtil;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.util.FileHelper;
import com.els.modules.esign.util.NumberUtil;
import com.els.modules.esign.util.PdfUtil;
import com.els.modules.esign.vo.CreateFlowOneStep;
import com.els.modules.esign.vo.EsignAttachmentVO;
import com.els.modules.esign.vo.EsignCopiersVO;
import com.els.modules.esign.vo.EsignDocsVO;
import com.els.modules.esign.vo.EsignFlowInfoVO;
import com.els.modules.esign.vo.EsignSignerVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EsignOperationServiceImpl
implements EsignOperationService {
    private static final Logger log = LoggerFactory.getLogger(EsignOperationServiceImpl.class);
    private static final Integer A_SIGNED = 2;
    private static final Integer LOSE = 3;
    private static final Integer REFUSAL = 4;
    private static final String SIGN_FLOW_UPDATE = "SIGN_FLOW_UPDATE";
    private static final String SIGN_FLOW_FINISH = "SIGN_FLOW_FINISH";
    @Value(value="${els.path.upload}")
    private String uploadpath;
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("esign.service");
    @Autowired
    private EsignInvokeContractRpcService esignInvokeContractRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsEsignService elsEsignService;
    @Autowired
    private ElsSignersService elsSignersService;

    private StringBuilder getHtmlById(String id) {
        PurchaseContractHeadDTO purchaseContractHead = this.esignInvokeContractRpcService.getPurchaseContractById(id);
        List<PurchaseContractItemDTO> purchaseContractItemList = this.esignInvokeContractRpcService.getItemListByMainId(id);
        List<PurchaseContractContentItemDTO> purchaseContractContentItemList = this.esignInvokeContractRpcService.getContentItemListByMainId(id);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)purchaseContractHead);
        jsonObject.put("purchaseContractItemList", purchaseContractItemList);
        jsonObject.put("purchaseContractContentItemList", purchaseContractContentItemList);
        jsonObject.put("purchaseAttachmentList", (Object)purchaseAttachmentList);
        for (Map.Entry next : jsonObject.entrySet()) {
            if (!((String)next.getKey()).contains("_dictText") || next.getValue() == null || String.valueOf(next.getValue()).split("_").length <= 1) continue;
            next.setValue(next.getValue().toString().split("_")[1]);
        }
        Map param = (Map)JSON.parse((String)jsonObject.toString());
        param.put("itemList", param.get("purchaseContractItemList"));
        List<PurchaseContractContentItemDTO> contractBuyContentItemList = this.esignInvokeContractRpcService.getContentItemListByMainId(id);
        if (CollectionUtils.isEmpty(contractBuyContentItemList)) {
            // empty if block
        }
        int index = 0;
        StringBuilder html = new StringBuilder();
        for (PurchaseContractContentItemDTO item : contractBuyContentItemList) {
            if ("3".equals(item.getItemType()) || "4".equals(item.getItemType())) {
                param.put("index", ++index);
                param.put("zh_index", NumberUtil.number2Chinese(index));
            }
            String itemContent = item.getItemContent();
            if ("4".equals(item.getItemType())) {
                itemContent = PdfUtil.changeTemplate(itemContent);
            }
            String content = "";
            if (StringUtils.isNotBlank((CharSequence)itemContent)) {
                content = TemplateParseUtil.getTemplateText((String)"", (String)itemContent, (Map)param);
            }
            html.append(content);
        }
        return html;
    }

    @Override
    public Result<?> uploadFile(ElsEsign esign, HttpServletRequest request, HttpServletResponse response) {
        block20: {
            if (StringUtils.isNotBlank((CharSequence)esign.getId())) {
                this.elsEsignService.updateById((Object)esign);
            } else {
                this.elsEsignService.save((Object)esign);
            }
            String path = null;
            PurchaseContractHeadDTO contractBuyHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId());
            if ("sale".equals(esign.getFirstSeal()) && !"1".equals(esign.getOnlineSealed())) {
                List attachment = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(esign.getId());
                if (attachment.isEmpty()) {
                    throw new ELSBootException("\u4f9b\u65b9\u672a\u4e0a\u4f20\u7b7e\u7f72\u6587\u4ef6");
                }
                path = this.uploadpath + ((PurchaseAttachmentDTO)attachment.get(0)).getFilePath();
            } else {
                String html = this.getHtmlById(esign.getRelationId()).toString();
                if (StringUtils.isBlank((CharSequence)html)) {
                    throw new ELSBootException("\u7a7a\u767d\u6587\u4ef6\u4e0d\u80fd\u4e0a\u4f20");
                }
                try {
                    path = PdfUtil.htmlToPdf(this.uploadpath, html.toString(), contractBuyHead.getContractNumber() + "_" + contractBuyHead.getContractVersion(), null);
                }
                catch (Exception e1) {
                    throw new ELSBootException("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff1a" + e1.getMessage());
                }
            }
            InputStream inputStream = null;
            try {
                log.info("path=" + path);
                File file = new File(path);
                if (!file.exists()) break block20;
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
                inputStream = new BufferedInputStream(new FileInputStream(file));
                byte[] bytes = EsignFileEncryptUtil.getFileMD5Bytes1282(inputStream);
                String contentMD5 = EsignFileEncryptUtil.getStringContentMD5(bytes);
                int fileSize = bytes.length;
                EsignAttachmentVO attachmentVO = null;
                int lastIndexOf = path.lastIndexOf("/");
                attachmentVO = path.endsWith(".pdf") ? new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), fileSize, null) : new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), fileSize, "application/octet-stream");
                JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)attachmentVO)), this.service, this.configMap.get("esign.upload-file"));
                Result<?> responseResult = EsignResultAnalysisUtil.analysisResult(object);
                if (!responseResult.isSuccess()) break block20;
                JSONObject jsonObject = (JSONObject)responseResult.getResult();
                String uploadUrl = jsonObject.getString("uploadUrl");
                String fileId = jsonObject.getString("fileId");
                esign.setFilesId(fileId);
                esign.setDeleted(CommonConstant.DEL_FLAG_0);
                esign.setFilesName(contractBuyHead.getContractName() + ".pdf");
                try {
                    FileHelper.streamUpload(path, uploadUrl, attachmentVO.getContentMd5());
                    esign.setUploaded("1");
                    this.elsEsignService.updateById((Object)esign);
                }
                catch (Exception e) {
                    throw new ELSBootException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            catch (Exception e) {
                throw new ELSBootException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error("printStackTrace:", (Throwable)e);
                    }
                }
            }
        }
        return Result.ok((String)"\u7b7e\u7f72\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
    }

    @Override
    public Result<?> createFlowOneStep(ElsEsign esign) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"head_id", (Object)esign.getId());
        wrapper.eq((Object)"role_type", (Object)"0");
        List purhcaseSigners = this.elsSignersService.list((Wrapper)wrapper);
        wrapper.clear();
        wrapper.eq((Object)"head_id", (Object)esign.getId());
        wrapper.eq((Object)"role_type", (Object)"1");
        List saleSigners = this.elsSignersService.list((Wrapper)wrapper);
        ArrayList<EsignSignerVO> signerVOs = new ArrayList<EsignSignerVO>();
        if ("sale".equals(esign.getFirstSeal())) {
            if (!saleSigners.isEmpty()) {
                signerVOs.add(new EsignSignerVO((ElsSigners)((Object)saleSigners.get(0)), 1L));
                signerVOs.add(new EsignSignerVO((ElsSigners)((Object)purhcaseSigners.get(0)), 2L));
            } else {
                signerVOs.add(new EsignSignerVO((ElsSigners)((Object)purhcaseSigners.get(0)), 1L));
            }
        } else {
            if (!saleSigners.isEmpty()) {
                signerVOs.add(new EsignSignerVO((ElsSigners)((Object)saleSigners.get(0)), 2L));
            }
            signerVOs.add(new EsignSignerVO((ElsSigners)((Object)purhcaseSigners.get(0)), 1L));
        }
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? this.address + "els/esign/esignOperation/callback/esign" : this.address + "/els/esign/esignOperation/callback/esign";
        CreateFlowOneStep flowOneStep = new CreateFlowOneStep();
        flowOneStep.setSigners(signerVOs);
        ArrayList<EsignCopiersVO> copiersVOs = new ArrayList<EsignCopiersVO>();
        EsignCopiersVO copiersVO = new EsignCopiersVO();
        copiersVO.setCopierAccountId(((ElsSigners)((Object)purhcaseSigners.get(0))).getAccountId());
        copiersVO.setCopierIdentityAccountId(((ElsSigners)((Object)purhcaseSigners.get(0))).getOrgId());
        copiersVO.setCopierIdentityAccountType("1");
        copiersVOs.add(copiersVO);
        flowOneStep.setCopiers(copiersVOs);
        ArrayList<EsignDocsVO> docsVOs = new ArrayList<EsignDocsVO>();
        EsignDocsVO docsVO = new EsignDocsVO();
        docsVO.setFileId(esign.getFilesId());
        docsVO.setFileName(esign.getFilesName());
        docsVOs.add(docsVO);
        flowOneStep.setDocs(docsVOs);
        EsignFlowInfoVO flowInfoVO = new EsignFlowInfoVO(esign, (ElsSigners)((Object)purhcaseSigners.get(0)), notifyUrl);
        flowOneStep.setFlowInfo(flowInfoVO);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)flowOneStep)), this.service, this.configMap.get("esign.one-step-flow-start"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            return Result.error((String)("\u4e00\u6b65\u7b7e\u7f72\u53d1\u8d77\u5931\u8d25:" + response.getMessage()));
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        esign.setFlowId(jsonObject.getString("flowId"));
        esign.setLaunch("1");
        esign.setEsignStatus(EsignStatusEmun.UNFINISHED.getValue());
        if ("1".equals(esign.getAutoInitiate())) {
            esign.setInitiate("1");
        }
        this.elsEsignService.updateById((Object)esign);
        ((ElsSigners)((Object)purhcaseSigners.get(0))).setFlowId(esign.getFlowId());
        this.elsSignersService.updateById(purhcaseSigners.get(0));
        if (!saleSigners.isEmpty()) {
            ((ElsSigners)((Object)saleSigners.get(0))).setFlowId(esign.getFlowId());
            this.elsSignersService.updateById(saleSigners.get(0));
        }
        return Result.ok((String)"\u53d1\u8d77\u6210\u529f");
    }

    @Override
    public void esignSigner(JSONObject object) {
        if (SIGN_FLOW_UPDATE.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            wrapper.eq((Object)"account_id", (Object)object.getString("accountId"));
            List signers = this.elsSignersService.list((Wrapper)wrapper);
            if (!signers.isEmpty()) {
                ElsSigners elsSigners = (ElsSigners)((Object)signers.get(0));
                if (A_SIGNED.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                } else if (LOSE.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.LOSE.getValue());
                    elsSigners.setReason(object.getString("resultDescription"));
                } else if (REFUSAL.equals(object.getInteger("signResult"))) {
                    elsSigners.setEsignStatus(EsignSignerStatusEmun.REFUSAL.getValue());
                    elsSigners.setReason(object.getString("resultDescription"));
                }
                this.elsSignersService.updateById((Object)elsSigners);
                ElsEsign esign = (ElsEsign)((Object)this.elsEsignService.getById((Serializable)((Object)elsSigners.getHeadId())));
                if (EsignRoleTypeEnum.PURCHASE.getValue().equals(elsSigners.getRoleType())) {
                    esign.setPurchaseEsignStatus(elsSigners.getEsignStatus());
                } else {
                    esign.setSaleEsignStatus(elsSigners.getEsignStatus());
                }
                this.elsEsignService.updateById((Object)esign);
            }
        } else if (SIGN_FLOW_FINISH.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            List esigns = this.elsEsignService.list((Wrapper)wrapper);
            if (!esigns.isEmpty()) {
                ElsEsign esign = (ElsEsign)((Object)esigns.get(0));
                esign.setEsignStatus(object.getString("flowStatus"));
                if (EsignStatusEmun.UNDONE.getValue().equals(object.getString("flowStatus"))) {
                    esign.setLaunch("0");
                }
                PurchaseContractHeadDTO contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId());
                if ("2".equals(object.getString("flowStatus")) && "1".equals(esign.getAutoArchiving())) {
                    esign.setArchiving("1");
                    if (contractHead != null) {
                        contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                    }
                }
                esign.setReason(object.getString("statusDescription"));
                this.elsEsignService.updateById((Object)esign);
                if (contractHead != null) {
                    contractHead.setEndSign(esign.getEsignStatus());
                    this.esignInvokeContractRpcService.updatePurchaseEntityById(contractHead);
                    SaleContractHeadDTO saleContractHead = this.esignInvokeContractRpcService.getSaleContractById(contractHead.getRelationId());
                    if (saleContractHead != null) {
                        saleContractHead.setContractStatus(contractHead.getContractStatus());
                        saleContractHead.setEndSign(contractHead.getEndSign());
                        this.esignInvokeContractRpcService.updateSaleEntityById(saleContractHead);
                    }
                }
            }
        }
    }

    @Override
    public Result<?> startFlow(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.elsEsignService.getById((Serializable)((Object)id)));
        if ("1".equals(esign.getAutoInitiate())) {
            return Result.error((String)"\u8be5\u5355\u636e\u6d41\u7a0b\u4e3a\u81ea\u52a8\u5f00\u542f");
        }
        if (esign != null && StringUtils.isNotBlank((CharSequence)esign.getFlowId())) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.configMap.get("esign.flow-start"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                return Result.error((String)("\u6d41\u7a0b\u5f00\u8d77\u5931\u8d25:" + response.getMessage()));
            }
            esign.setInitiate("1");
            this.elsEsignService.updateById((Object)esign);
            return Result.ok((String)"\u6d41\u7a0b\u5f00\u542f\u6210\u529f");
        }
        return Result.error((String)"\u8be5\u5355\u636e\u8fd8\u672a\u53d1\u8d77\u4e00\u6b65\u7b7e\u7f72\u6d41\u7a0b\uff0c\u65e0\u6cd5\u5f00\u542f");
    }

    @Override
    public Result<?> archiveFlow(String id) {
        ElsEsign esign = (ElsEsign)((Object)this.elsEsignService.getById((Serializable)((Object)id)));
        if ("1".equals(esign.getAutoArchiving())) {
            return Result.error((String)"\u8be5\u5355\u636e\u6d41\u7a0b\u4e3a\u81ea\u52a8\u5f52\u6863");
        }
        if (esign != null && EsignSignerStatusEmun.A_SIGNED.getValue().equals(esign.getPurchaseEsignStatus()) && EsignSignerStatusEmun.A_SIGNED.getValue().equals(esign.getSaleEsignStatus())) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.configMap.get("esign.flow-archive"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
            if (!response.isSuccess()) {
                return Result.error((String)("\u6d41\u7a0b\u5f52\u6863\u5931\u8d25:" + response.getMessage()));
            }
            esign.setArchiving("1");
            this.elsEsignService.updateById((Object)esign);
            PurchaseContractHeadDTO contractHead = this.esignInvokeContractRpcService.getPurchaseContractById(esign.getRelationId());
            if (contractHead != null) {
                contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                this.esignInvokeContractRpcService.updatePurchaseEntityById(contractHead);
                SaleContractHeadDTO saleContractHead = this.esignInvokeContractRpcService.getSaleContractById(contractHead.getRelationId());
                if (saleContractHead != null) {
                    saleContractHead.setContractStatus(contractHead.getContractStatus());
                    this.esignInvokeContractRpcService.updateSaleEntityById(saleContractHead);
                }
            }
            return Result.ok((String)"\u6d41\u7a0b\u5f52\u6863\u6210\u529f");
        }
        return Result.error((String)"\u672a\u7b7e\u7f72\u5b8c\u6210\u7684\u6d41\u7a0b\u65e0\u6cd5\u8fdb\u884c\u5f52\u6863");
    }
}

