/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.thirdParty.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.RestUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.rpc.service.AccountInvokeInquiryRpcService;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.enumerate.SupplierFrozenStatusEnum;
import com.els.modules.supplier.api.enumerate.SupplierStatusEnum;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.mapper.ElsTenantMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.mapper.RolePermissionMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.thirdParty.dto.AccountToken;
import com.els.modules.thirdParty.dto.SsoInfo;
import com.els.modules.thirdParty.entity.ThirdPartyEntity;
import com.els.modules.thirdParty.service.ThirdPartyService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;

@Api(tags={"\u7b2c\u4e09\u65b9\u5e73\u53f0\u63a5\u5165\u521b\u5efa\u5b9e\u4f8b"})
@RestController
@RequestMapping(value={"/thirdParty"})
public class ThirdPartyController
extends BaseController<ThirdPartyEntity, ThirdPartyService> {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyController.class);
    @Autowired
    @Lazy
    private RedisUtil redisUtil;
    @Autowired
    private ThirdPartyService thirdPartyService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired(required=false)
    private ImGroupInvokeRpcService baseImGroupService;
    @Autowired
    private ElsTenantMapper elsTenantMapper;
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private RolePermissionMapper rolePermissionMapper;
    @Autowired
    private RoleService roleService;
    private static final String TXY_NAME = "\u817e\u8baf\u4e91\u8d26\u53f7_";
    private static final String TXY_SUB_NAME = "\u817e\u8baf\u4e91\u5b50\u8d26\u53f7";
    private static final String TXY_SOURCE = "\u817e\u8baf\u4e91";
    private static final String token = "thisisatoken";
    @Value(value="${els.config.service.address}")
    private String addressName;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    @Lazy
    private AccountInvokeInquiryRpcService accountInvokeInquiryRpcService;

    @ApiOperation(value="\u817e\u8baf\u4e91\u5bf9\u63a5\u63a5\u53e3", notes="\u817e\u8baf\u4e91\u5bf9\u63a5\u63a5\u53e3")
    @PostMapping(value={"/interfaceToTxy"})
    public JSONObject interfaceToTxy(@RequestBody JSONObject jsonObject, @RequestParam(name="signature") String signature, @RequestParam(name="timestamp") String timestamp, @RequestParam(name="eventId") String eventId) {
        log.info("ThirdPartyController->interfaceToTxy: signature: " + signature + " token: " + token + " timestamp: " + timestamp + " eventId: " + eventId);
        JSONObject json = new JSONObject();
        String action = jsonObject.getString("action");
        json = "verifyInterface".equals(action) ? this.verify(jsonObject, signature, timestamp, eventId) : ("createInstance".equals(action) ? this.create(jsonObject, signature, timestamp, eventId) : this.edit(jsonObject, signature, timestamp, eventId));
        return json;
    }

    public JSONObject verify(JSONObject jsonObject, String signature, String timestamp, String eventId) {
        log.info("ThirdPartyController->verify: signature: " + signature + " token: " + token + " timestamp: " + timestamp + " eventId: " + eventId);
        JSONObject json = new JSONObject();
        String echoback = jsonObject.getString("echoback");
        boolean flag = this.verifyInterface(signature, token, timestamp, eventId);
        if (flag) {
            json.put("echoback", (Object)echoback);
            log.info("ThirdPartyController->verify json: " + json.toJSONString());
        } else {
            json.put("echoback", (Object)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5");
            log.info("ThirdPartyController->verify json: " + json.toJSONString());
        }
        return json;
    }

    private boolean verifyInterface(String signature, String token, String timestamp, String eventId) {
        log.info("ThirdPartyController->verifyInterface: signature: " + signature + " token: " + token + " timestamp: " + timestamp + " eventId: " + eventId);
        Long nowTime = System.currentTimeMillis();
        if (nowTime - Long.valueOf(timestamp) * 1000L > 30000L) {
            log.error("\u7b7e\u540d\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(token);
        list.add(timestamp);
        list.add(eventId);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Collator com = Collator.getInstance(Locale.CHINA);
                return com.compare(o1, o2);
            }
        });
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(s);
        }
        String key = ThirdPartyController.getSHA256String(sb.toString());
        if (signature.equals(key)) {
            return true;
        }
        log.error("\u8eab\u4efd\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5");
        return false;
    }

    public JSONObject create(JSONObject jsonObject, String signature, String timestamp, String eventId) {
        log.info("ThirdPartyController->create: " + jsonObject.toJSONString() + "signature: " + signature + " token: " + token + " timestamp: " + timestamp + " eventId: " + eventId);
        JSONObject json = new JSONObject();
        boolean flag = this.verifyInterface(signature, token, timestamp, eventId);
        if (!flag) {
            json.put("success", (Object)false);
            log.info("ThirdPartyController->create json: " + json.toJSONString());
            return json;
        }
        String action = jsonObject.getString("action");
        String orderId = jsonObject.getString("orderId");
        boolean rs = true;
        if (StringUtils.isNotBlank((CharSequence)((String)this.redisUtil.get(orderId)))) {
            rs = false;
        } else {
            this.redisUtil.set(orderId, (Object)orderId);
        }
        String elsAccount = null;
        if (rs) {
            JSONObject object;
            ThirdPartyEntity thirdPartyEntity = new ThirdPartyEntity();
            String accountId = jsonObject.getString("accountId");
            String openId = jsonObject.getString("openId");
            String productId = jsonObject.getString("productId");
            String requestId = jsonObject.getString("requestId");
            JSONObject productInfo = jsonObject.getJSONObject("productInfo");
            String productName = productInfo.getString("productName");
            String isTrial = productInfo.getString("isTrial");
            String spec = productInfo.getString("spec");
            String timeSpan = productInfo.getString("timeSpan");
            String timeUnit = productInfo.getString("timeUnit");
            JSONObject extendInfo = jsonObject.getJSONObject("extendInfo");
            String commentStr = extendInfo.getString("comment");
            if (StringUtils.isNotBlank((CharSequence)commentStr)) {
                JSONObject comment = JSONObject.parseObject((String)commentStr);
                log.info("ThirdPartyController->create: comment: " + comment.toJSONString());
                thirdPartyEntity.setComment(comment.toJSONString());
                String SSOInfo = comment.getString("SSOInfo");
                if (StringUtils.isNotBlank((CharSequence)SSOInfo)) {
                    JSONObject info = JSONObject.parseObject((String)SSOInfo);
                    log.info("ThirdPartyController->create: comment: " + info.toJSONString());
                    thirdPartyEntity.setSsoInfo(info.toJSONString());
                }
            }
            thirdPartyEntity.setId(UUID.randomUUID().toString().replace("-", "").substring(0, 11));
            thirdPartyEntity.setOrderid(orderId);
            thirdPartyEntity.setAccountid(accountId);
            thirdPartyEntity.setOpenid(openId);
            thirdPartyEntity.setProductid(productId);
            thirdPartyEntity.setRequestid(requestId);
            thirdPartyEntity.setProductname(productName);
            if ("true".equals(isTrial)) {
                thirdPartyEntity.setIstrial(0);
            } else {
                thirdPartyEntity.setIstrial(1);
                thirdPartyEntity.setSpec(spec);
                thirdPartyEntity.setTimespan(Integer.valueOf(timeSpan));
                thirdPartyEntity.setTimeunit(timeUnit);
            }
            thirdPartyEntity.setCreateTime(new Date());
            thirdPartyEntity.setStatus(0);
            thirdPartyEntity.setDeleted(0);
            this.thirdPartyService.saveThirdPartyEntity(thirdPartyEntity);
            Integer count = this.thirdPartyService.countThirdParty();
            String interfaceCode = "getEnterpriseInfo";
            JSONObject realbody = new JSONObject();
            JSONObject base = new JSONObject();
            base.put("name", (Object)(TXY_NAME + count));
            base.put("els_account", (Object)"307001");
            base.put("app_code", (Object)"srm_dev");
            realbody.put("base", (Object)base);
            Result response = this.invokeBaseRpcService.callInterfacePost(interfaceCode, realbody);
            if (response.isSuccess() && StringUtils.isNotBlank((CharSequence)response.getMessage()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(object = JSONObject.parseObject((String)response.getMessage())).getString("code")}) && "200".equals(object.getString("code"))) {
                ElsEnterpriseInfo elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)JSON.parseObject((String)object.getString("data"), ElsEnterpriseInfo.class));
                elsEnterpriseInfo.setDeleted(0);
                elsAccount = elsEnterpriseInfo.getElsAccount();
                this.elsEnterpriseInfoMapper.insert((Object)elsEnterpriseInfo);
                this.saveSubAccountInfo(elsEnterpriseInfo.getElsAccount());
                this.invokeBaseRpcService.callInterfacePost("add_enterprise_relation", this.makeEnterpriseRelationJson(TenantContext.getTenant(), elsEnterpriseInfo.getElsAccount()));
                ThirdAccount user = new ThirdAccount();
                user.setDeleted(CommonConstant.DEL_FLAG_0);
                user.setStatus(1);
                user.setThirdType(TXY_SOURCE);
                user.setRealname(elsEnterpriseInfo.getName());
                user.setThirdUserUuid(orderId + "_" + accountId);
                user.setUserId("1001");
                user.setElsAccount(elsEnterpriseInfo.getElsAccount());
                user.setCreateTime(new Date());
                this.thirdAccountService.save((Object)user);
            }
            json.put("signId", (Object)thirdPartyEntity.getId());
        } else {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(ThirdPartyEntity::getOrderid, (Object)orderId);
            ThirdPartyEntity one = (ThirdPartyEntity)this.thirdPartyService.getOne((Wrapper)query);
            ThirdAccount account = this.queryElsAccount(one.getId());
            elsAccount = account.getElsAccount();
            json.put("signId", (Object)one.getId());
        }
        JSONObject appInfo = new JSONObject();
        appInfo.put("website", (Object)this.addressName);
        appInfo.put("authUrl", (Object)(this.addressName + "user/login"));
        json.put("appInfo", (Object)appInfo);
        JSONArray additionalInfo = new JSONArray();
        JSONObject obj1 = new JSONObject();
        obj1.put("name", (Object)"SSOLoginURL");
        obj1.put("value", (Object)(this.addressName + "els/thirdParty/callback/" + elsAccount));
        JSONObject obj2 = new JSONObject();
        obj2.put("name", (Object)"RedirectURI");
        obj2.put("value", (Object)(this.addressName + "els/thirdParty/callbackLogin/" + elsAccount + "/getCode"));
        additionalInfo.add((Object)obj1);
        additionalInfo.add((Object)obj2);
        json.put("additionalInfo", (Object)additionalInfo);
        log.info("ThirdPartyController->create json: " + json.toJSONString());
        return json;
    }

    private ThirdAccount queryElsAccount(String instanceId) {
        log.info("ThirdPartyController.queryElsAccount->instanceId: " + instanceId);
        ThirdPartyEntity entity = (ThirdPartyEntity)this.thirdPartyService.getById((Serializable)((Object)instanceId));
        String accountId = entity.getAccountid();
        String orderId = entity.getOrderid();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ThirdAccount::getThirdUserUuid, (Object)(orderId + "_" + accountId));
        ThirdAccount account = (ThirdAccount)((Object)this.thirdAccountService.getOne((Wrapper)query));
        return account;
    }

    public JSONObject edit(JSONObject jsonObject, String signature, String timestamp, String eventId) {
        log.info("ThirdPartyController->edit: " + jsonObject.toJSONString() + "signature: " + signature + " token: " + token + " timestamp: " + timestamp + " eventId: " + eventId);
        JSONObject json = new JSONObject();
        boolean flag = this.verifyInterface(signature, token, timestamp, eventId);
        if (!flag) {
            json.put("success", (Object)false);
            log.info("ThirdPartyController->edit json: " + json.toJSONString());
            return json;
        }
        ThirdPartyEntity thirdPartyEntity = new ThirdPartyEntity();
        String action = jsonObject.getString("action");
        String orderId = jsonObject.getString("orderId");
        String accountId = jsonObject.getString("accountId");
        String openId = jsonObject.getString("openId");
        String productId = jsonObject.getString("productId");
        String requestId = jsonObject.getString("requestId");
        String signId = jsonObject.getString("signId");
        thirdPartyEntity.setId(signId);
        thirdPartyEntity.setAccountid(accountId);
        thirdPartyEntity.setOpenid(openId);
        thirdPartyEntity.setProductid(productId);
        if ("renewInstance".equals(action)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String instanceExpireTime = jsonObject.getString("instanceExpireTime");
            thirdPartyEntity.setInstanceExpireTime(instanceExpireTime);
        } else if ("expireInstance".equals(action)) {
            thirdPartyEntity.setStatus(1);
        } else if ("destroyInstance".equals(action)) {
            thirdPartyEntity.setDeleted(1);
        }
        this.thirdPartyService.updateThirdPartyEntity(thirdPartyEntity);
        json.put("success", (Object)true);
        log.info("ThirdPartyController->edit json: " + json.toJSONString());
        return json;
    }

    @GetMapping(value={"/callback/{elsAccount}"})
    public void callback(HttpServletRequest request, HttpServletResponse response, @PathVariable String elsAccount, @RequestParam(name="code", required=false) String code, @RequestParam(name="state", required=false) String state, @RequestBody(required=false) JSONObject jsonObject) throws IOException {
        boolean expireToken;
        log.info("ThirdPartyController->callback: elsAccount: " + elsAccount);
        String tokenCode = "QFYU_ACCOUNT_TOKEN_" + elsAccount;
        String token = (String)this.redisUtil.get(tokenCode);
        ThirdPartyEntity entity = this.getThirdPartyEntity(elsAccount);
        if (null == entity) {
            log.info("elsAccount\u8d26\u53f7\uff1a" + elsAccount + " \u6682\u65e0\u5bf9\u5e94\u5173\u7cfb");
            Result.error((String)("elsAccount\u8d26\u53f7\uff1a" + elsAccount + " \u6682\u65e0\u5bf9\u5e94\u5173\u7cfb"));
            return;
        }
        SsoInfo ssoinfo = (SsoInfo)JSON.parseObject((String)entity.getSsoInfo(), SsoInfo.class);
        if (StringUtils.isBlank((CharSequence)token)) {
            String param = "?response_type=code&client_id=" + ssoinfo.getClientId() + "&redirect_uri=" + this.addressName + "els/thirdParty/callbackLogin/" + elsAccount + "/getCode&scope=openid%20offline_access";
            log.info("callback --> redirectUrl: [{}]", (Object)(ssoinfo.getAuthorizationEndpoint() + param));
            response.sendRedirect(ssoinfo.getAuthorizationEndpoint() + param);
            return;
        }
        boolean bl = expireToken = this.redisUtil.getExpire(tokenCode) <= 1L;
        if (expireToken) {
            String refreshToken = this.redisUtil.get("QFYU_REFRESH_TOKEN" + elsAccount).toString();
            this.refreshToken(elsAccount, ssoinfo, refreshToken, ssoinfo.getTokenEndpoint());
        }
    }

    @GetMapping(value={"/callbackLogin/{elsAccount}/{type}"})
    public void callbackLogin(HttpServletRequest request, HttpServletResponse response, @PathVariable String elsAccount, @PathVariable String type) throws Exception {
        log.info("callbackLogin,inputParam [type:{}, elsAccount:{}]", (Object)type, (Object)elsAccount);
        JSONObject jsonObject = new JSONObject();
        ThirdPartyEntity entity = this.getThirdPartyEntity(elsAccount);
        if (null == entity) {
            log.info("elsAccount\u8d26\u53f7\uff1a" + elsAccount + " \u6682\u65e0\u5bf9\u5e94\u5173\u7cfb");
            Result.error((String)("elsAccount\u8d26\u53f7\uff1a" + elsAccount + " \u6682\u65e0\u5bf9\u5e94\u5173\u7cfb"));
            return;
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"getCode")) {
            String code = this.getRequestParam(request, response, "code").toString();
            log.info("callbackLogin,inputParam [code:{} , state:{}]", (Object)code, (Object)"");
            jsonObject = this.getToken(entity, code, "", request, response, elsAccount);
        }
        String idToken = jsonObject.getString("id_token");
        String accessToken = jsonObject.getString("access_token");
        String refreshToken = jsonObject.getString("refresh_token");
        String tokenType = jsonObject.getString("token_type");
        Integer expiresIn = jsonObject.getInteger("expires_in");
        log.info("callbackLogin,inputParam [idToken:{} , accessToken:{} , refreshToken:{} , tokenType:{} , expiresIn:{}]", new Object[]{idToken, accessToken, refreshToken, tokenType, expiresIn});
        this.redisUtil.set("QFYU_ACCOUNT_TOKEN" + elsAccount, (Object)accessToken, (long)expiresIn.intValue());
        this.redisUtil.set("QFYU_ID_TOKEN" + elsAccount, (Object)idToken, (long)expiresIn.intValue());
        this.redisUtil.set("QFYU_REFRESH_TOKEN" + elsAccount, (Object)refreshToken, (long)expiresIn.intValue());
        LoginUser loginUser = this.sysBaseAPI.getUserByAccount(elsAccount + "_1001");
        String token = this.saveToken(loginUser, expiresIn);
        response.setStatus(301);
        response.setHeader("Location", "https://srm-dist.51qqt.com/");
        response.sendRedirect(this.addressName + "user/login?token=" + token);
    }

    protected ThirdAccount getThirdAccount(String elsAccount) {
        LambdaQueryWrapper thirdQuery = new LambdaQueryWrapper();
        thirdQuery.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        return (ThirdAccount)((Object)this.thirdAccountService.getOne((Wrapper)thirdQuery));
    }

    protected ThirdPartyEntity getThirdPartyEntity(String elsAccount) {
        ThirdAccount account = this.getThirdAccount(elsAccount);
        if (null == account) {
            log.info("elsAccount{}\u627e\u4e0d\u5230\u5bf9\u5e94\u5173\u7cfb", (Object)elsAccount);
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWWWWWWWWWWYxuIdRH_766b00bf", (String)"elsAccount${0}\u627e\u4e0d\u5230\u5bf9\u5e94\u5173\u7cfb", (String[])new String[]{elsAccount}));
        }
        String orderId = account.getThirdUserUuid().split("_")[0];
        String accountId = account.getThirdUserUuid().split("_")[1];
        return this.thirdPartyService.getEntityByElsAccount(accountId, orderId);
    }

    public boolean checkUserTokenIsEffect(ElsSubAccount accountInfo, String token) throws AuthenticationException {
        String account = JwtUtil.getAccount((String)token);
        if (account == null) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_WWWWWuhSXW_88a8eac9", (String)"token\u975e\u6cd5\u65e0\u6548!"));
        }
        if (accountInfo.getStatus() != 1) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_eyIqdIWVKHRvjW_42c9dc43", (String)"\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
        }
        if (!this.jwtTokenRefresh(token, account, accountInfo.getPassword())) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_WWWWWKXWVVVEHW_8bdef769", (String)"Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!"));
        }
        return true;
    }

    public boolean jwtTokenRefresh(String token, String account, String passWord) {
        String cacheToken = String.valueOf(this.redisUtil.get("sys:token:" + token));
        if (ConvertUtils.isNotEmpty((Object)cacheToken)) {
            if (!JwtUtil.verify((String)cacheToken, (String)account, (String)passWord)) {
                String newAuthorization = JwtUtil.sign((String)account, (String)passWord);
                this.redisUtil.set("sys:token:" + token, (Object)newAuthorization);
                this.redisUtil.expire("sys:token:" + token, 3600L);
            }
            return true;
        }
        return false;
    }

    private String saveToken(LoginUser loginUser, Integer expiresIn) {
        log.info("ThirdPartyController->saveToken: loginUser: " + loginUser + ", expiresIn: " + expiresIn);
        String token = JwtUtil.sign((String)(loginUser.getElsAccount() + "_" + loginUser.getSubAccount()), (String)loginUser.getPassword());
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, (long)expiresIn.intValue());
        return token;
    }

    protected Object getRequestParam(HttpServletRequest request, HttpServletResponse response, String paramName) throws Exception {
        return ServletRequestUtils.getRequiredStringParameter((ServletRequest)new ServletWebRequest(request, response).getRequest(), (String)paramName);
    }

    protected JSONObject getToken(ThirdPartyEntity entity, String code, String state, HttpServletRequest request, HttpServletResponse response, String elsAccount) {
        SsoInfo ssoinfo = (SsoInfo)JSON.parseObject((String)entity.getSsoInfo(), SsoInfo.class);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Basic " + this.base64(ssoinfo.getClientId() + ":" + ssoinfo.getClientSecret()));
        headers.setContentType(MediaType.parseMediaType((String)"application/json"));
        String url = ssoinfo.getTokenEndpoint();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("grant_type", (Object)"authorization_code");
        jsonObject.put("code", (Object)code);
        jsonObject.put("redirect_uri", (Object)(this.addressName + "els/thirdParty/callbackLogin/" + elsAccount + "/getCode"));
        log.info("ThirdPartyController-->getToken[url: {},headers: {}, json: {}]", new Object[]{url, headers.toString(), jsonObject.toString()});
        ResponseEntity result = RestUtil.request((String)url, (HttpMethod)HttpMethod.POST, (HttpHeaders)headers, null, (JSONObject)jsonObject, JSONObject.class);
        log.info("ThirdPartyController-->getToken: result: " + result.getBody());
        return (JSONObject)result.getBody();
    }

    protected void refreshToken(String elsAccount, SsoInfo ssoinfo, String refreshToken, String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Basic " + this.base64(ssoinfo.getClientId() + ":" + ssoinfo.getClientSecret()));
        headers.setContentType(MediaType.parseMediaType((String)"application/x-www-form-urlencoded"));
        JSONObject param = new JSONObject();
        param.put("grant_type", (Object)"refresh_token");
        param.put("refresh_token", (Object)refreshToken);
        log.info("ThirdPartyController-->refreshToken[url: {},headers: {}]", (Object)ssoinfo.getUserInfoEndpoint(), (Object)headers.toString());
        ResponseEntity result = RestUtil.request((String)url, (HttpMethod)HttpMethod.POST, (HttpHeaders)headers, null, (JSONObject)param, AccountToken.class);
        AccountToken accountToken = (AccountToken)result.getBody();
        this.redisUtil.set("QFYU_ACCOUNT_TOKEN" + elsAccount, (Object)accountToken, (long)accountToken.getExpires_in().intValue());
        this.redisUtil.set("QFYU_ID_TOKEN" + elsAccount, (Object)accountToken.getId_token(), (long)accountToken.getExpires_in().intValue());
        this.redisUtil.set("QFYU_REFRESH_TOKEN" + elsAccount, (Object)accountToken.getRefresh_token(), (long)accountToken.getExpires_in().intValue());
    }

    protected void getUserInfo(String elsAccount, SsoInfo ssoinfo, String accountToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Basic " + accountToken);
        headers.setContentType(MediaType.parseMediaType((String)"application/json"));
        log.info("ThirdPartyController-->getUserInfo[url: {},headers: {}]", (Object)ssoinfo.getUserInfoEndpoint(), (Object)headers.toString());
        ResponseEntity result = RestUtil.request((String)ssoinfo.getUserInfoEndpoint(), (HttpMethod)HttpMethod.POST, (HttpHeaders)headers, null, null, JSONObject.class);
        JSONObject json = (JSONObject)result.getBody();
        String sub = json.getString("sub");
    }

    public String base64(String str) {
        byte[] bytes = str.getBytes();
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String getSHA256String(String str) {
        log.info("ThirdPartyController->getSHA256String: " + str);
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodeStr = ThirdPartyController.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        log.info("ThirdPartyController->getSHA256String: encodeStr: " + encodeStr);
        return encodeStr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    public void saveSupplierMasterData(ElsEnterpriseInfo elsEnterpriseInfo, SupplierMasterDataDTO data, String elsAccount) {
        data.setElsAccount(elsAccount);
        data.setToElsAccount(elsEnterpriseInfo.getElsAccount());
        data.setSupplierName(elsEnterpriseInfo.getName());
        data.setSourceType("2");
        data.setStatus(SupplierFrozenStatusEnum.NORMAL.getValue());
        data.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
        data.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        this.accountInvokeInquiryRpcService.insertSupplierMasterData(data);
    }

    public void saveSubAccountInfo(String elsAccount) {
        ElsSubAccount account = new ElsSubAccount();
        account.setElsAccount(elsAccount);
        account.setSubAccount("1001");
        account.setRealname(TXY_SUB_NAME);
        account.setStatus(1);
        String salt = ConvertUtils.randomGen((int)8);
        account.setSalt(salt);
        String pd = "123456";
        String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + account.getSubAccount()), (String)pd, (String)salt);
        account.setPassword(passwordEncode);
        account.setDeleted(0);
        Role role = new Role();
        role.setElsAccount(elsAccount);
        role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
        role.setRoleCode("yun");
        this.roleMapper.insert(role);
        this.elsSubAccountService.addUserWithRole(account, role.getId());
        try {
            this.baseImGroupService.initGroup(account.getId());
        }
        catch (Exception e) {
            log.error("::: \u521d\u59cb\u5316\u7528\u6237\u5206\u7ec4{}\u5931\u8d25==>{}", (Object)account.getId(), (Object)e.getMessage());
        }
        ElsTenant elsTenant = new ElsTenant();
        elsTenant.setAccountStatus("1");
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setCompanyName(TXY_SUB_NAME);
        elsTenant.setSourceType("2");
        try {
            elsTenant.setExpiryDate(new SimpleDateFormat("yyyy-MM-dd").parse("2029-12-31"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.elsTenantMapper.insert((Object)elsTenant);
        TenantContext.setTenant((String)"100000");
        LambdaQueryWrapper param = new LambdaQueryWrapper();
        param.eq(Role::getRoleCode, (Object)"yun");
        Role one = (Role)this.roleService.getOne((Wrapper)param);
        if (null != one) {
            List list = this.rolePermissionMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(RolePermission::getRoleId, (Object)one.getId()));
            HashMap<String, String> map = new HashMap<String, String>();
            if (list != null) {
                for (RolePermission rolePermission : list) {
                    RolePermission entity = new RolePermission();
                    entity.setElsAccount(elsAccount);
                    entity.setRoleId(role.getId());
                    entity.setPermissionId(rolePermission.getPermissionId());
                    this.rolePermissionMapper.insert(entity);
                    map.put(rolePermission.getPermissionId(), "1");
                }
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            List permissionList = this.permissionMapper.selectList((Wrapper)queryWrapper);
            if (permissionList != null) {
                ArrayList<CompanyPermission> companyPermissions = new ArrayList<CompanyPermission>();
                for (Permission permission : permissionList) {
                    if (!"1".equals(map.get(permission.getId()))) continue;
                    CompanyPermission companyPermission = new CompanyPermission();
                    companyPermission.setId(IdWorker.getIdStr());
                    companyPermission.setElsAccount(elsAccount);
                    companyPermission.setPermissionId(permission.getId());
                    companyPermission.setName(permission.getName());
                    companyPermission.setSortNo(permission.getSortNo());
                    companyPermission.setIcon(permission.getIcon());
                    companyPermission.setIconColor(permission.getIconColor());
                    companyPermission.setRuleFlag(permission.getRuleFlag());
                    companyPermission.setStatus(permission.getStatus());
                    companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
                    companyPermission.setUpdateTime(new Date());
                    companyPermissions.add(companyPermission);
                }
                if (!companyPermissions.isEmpty()) {
                    this.permissionMapper.insertCompanyMeunBatch(companyPermissions);
                }
            }
        }
    }

    public JSONObject makeEnterpriseRelationJson(String purchaseAccount, String providerAccount) {
        JSONObject base = new JSONObject();
        base.put("purchaser_els_account", (Object)purchaseAccount);
        base.put("provider_els_account", (Object)providerAccount);
        base.put("els_account", (Object)TenantContext.getTenant());
        base.put("app_code", (Object)"7eceb23fe36a4a9c9de4098f7b4b244b");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("header", (Object)this.makeHeader());
        jsonObject.put("base", (Object)base);
        return jsonObject;
    }

    public JSONObject makeHeader() {
        JSONObject header = new JSONObject();
        header.put("app-security", (Object)"de324586-8180-11eb-89be-506b4bdb8f79");
        header.put("app-key", (Object)"caa7b92f-8180-11eb-89be-506b4bdb8f79");
        header.put("app-code", (Object)"interface_platform");
        return header;
    }
}

