/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.SysUserCacheInfo;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsPasswordPolicy;
import com.els.modules.system.entity.ElsPasswordRecord;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.ElsPasswordPolicyMapper;
import com.els.modules.system.mapper.ElsPasswordRecordMapper;
import com.els.modules.system.mapper.ElsPasswordSecurityMapper;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.service.AccountDeliverToService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.util.PwVerifyUtil;
import com.els.modules.system.vo.ElsPwComplexityAndMinLenVo;
import com.els.modules.system.vo.PermissionVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsSubAccountServiceImpl
extends ServiceImpl<ElsSubAccountMapper, ElsSubAccount>
implements ElsSubAccountService {
    private static final Logger log = LoggerFactory.getLogger(ElsSubAccountServiceImpl.class);
    @Resource
    private ElsSubAccountMapper userMapper;
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private ElsPasswordSecurityMapper pwSecurityMapper;
    @Resource
    private ElsPasswordRecordMapper pwRecordMapper;
    @Resource
    private ElsPasswordPolicyMapper pwPolicyMapper;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ISysBaseAPI baseAPI;
    @Autowired
    private RedisUtil redisUtil;

    private void pwComplexityAndLenVerify(String elsAccount, String pwString) {
        ElsPwComplexityAndMinLenVo complexityAndMinLenVo = this.pwSecurityMapper.getComplexityAndMinLen(elsAccount);
        if (complexityAndMinLenVo == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)complexityAndMinLenVo.getComplexity())) {
            PwVerifyUtil.pwComplexityVerify((Map)JSONObject.parseObject((String)complexityAndMinLenVo.getComplexity(), HashMap.class), pwString);
        }
        PwVerifyUtil.pwMinLengthVerify(pwString, complexityAndMinLenVo.getMinLength());
    }

    private void addPwUpdateRecord(String elsAccount, String elsSubAccount, String userName, String loginSubAccount) {
        ElsPasswordRecord elsPasswordRecord = new ElsPasswordRecord();
        Date now = new Date();
        elsPasswordRecord.setElsSubAccount(elsSubAccount).setUserName(userName).setElsAccount(elsAccount).setCreateBy(loginSubAccount).setUpdateBy(loginSubAccount).setCreateTime(now).setUpdateTime(now);
        this.pwRecordMapper.insert((Object)elsPasswordRecord);
    }

    private void updatePwPolicy(String elsAccount, String elsSubAccount, String userName, String loginSubAccount, Date pwCreateDate) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsPasswordPolicy::getElsSubAccount, (Object)elsSubAccount);
        ElsPasswordPolicy record = (ElsPasswordPolicy)((Object)this.pwPolicyMapper.selectOne((Wrapper)lambdaQueryWrapper));
        ElsPasswordPolicy elsPasswordPolicy = new ElsPasswordPolicy();
        Date now = new Date();
        if (record != null) {
            elsPasswordPolicy.setChangeTime((record.getChangeTime() == null ? 0 : record.getChangeTime()) + 1).setUpdateBy(loginSubAccount).setUpdateTime(now);
            this.pwPolicyMapper.update((Object)elsPasswordPolicy, (Wrapper)lambdaQueryWrapper);
            return;
        }
        elsPasswordPolicy.setElsSubAccount(elsSubAccount).setUserName(userName).setPasswordCreateDate(pwCreateDate).setChangeTime(0).setElsAccount(elsAccount).setCreateBy(loginSubAccount).setCreateTime(now).setUpdateBy(loginSubAccount).setUpdateTime(now);
        this.pwPolicyMapper.insert((Object)elsPasswordPolicy);
    }

    private void updatePasswordOper(String newpassword, String subAccount, String realName, Date createTime) {
        this.pwComplexityAndLenVerify(TenantContext.getTenant(), newpassword);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.addPwUpdateRecord(TenantContext.getTenant(), subAccount, realName, sysUser.getSubAccount());
        this.updatePwPolicy(TenantContext.getTenant(), subAccount, realName, sysUser.getSubAccount(), createTime);
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public Result<?> resetPassword(String subAccount, String oldpassword, String newpassword, String confirmpassword) {
        ElsSubAccount user = this.userMapper.getUserByAccount(TenantContext.getTenant() + "_" + subAccount);
        String passwordEncode = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + subAccount), (String)oldpassword, (String)user.getSalt());
        if (!user.getPassword().equals(passwordEncode)) {
            return Result.error((String)"\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef!");
        }
        if (ConvertUtils.isEmpty((Object)newpassword)) {
            return Result.error((String)"\u65b0\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        if (!newpassword.equals(confirmpassword)) {
            return Result.error((String)"\u4e24\u6b21\u8f93\u5165\u5bc6\u7801\u4e0d\u4e00\u81f4!");
        }
        this.updatePasswordOper(newpassword, subAccount, user.getRealname(), user.getCreateTime());
        String password = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + subAccount), (String)newpassword, (String)user.getSalt());
        this.userMapper.update((Object)new ElsSubAccount().setPassword(password), (Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)user.getId()));
        return Result.ok((String)"\u5bc6\u7801\u91cd\u7f6e\u6210\u529f!");
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    public Result<?> changePassword(ElsSubAccount account) {
        String salt = ConvertUtils.randomGen((int)8);
        account.setSalt(salt);
        String password = account.getPassword();
        String passwordEncode = PasswordUtil.encrypt((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)password, (String)salt);
        account.setPassword(passwordEncode);
        this.userMapper.updateById((Object)account);
        return Result.ok((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f!");
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @SrmTransaction(rollbackFor={Exception.class})
    public boolean deleteUser(String userId) {
        this.removeById((Serializable)((Object)userId));
        return false;
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @SrmTransaction(rollbackFor={Exception.class})
    public boolean deleteBatchUsers(String userIds) {
        this.removeByIds(Arrays.asList(userIds.split(",")));
        return false;
    }

    @Override
    public ElsSubAccount getUserBySubAccount(String subAccount) {
        return this.userMapper.getUserByAccount(TenantContext.getTenant() + "_" + subAccount);
    }

    @Override
    public ElsSubAccount getUserByAccount(String account) {
        return this.userMapper.getUserByAccount(account);
    }

    @Override
    @SrmTransaction
    public void addUserWithRole(ElsSubAccount user, String roles) {
        this.save((Object)user);
        this.insertRole(user, roles);
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, allEntries=true)
    @SrmTransaction
    public void editUserWithRole(ElsSubAccount user, String roles) {
        List roleList = this.roleService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Role::getElsAccount, (Object)user.getElsAccount())).eq(Role::getRoleCode, (Object)"companyAdmin"));
        Assert.notEmpty((Collection)roleList, (String)I18nUtil.translate((String)"", (String)"\u4f01\u4e1a\u4e2d\u5fc5\u987b\u5b58\u5728\u7ba1\u7406\u5458(companyAdmin)\u89d2\u8272"));
        String roleId = ((Role)roleList.get(0)).getId();
        if (!("," + roles + ",").contains("," + roleId + ",")) {
            List userRoles = this.userRoleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(UserRole::getRoleId, (Object)roleId));
            Assert.notEmpty((Collection)userRoles, (String)I18nUtil.translate((String)"", (String)"\u4f01\u4e1a\u4e2d\u5fc5\u987b\u5b58\u5728\u7ba1\u7406\u5458\u89d2\u8272"));
        }
        this.updateById((Object)user);
        this.userRoleMapper.delete((Wrapper)new QueryWrapper().lambda().eq(UserRole::getUserId, (Object)user.getId()));
        this.redisUtil.del(new String[]{"ELSACCOUNT_SUBACCOUNT" + user.getElsAccount() + user.getSubAccount()});
        this.insertRole(user, roles);
    }

    private void insertRole(ElsSubAccount user, String roles) {
        if (ConvertUtils.isNotEmpty((Object)roles)) {
            String[] arr;
            for (String roleId : arr = roles.split(",")) {
                UserRole userRole = new UserRole(user.getId(), roleId);
                this.userRoleMapper.insert(userRole);
            }
        }
    }

    @Override
    public List<String> getRole(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
    }

    @Override
    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        List<String> roles = this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------account\uff1a " + elsAccount + "_" + subAccount + ",Roles size: " + roles.size());
        return new HashSet<String>(roles);
    }

    @Override
    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        HashSet<String> permissionSet = new HashSet<String>();
        List<PermissionVO> permissionList = this.permissionMapper.queryByAccount(elsAccount, subAccount, 0);
        for (PermissionVO po : permissionList) {
            if (!ConvertUtils.isNotEmpty((Object)po.getPerms())) continue;
            permissionSet.add(po.getPerms());
        }
        return permissionSet;
    }

    @Override
    public SysUserCacheInfo getCacheUser(String account) {
        SysUserCacheInfo info = new SysUserCacheInfo();
        info.setOneDepart(true);
        LoginUser user = this.baseAPI.getUserByAccount(account);
        if (user != null) {
            info.setSysUserCode(user.getSubAccount());
            info.setSysUserName(user.getRealname());
            info.setSysOrgCode(user.getOrgCode());
        }
        return info;
    }

    @Override
    public IPage<ElsSubAccount> getUserByDepId(Page<ElsSubAccount> page, String departId, String username) {
        return this.userMapper.getUserByDepId(page, departId, username);
    }

    @Override
    public IPage<ElsSubAccount> getUserByDepartIdAndQueryWrapper(Page<ElsSubAccount> page, String departId, QueryWrapper<ElsSubAccount> queryWrapper) {
        LambdaQueryWrapper lambdaQueryWrapper = queryWrapper.lambda();
        lambdaQueryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
        lambdaQueryWrapper.inSql(BaseEntity::getId, "SELECT user_id FROM sys_user_depart WHERE dep_id = '" + departId + "'");
        return this.userMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
    }

    @Override
    public IPage<ElsSubAccount> getUserByRoleId(Page<ElsSubAccount> page, String roleId, String username) {
        return this.userMapper.getUserByRoleId(page, roleId, username);
    }

    @Override
    @CacheEvict(value={"sys:cache:user"}, key="#username")
    public void updateUserDepart(String username, String orgCode) {
        ((ElsSubAccountMapper)this.baseMapper).updateUserDepart(username, orgCode);
    }

    @Override
    public void accountFreezeJob() {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ElsSubAccount::getStatus, (Object)2)).le(ElsSubAccount::getAccountValidityDate, (Object)new Date())).isNotNull(ElsSubAccount::getAccountValidityDate)).update((Object)new ElsSubAccount());
    }

    @Override
    public ElsSubAccount getUserByPhone(String phone) {
        return this.userMapper.getUserByPhone(phone);
    }

    @Override
    public ElsSubAccount getUserByEmail(String email) {
        return this.userMapper.getUserByEmail(email);
    }

    public Result<?> checkUserIsEffective(ElsSubAccount account) {
        Result result = new Result();
        if (account == null) {
            result.error500("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u6ce8\u518c");
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728\uff01", Integer.valueOf(1), null);
            return result;
        }
        if (CommonConstant.DEL_FLAG_1.equals(account.getDeleted())) {
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + account.getSubAccount() + "\u5df2\u6ce8\u9500\uff01", Integer.valueOf(1), null);
            result.error500("\u8be5\u7528\u6237\u5df2\u6ce8\u9500");
            return result;
        }
        if (CommonConstant.USER_FREEZE.equals(account.getStatus())) {
            this.baseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + account.getSubAccount() + "\u5df2\u51bb\u7ed3\uff01", Integer.valueOf(1), null);
            result.error500("\u8be5\u7528\u6237\u5df2\u51bb\u7ed3");
            return result;
        }
        return result;
    }

    @Override
    public ElsSubAccount getByAccount(String elsAccount, String subAccount) {
        return this.userMapper.getUserByAccount(elsAccount + "_" + subAccount);
    }

    @Override
    public Map<String, String> getLogoSetByElsAccount(String elsAccount) {
        return this.userMapper.getLogoSetByElsAccount(elsAccount);
    }

    @Override
    @SrmTransaction
    public void deliverTo(String sourceAccountId, String targetAccountId) {
        String[] beans;
        ElsSubAccount sourceAccount = (ElsSubAccount)((Object)this.getById((Serializable)((Object)sourceAccountId)));
        ElsSubAccount targetAccount = (ElsSubAccount)((Object)this.getById((Serializable)((Object)targetAccountId)));
        for (String bean : beans = SpringContextUtils.getApplicationContext().getBeanNamesForType(AccountDeliverToService.class)) {
            AccountDeliverToService service = (AccountDeliverToService)SpringContextUtils.getBean((String)bean);
            service.deliverTo(sourceAccount, targetAccount);
        }
    }

    @Override
    public List<ElsSubAccount> getAccountListByElsSubAccountWithoutUser(List<String> elsSubAccountList) {
        return ((ElsSubAccountMapper)this.baseMapper).selectWithoutElsAccountByElsSubAccount(elsSubAccountList);
    }
}

