/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.thirdParty.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.thirdParty.dto.DApiMessage;
import com.els.modules.thirdParty.dto.EpecResult;
import com.els.modules.thirdParty.dto.EpecToken;
import com.els.modules.thirdParty.util.HttpXmlClient;
import java.util.HashMap;
import java.util.List;

public class EpecApiUtil {
    public static EpecToken getToken(String url, String clientId, String clientSecret, String companyId, String userName, String password) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("grant_type", "password");
        params.put("companyid", companyId);
        params.put("username", userName);
        params.put("password", password);
        String result = HttpXmlClient.post(url, params);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        EpecToken epecToken = new EpecToken();
        boolean success = jsonObject.getBoolean("success");
        if (success) {
            epecToken.setSuccess(jsonObject.getBoolean("success"));
            epecToken.setAccessToken(jsonObject.getJSONObject("data").getString("access_token"));
            epecToken.setRefreshToekn(jsonObject.getJSONObject("data").getString("refresh_token"));
            epecToken.setExpiresIn(jsonObject.getJSONObject("data").getInteger("expires_in"));
            epecToken.setTokenType(jsonObject.getJSONObject("data").getString("token_type"));
        } else {
            epecToken.setSuccess(jsonObject.getBoolean("success"));
            epecToken.setCode(jsonObject.getString("code"));
            epecToken.setMessage(jsonObject.getString("msg"));
        }
        return epecToken;
    }

    public static EpecToken refreshToken(String url, String clientId, String clientSecret, String refreshToken) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("client_id", clientId);
        formData.put("client_secret", clientSecret);
        formData.put("grant_type", "refresh_token");
        formData.put("refresh_token", refreshToken);
        String result = HttpXmlClient.post(url, formData);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        EpecToken epecToken = new EpecToken();
        boolean success = jsonObject.getBoolean("success");
        if (success) {
            epecToken.setSuccess(jsonObject.getBoolean("success"));
            epecToken.setAccessToken(jsonObject.getJSONObject("data").getString("access_token"));
            epecToken.setRefreshToekn(jsonObject.getJSONObject("data").getString("refresh_token"));
            epecToken.setExpiresIn(jsonObject.getJSONObject("data").getInteger("expires_in"));
            epecToken.setTokenType(jsonObject.getJSONObject("data").getString("token_type"));
        } else {
            epecToken.setSuccess(jsonObject.getBoolean("success"));
            epecToken.setCode(jsonObject.getString("code"));
            epecToken.setMessage(jsonObject.getString("msg"));
        }
        return epecToken;
    }

    public static EpecResult invokeAPI(String url, String accessToken, String data) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", String.format("bearer %s", accessToken));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("data", data);
        String result = HttpXmlClient.post(url, params, headers);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        EpecResult epecResult = new EpecResult();
        boolean success = jsonObject.getBoolean("success");
        String requestId = jsonObject.getString("requestid");
        if (success) {
            epecResult.setSuccess(jsonObject.getBoolean("success"));
            epecResult.setData(jsonObject.getString("data"));
            epecResult.setRequestId(requestId);
        } else {
            epecResult.setSuccess(jsonObject.getBoolean("success"));
            epecResult.setCode(jsonObject.getString("code"));
            epecResult.setMessage(jsonObject.getString("msg"));
            epecResult.setRequestId(requestId);
        }
        return epecResult;
    }

    public static List<DApiMessage> getMessages(String url, String accessToken, String num) {
        EpecResult result = EpecApiUtil.invokeAPI(url, accessToken, num);
        List list = null;
        if (result.isSuccess()) {
            list = JSONArray.parseArray((String)result.getData(), DApiMessage.class);
        }
        return list;
    }

    public static EpecResult removeMessages(String url, String accessToken, List<Long> messageIds) {
        EpecResult result = EpecApiUtil.invokeAPI(url, accessToken, JSONArray.toJSONString(messageIds));
        return result;
    }
}

