/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.I18nUtil;
import com.els.modules.esign.enumerate.RequestType;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.collections.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCfgHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCfgHelper.class);
    private static final int MAX_TIMEOUT = 3000;
    private static final int MAX_TOTAL = 10;
    private static final int ROUTE_MAX_TOTAL = 3;
    private static final int MAX_RETRY = 5;
    private static PoolingHttpClientConnectionManager connMgr;
    private static HttpRequestRetryHandler retryHandler;

    private HttpCfgHelper() {
    }

    public static JSONObject sendHttp(RequestType reqType, String url, Map<String, String> headers, Object param) throws Exception {
        HttpRequestBase reqBase = reqType.getHttpType(url);
        LOGGER.info("\n--->>\u5f00\u59cb\u5411\u5730\u5740[{}]\u53d1\u8d77 [{}] \u8bf7\u6c42", (Object)url, (Object)reqBase.getMethod());
        LOGGER.info("--->>\u8bf7\u6c42\u5934\u4e3a{}", (Object)JSON.toJSONString(headers));
        long startTime = System.currentTimeMillis();
        CloseableHttpClient httpClient = HttpCfgHelper.getHttpClient();
        HttpCfgHelper.config(reqBase);
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                reqBase.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (param != null && param instanceof String) {
            String paramStr = String.valueOf(param);
            LOGGER.info("--->>\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)paramStr);
            ((HttpEntityEnclosingRequest)reqBase).setEntity((HttpEntity)new StringEntity(String.valueOf(paramStr), ContentType.create((String)"application/json", (String)"UTF-8")));
        } else if (param != null && param instanceof byte[]) {
            LOGGER.info("--->>\u8bf7\u6c42\u53c2\u6570\u4e3a\u6587\u4ef6\u6d41");
            byte[] paramBytes = (byte[])param;
            ((HttpEntityEnclosingRequest)reqBase).setEntity((HttpEntity)new ByteArrayEntity(paramBytes));
        }
        CloseableHttpResponse res = null;
        String resCtx = null;
        try {
            res = httpClient.execute((HttpUriRequest)reqBase);
            LOGGER.info("--->>\u6267\u884c\u8bf7\u6c42\u5b8c\u6bd5\uff0c\u54cd\u5e94\u72b6\u6001\uff1a{}", (Object)res.getStatusLine());
            if (res.getStatusLine().getStatusCode() != 200) {
                throw new Exception(I18nUtil.translate((String)"i18n_alert_WWWWCQIHWWWWW_db12d671", (String)("--->>HTTP\u8bbf\u95ee\u5f02\u5e38:" + res.getStatusLine()), (String[])new String[]{res.getStatusLine() + ""}));
            }
            HttpEntity httpEntity = res.getEntity();
            if (httpEntity != null) {
                resCtx = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
                LOGGER.info("--->>\u83b7\u53d6\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)resCtx);
            }
        }
        catch (Exception e) {
            throw new Exception(I18nUtil.translate((String)"i18n_alert_VVKm_41419a7f", (String)"\u8bf7\u6c42\u5931\u8d25"));
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (IOException iOException) {}
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("--->>\u8bf7\u6c42\u6267\u884c\u5b8c\u6bd5\uff0c\u8017\u8d39\u65f6\u957f\uff1a{} \u79d2", (Object)((endTime - startTime) / 1000L));
        return JSONObject.parseObject((String)resCtx);
    }

    private static void config(HttpRequestBase httpReqBase) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(3000).setConnectTimeout(3000).setSocketTimeout(3000).build();
        httpReqBase.setConfig(requestConfig);
    }

    private static void cfgPoolMgr() {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        connMgr = new PoolingHttpClientConnectionManager(registry);
        connMgr.setMaxTotal(10);
        connMgr.setDefaultMaxPerRoute(3);
    }

    private static void cfgRetryHandler() {
        retryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException e, int excCount, HttpContext ctx) {
                if (excCount > 5) {
                    return false;
                }
                if (e instanceof NoHttpResponseException) {
                    return true;
                }
                if (e instanceof SSLHandshakeException) {
                    return false;
                }
                if (e instanceof InterruptedIOException) {
                    return false;
                }
                if (e instanceof UnknownHostException) {
                    return false;
                }
                if (e instanceof ConnectTimeoutException) {
                    return false;
                }
                if (e instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientCtx = HttpClientContext.adapt((HttpContext)ctx);
                HttpRequest req = clientCtx.getRequest();
                return !(req instanceof HttpEntityEnclosingRequest);
            }
        };
    }

    private static CloseableHttpClient getHttpClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).setRetryHandler(retryHandler).build();
    }

    static {
        HttpCfgHelper.cfgPoolMgr();
        HttpCfgHelper.cfgRetryHandler();
    }
}

