/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tiger.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tiger.entity.User;
import com.els.modules.tiger.service.UserApiRPCDemoService;
import com.els.modules.tiger.service.UserDemoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tiger/user"})
@Api(tags={"\u81ea\u6d4buser\u63a5\u53e3"})
public class UseDemorController
extends BaseController<User, UserDemoService> {
    private static final Logger log = LoggerFactory.getLogger(UseDemorController.class);
    @Autowired
    private UserDemoService userDemoService;
    @Resource
    private UserApiRPCDemoService apiRPCDemoService;

    @ApiOperation(value="RPC\u6a21\u5f0f\u67e5\u8be2\u6240\u6709\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"rpc/select"}, method={RequestMethod.GET})
    public Result<?> getUserListRPC() {
        List list = (List)this.apiRPCDemoService.getList();
        return Result.ok((Object)list);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public Result<?> getUserList(User user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)user), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"name", (Object)user.getName());
        IPage UserPageList = this.userDemoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)UserPageList);
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public Result<String> saveUser(@RequestBody User user) {
        Result result = new Result();
        try {
            if ("admin".equals(user.getName())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u540d\u79f0\u4e0d\u53ef\u7528\uff01"));
            }
            user.setCreateTime(new Date());
            user.setCreateBy(TenantContext.getTenant());
            user.setUpdateTime(new Date());
            user.setUpdateBy(TenantContext.getTenant());
            user.setDeleted(0);
            boolean save = this.userDemoService.save((Object)user);
            System.out.println(save);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Result<String> updateUser(@RequestBody User user) {
        Result result = new Result();
        try {
            if ("admin".equals(user.getName())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u540d\u79f0\u4e0d\u53ef\u7528\uff01"));
            }
            user.setUpdateTime(new Date());
            user.setUpdateBy(TenantContext.getTenant());
            boolean save = this.userDemoService.updateById((Object)user);
            System.out.println(save);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public Result<String> deleteUser(@RequestParam(name="id") String id) {
        Result result = new Result();
        User user = new User();
        try {
            if ("1".equals(id)) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u7528\u6237\u4e0d\u53ef\u5220\u9664\uff01"));
            }
            user.setUpdateTime(new Date());
            user.setUpdateBy(TenantContext.getTenant());
            user.setDeleted(1);
            user.setId(id);
            boolean save = this.userDemoService.updateById((Object)user);
            System.out.println(save);
            result.success("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }
}

