/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.qip.service.impl;

import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.qip.dto.QipAccountDTO;
import com.els.modules.qip.entity.QipAccountInfo;
import com.els.modules.qip.mapper.QipAccountInfoMapper;
import com.els.modules.qip.service.CallQipService;
import com.els.modules.qip.service.QipAccountInfoService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QipAccountInfoServiceImpl
extends BaseServiceImpl<QipAccountInfoMapper, QipAccountInfo>
implements QipAccountInfoService {
    @Autowired
    private CallQipService callQipService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveQipAccountInfo() {
        LoginUser loginUser = SysUtil.getLoginUser();
        QipAccountInfo qipAccountInfo = new QipAccountInfo();
        qipAccountInfo.setElsAccount(loginUser.getElsAccount());
        qipAccountInfo.setEnterpriseName(loginUser.getEnterpriseName());
        qipAccountInfo.setSubAccount(loginUser.getSubAccount());
        qipAccountInfo.setRealName(loginUser.getRealname());
        qipAccountInfo.setEmail(loginUser.getEmail());
        qipAccountInfo.setMobile(loginUser.getPhone());
        QipAccountDTO accountDTO = (QipAccountDTO)SysUtil.copyProperties((Object)((Object)qipAccountInfo), QipAccountDTO.class);
        this.callQipService.createAccount(accountDTO);
        ((QipAccountInfoMapper)this.baseMapper).insert((Object)qipAccountInfo);
    }

    @Override
    public void updateQipAccountInfo(QipAccountInfo qipAccountInfo) {
        ((QipAccountInfoMapper)this.baseMapper).updateById((Object)qipAccountInfo);
    }

    @Override
    public void delQipAccountInfo(String id) {
        ((QipAccountInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchQipAccountInfo(List<String> idList) {
        ((QipAccountInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

