/*
 * Decompiled with CFR 0.152.
 */
package com.els.aspect;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.ThirdPartyAccess;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ElsAppreciationServiceUtil;
import com.els.common.util.SysUtil;
import com.els.modules.appreciation.entity.ElsAppreciationService;
import com.els.modules.appreciation.service.ElsAppreciationServiceService;
import com.els.modules.qip.service.QipAccountInfoService;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ThirdPartyServiceAspect {
    @Resource
    private QipAccountInfoService qipAccountInfoService;
    @Autowired
    private ElsAppreciationServiceService elsAppreciationServiceService;

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.ThirdPartyAccess)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        LoginUser user = SysUtil.getLoginUser();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        ThirdPartyAccess permissionDataView = method.getAnnotation(ThirdPartyAccess.class);
        String permissionType = permissionDataView.permissionType();
        if ("qip".equals(permissionType)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"els_account", (Object)user.getElsAccount());
            wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
            int count = this.qipAccountInfoService.count((Wrapper)wrapper);
            if (count < 1) {
                this.qipAccountInfoService.saveQipAccountInfo();
            }
        }
        if ("oldService".equals(permissionType)) {
            String value = permissionDataView.value();
            ElsAppreciationService service = this.elsAppreciationServiceService.getByElsAccountAndServiceType(user.getElsAccount(), value);
            if (service == null) {
                throw new ELSBootException("\u672a\u5f00\u901a\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1");
            }
            ElsAppreciationServiceUtil.setData(service);
        }
        return point.proceed();
    }
}

