/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.qip.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.modules.qip.dto.QipAlreadyBoughtServiceDTO;
import com.els.modules.qip.dto.QipBalanceDTO;
import com.els.modules.qip.dto.QipConsumptionResultDTO;
import com.els.modules.qip.dto.QipRechargeRecordDTO;
import com.els.modules.qip.dto.QipRechargeResultDTO;
import com.els.modules.qip.dto.SellPriceDTO;
import com.els.modules.qip.entity.QipAccountInfo;
import com.els.modules.qip.service.CallQipService;
import com.els.modules.qip.service.QipAccountInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"QIP\u5f00\u901a\u8d26\u53f7\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/qip/qipAccountInfo"})
public class QipAccountInfoController
extends BaseController<QipAccountInfo, QipAccountInfoService> {
    @Autowired
    private QipAccountInfoService qipAccountInfoService;
    @Autowired
    private CallQipService callQipService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(QipAccountInfo qipAccountInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)qipAccountInfo), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.qipAccountInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="QIP\u5f00\u901a\u8d26\u53f7\u4fe1\u606f-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @GetMapping(value={"/add"})
    public void add() {
        this.qipAccountInfoService.saveQipAccountInfo();
    }

    @AutoLog(value="QIP\u5f00\u901a\u8d26\u53f7\u4fe1\u606f-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody QipAccountInfo qipAccountInfo) {
        this.qipAccountInfoService.updateQipAccountInfo(qipAccountInfo);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="QIP\u5f00\u901a\u8d26\u53f7\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.qipAccountInfoService.delQipAccountInfo(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="QIP\u5f00\u901a\u8d26\u53f7\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.qipAccountInfoService.delBatchQipAccountInfo(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        QipAccountInfo qipAccountInfo = (QipAccountInfo)((Object)this.qipAccountInfoService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)qipAccountInfo));
    }

    @ApiOperation(value="\u67e5\u8be2\u8d26\u6237\u4f59\u989d", notes="\u67e5\u8be2\u8d26\u6237\u4f59\u989d")
    @GetMapping(value={"/queryBalance"})
    public Result<?> queryBalance() {
        QipBalanceDTO balanceDTO = this.callQipService.queryBalance(this.getTenantId());
        balanceDTO.setEnterpriseName(SysUtil.getLoginUser().getEnterpriseName());
        return Result.ok((Object)balanceDTO);
    }

    @ApiOperation(value="\u5145\u503c\u8bb0\u5f55", notes="\u5145\u503c\u8bb0\u5f55")
    @GetMapping(value={"/queryRechargeRecord"})
    public QipRechargeResultDTO queryRechargeRecord(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="startTime", required=false) String startTime, @RequestParam(name="endTime", required=false) String endTime) {
        QipRechargeRecordDTO rechargeRecordDTO = new QipRechargeRecordDTO(pageNo, pageSize, this.getTenantId(), startTime, endTime);
        return this.callQipService.queryRechargeRecord(rechargeRecordDTO);
    }

    @ApiOperation(value="\u8ba2\u5355\uff08\u4ea7\u54c1\uff09\u6d88\u8d39\u8bb0\u5f55\u67e5\u8be2", notes="\u8ba2\u5355\uff08\u4ea7\u54c1\uff09\u6d88\u8d39\u8bb0\u5f55\u67e5\u8be2")
    @GetMapping(value={"/queryConsumptionRecord"})
    public QipConsumptionResultDTO queryConsumptionRecord(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        return this.callQipService.queryConsumptionRecord(pageNo, pageSize);
    }

    @ApiOperation(value="\u5df2\u8d2d\u670d\u52a1\u67e5\u8be2", notes="\u5df2\u8d2d\u670d\u52a1\u67e5\u8be2")
    @GetMapping(value={"/queryAlreadyBoughtService"})
    public QipAlreadyBoughtServiceDTO queryAlreadyBoughtService() {
        return this.callQipService.queryAlreadyBoughtService(this.getTenantId(), null);
    }

    @ApiOperation(value="\u6d88\u8d39\u670d\u52a1\u6d41\u6c34", notes="\u6d88\u8d39\u670d\u52a1\u6d41\u6c34")
    @GetMapping(value={"/queryWaterConsumption"})
    public QipConsumptionResultDTO queryWaterConsumption(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="entitlCode") String entitlCode, @RequestParam(name="month") String month) {
        return this.callQipService.queryWaterConsumption(pageNo, pageSize, entitlCode, month);
    }

    @ApiOperation(value="\u9500\u552e\u4ef7\u683c\u67e5\u8be2", notes="\u9500\u552e\u4ef7\u683c\u67e5\u8be2")
    @GetMapping(value={"/querySellPrice"})
    public SellPriceDTO querySellPrice(@RequestParam(name="productCode") String productCode) {
        return this.callQipService.querySellPrice(productCode);
    }
}

