/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.listener;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.base.api.dto.MqMessagePersistenceDTO;
import com.els.modules.system.listener.schedule.PermissionScheduledBuilder;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.service.PermissionService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component(value="rebuildSaleMenuListener")
@EnableScheduling
public class RebuildSaleMenuListener
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RebuildSaleMenuListener.class);
    @Resource
    private PermissionService permissionServiceImpl;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource(name="permissionScheduledBuilder")
    private PermissionScheduledBuilder permissionScheduledBuilder;

    @StreamListener(value="inputReBuildSaleMenu")
    public void receive(String msgBody) {
    }

    public void dealChangePermissionScheduled() {
        List<MqMessagePersistenceDTO> dtos = this.invokeBaseRpcService.listToJob("permission", "changePermission");
        for (MqMessagePersistenceDTO dto : dtos) {
            JSONObject body = JSONObject.parseObject((String)dto.getMessageData());
            try {
                String elsAccount = body.getString("elsAccount");
                List toElsAccountList = body.getJSONArray("toElsAccountList").toJavaList(String.class);
                List addList = body.getJSONArray("addList").toJavaList(String.class);
                List deleteList = body.getJSONArray("deleteList").toJavaList(String.class);
                this.permissionServiceImpl.buildSaleMenu(toElsAccountList, elsAccount, addList, deleteList);
                dto.setSuccessFlag("1");
                dto.setUpdateTime(new Date());
            }
            catch (Exception e) {
                log.error(":::\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355\u5f02\u5e38:{},error:{}", (Object)e.getMessage());
                Integer errorTimes = (Integer)ObjectUtil.defaultIfNull((Object)dto.getErrorTimes(), (Object)0);
                if (errorTimes >= 2) {
                    dto.setSuccessFlag("0");
                } else {
                    dto.setErrorTimes(Integer.valueOf(errorTimes + 1));
                }
                dto.setUpdateTime(new Date());
                dto.setErrorMessage(e.getMessage());
            }
        }
        this.invokeBaseRpcService.updateList(dtos);
    }

    @Scheduled(cron="0 0 2 ? * *")
    public void deleteChangePermissionScheduled() {
        this.invokeBaseRpcService.deleteLog(null);
    }

    public void afterPropertiesSet() throws Exception {
        this.permissionScheduledBuilder.buildScheduled(1200);
    }
}

