/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.listener.schedule;

import cn.hutool.core.date.DateUtil;
import com.els.modules.system.listener.schedule.DynamicCronTaskRegistrar;
import com.els.modules.system.listener.schedule.model.DynamicSchedulingRunnable;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionScheduledBuilder {
    private static final Logger log = LoggerFactory.getLogger(PermissionScheduledBuilder.class);
    @Resource(name="dynamicCronTaskRegistrar")
    private DynamicCronTaskRegistrar dynamicCronTaskRegistrar;
    private final String serviceImpl;
    private final String method;

    public PermissionScheduledBuilder(String serviceImpl, String method) {
        this.serviceImpl = serviceImpl;
        this.method = method;
    }

    public DynamicSchedulingRunnable buildScheduled(Integer timespanSecond, Integer timespanSecond2, Integer delayedSecond) {
        DynamicSchedulingRunnable task = new DynamicSchedulingRunnable(this.serviceImpl, this.method, timespanSecond);
        this.removeDynamicSchedulingRunnable(timespanSecond);
        this.removeDynamicSchedulingRunnable(timespanSecond2);
        this.removeDynamicSchedulingRunnable(delayedSecond);
        this.dynamicCronTaskRegistrar.addCronTaskDate(task, (Date)DateUtil.offsetSecond((Date)new Date(), (int)timespanSecond));
        DynamicSchedulingRunnable task2 = new DynamicSchedulingRunnable(this.serviceImpl, this.method, timespanSecond2);
        this.dynamicCronTaskRegistrar.addCronTaskDate(task2, (Date)DateUtil.offsetSecond((Date)new Date(), (int)timespanSecond2));
        DynamicSchedulingRunnable task3 = new DynamicSchedulingRunnable(this.serviceImpl, this.method, delayedSecond);
        this.dynamicCronTaskRegistrar.addCronTaskDate(task3, (Date)DateUtil.offsetSecond((Date)new Date(), (int)delayedSecond));
        return task;
    }

    public DynamicSchedulingRunnable buildScheduled(Integer timespanSecond) {
        DynamicSchedulingRunnable task = new DynamicSchedulingRunnable(this.serviceImpl, this.method, timespanSecond);
        this.removeDynamicSchedulingRunnable(timespanSecond);
        this.dynamicCronTaskRegistrar.addCronTaskDate(task, (Date)DateUtil.offsetSecond((Date)new Date(), (int)timespanSecond));
        return task;
    }

    public void removeDynamicSchedulingRunnable(Integer delayedSecond) {
        DynamicSchedulingRunnable task = new DynamicSchedulingRunnable(this.serviceImpl, this.method, delayedSecond);
        this.dynamicCronTaskRegistrar.removeCronTask(task);
    }
}

