/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.listener.schedule.model;

import cn.hutool.core.util.ObjectUtil;
import com.els.common.util.SpringContextUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class DynamicSchedulingRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DynamicSchedulingRunnable.class);
    private final String beanName;
    private final String methodName;
    private final Integer second;

    public DynamicSchedulingRunnable(String beanName, String methodName, Integer second) {
        this.beanName = beanName;
        this.methodName = methodName;
        this.second = second;
    }

    @Override
    public void run() {
        log.info("### \u6267\u884c\u52a8\u6001\u5b9a\u65f6\u4efb\u52a1 - bean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}", (Object)this.beanName, (Object)this.methodName);
        long startTime = System.currentTimeMillis();
        try {
            Object target = SpringContextUtils.getBean((String)this.beanName);
            Method method = target.getClass().getDeclaredMethod(this.methodName, new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke(target, new Object[0]);
        }
        catch (Exception ex) {
            log.error(String.format("### \u5b9a\u65f6\u4efb\u52a1\u5931\u8d25 - \u65b9\u6cd5:%s\uff0c\u51fd\u6570 : %s", this.beanName, this.methodName), (Throwable)ex);
        }
        long times = System.currentTimeMillis() - startTime;
        log.info("### \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6210 - \u5b9e\u73b0\u7c7b\uff1a{}\uff0c\u65b9\u6cd5:{}\uff0c\u65f6\u95f4:{} \u79d2", new Object[]{this.beanName, this.methodName, times});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicSchedulingRunnable that = (DynamicSchedulingRunnable)o;
        return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && ObjectUtil.equals((Object)this.second, (Object)that.second);
    }

    public int hashCode() {
        return Objects.hash(this.beanName, this.methodName, this.second);
    }
}

