/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterprise.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RestUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.AESUtil;
import com.els.common.util.encryption.RsaEncryptUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.rpc.service.EnterpriseInvokeSupplierRpcService;
import com.els.modules.enterprise.service.ElsEnterpriseInfoService;
import com.els.modules.enterprise.vo.EnterpriseInfoVo;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.UserRoleService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/enterprise/elsEnterpriseInfo"})
public class ElsEnterpriseInfoController
extends BaseController<ElsEnterpriseInfo, ElsEnterpriseInfoService> {
    private static final Logger log = LoggerFactory.getLogger(ElsEnterpriseInfoController.class);
    @Autowired
    private ElsEnterpriseInfoService elsEnterpriseInfoService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private ElsTenantService elsTenantService;
    @Value(value="${b2b.source}")
    private String SOURCE;
    @Value(value="${b2b.url}")
    private String URL;
    @Value(value="${b2b.public-key}")
    private String PUBLIC_KEY;
    @Value(value="${Mining.source}")
    private String MINING_SOURCE;
    @Value(value="${Mining.siteType}")
    private String MINING_SITE_TYPE;
    @Value(value="${Mining.url}")
    private String MINING_URL;
    @Value(value="${Mining.public-key}")
    private String MINING_PUBLIC_KEY;
    @Value(value="${financialCloud.url}")
    private String financialCloudUrl;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private EnterpriseInvokeSupplierRpcService enterpriseInvokeSupplierRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result<?> queryPageList(ElsEnterpriseInfo elsEnterpriseInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsEnterpriseInfo), (Map)req.getParameterMap());
        if (!TenantContext.getTenant().equals("100000")) {
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsEnterpriseInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:save"})
    public Result<?> add(@RequestBody ElsEnterpriseInfo elsEnterpriseInfo) {
        this.elsEnterpriseInfoService.saveElsEnterpriseInfo(elsEnterpriseInfo);
        return Result.ok((Object)((Object)elsEnterpriseInfo));
    }

    @SrmValidated
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:save"})
    public Result<?> edit(@RequestBody ElsEnterpriseInfo elsEnterpriseInfo) {
        this.elsEnterpriseInfoService.updateElsEnterpriseInfo(elsEnterpriseInfo);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:save"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsEnterpriseInfoService.delElsEnterpriseInfo(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:save"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsEnterpriseInfoService.delBatchElsEnterpriseInfo(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsEnterpriseInfo elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)this.elsEnterpriseInfoService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)elsEnterpriseInfo));
    }

    @ApiOperation(value="\u901a\u8fc7\u5f53\u524d\u8d26\u53f7\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f", notes="\u901a\u8fc7\u5f53\u524d\u8d26\u53f7\u83b7\u53d6\u5f53\u524d\u4f01\u4e1a\u4fe1\u606f")
    @GetMapping(value={"/queryCurrentEnterprise"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result<?> queryCurrentEnterprise() {
        String currentAccount = TenantContext.getTenant();
        ElsEnterpriseInfo elsEnterpriseInfo = this.elsEnterpriseInfoService.getByElsAccount(currentAccount);
        if (elsEnterpriseInfo == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n__mhGNWVKHRvjW_638fd67c", (String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
        }
        return Result.ok((Object)((Object)elsEnterpriseInfo));
    }

    @ApiOperation(value="\u83b7\u53d6B2B\u5355\u70b9\u767b\u5165\u94fe\u63a5", notes="\u83b7\u53d6B2B\u5355\u70b9\u767b\u5165\u94fe\u63a5")
    @GetMapping(value={"/getLoginB2BUrl"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result<?> getLoginB2BUrl() {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (StringUtils.isBlank((CharSequence)loginUser.getPhone())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_APENLCEyoLLDWVWPTWmLGRWsHcLDW_107bddd3", (String)"\u5f53\u524d\u767b\u5165\u4eba\u7535\u8bdd\u53f7\u7801\u672a\u7ef4\u62a4\uff0c\u8bf7\u5148\u524d\u5f80\u3010\u4e2a\u4eba\u8bbe\u7f6e\u3011\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002"));
        }
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        JSONObject object = new JSONObject();
        object.put("elsAccount", (Object)elsAccount);
        object.put("subAccount", (Object)subAccount);
        object.put("mobile", (Object)loginUser.getPhone());
        ElsEnterpriseInfo elsEnterpriseInfo = this.elsEnterpriseInfoService.getByElsAccount(loginUser.getElsAccount());
        Assert.notNull((Object)((Object)elsEnterpriseInfo), (String)I18nUtil.translate((String)"i18n_alert_APBjAEVHWxqtk_90d06bd4", (String)"\u5f53\u524d\u6ca1\u6709\u4f01\u4e1a\u4fe1\u606f\uff0c\u4e0d\u53ef\u64cd\u4f5c"));
        object.put("companyName", (Object)elsEnterpriseInfo.getName());
        object.put("source", (Object)this.SOURCE);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        object.put("roleCode", (Object)("1".equals(adminFlag) ? "admin" : ""));
        String key = ConvertUtils.randomGen((int)32);
        try {
            String requestUrl = this.URL + URLEncoder.encode(AESUtil.encrypt((String)object.toString(), (String)key), "utf-8") + "&secret=" + URLEncoder.encode(RsaEncryptUtil.encrypt((String)key, (String)this.PUBLIC_KEY), "utf-8");
            return Result.ok((String)requestUrl);
        }
        catch (Exception e) {
            log.error("\u5355\u70b9\u767b\u5f55\u5931\u8d25", (Throwable)e);
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ENKm_371899de", (String)"\u767b\u5165\u5931\u8d25"));
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u91d1\u878d\u4e91\u5355\u70b9\u767b\u5165\u94fe\u63a5", notes="\u83b7\u53d6\u91d1\u878d\u4e91\u5355\u70b9\u767b\u5165\u94fe\u63a5")
    @GetMapping(value={"/getLoginFinancialCloud"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result getLoginFinancialCloud() {
        LoginUser loginUser = SysUtil.getLoginUser();
        ElsEnterpriseInfo elsEnterpriseInfo = this.elsEnterpriseInfoService.getByElsAccount(loginUser.getElsAccount());
        if (elsEnterpriseInfo == null || StringUtils.isEmpty((CharSequence)elsEnterpriseInfo.getCreditCode())) {
            log.info("getLoginFinancialCloud data empty, {}", (Object)elsEnterpriseInfo);
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ENKm_371899de", (String)"\u767b\u5165\u5931\u8d25"));
        }
        String creditCode = elsEnterpriseInfo.getCreditCode();
        JSONObject param = new JSONObject();
        param.put("creditCode", (Object)creditCode);
        try {
            log.info("request for financialCloud url, {} , {} ", (Object)this.financialCloudUrl, (Object)JSON.toJSONString((Object)param));
            JSONObject jsonObject = RestUtil.post((String)this.financialCloudUrl, (JSONObject)param);
            log.info("response from financialCloud, {} ", (Object)JSON.toJSONString((Object)jsonObject));
            int code = Integer.parseInt(jsonObject.get((Object)"code") + "");
            String data = String.valueOf(jsonObject.get((Object)"data"));
            String msg = String.valueOf(jsonObject.get((Object)"msg"));
            if (0 == code) {
                return Result.ok((String)data);
            }
            return Result.error((String)msg);
        }
        catch (Exception e) {
            log.error("getLoginFinancialCloud error : {}", (Object)e.getMessage());
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ENKm_371899de", (String)"\u767b\u5165\u5931\u8d25"));
        }
    }

    @ApiOperation(value="\u83b7\u5185\u91c7\u5546\u57ce\u767b\u5165\u94fe\u63a5", notes="\u83b7\u5185\u91c7\u5546\u57ce\u767b\u5165\u94fe\u63a5")
    @GetMapping(value={"/getLoginMiningUrl"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result<?> getLoginMiningUrl() {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (StringUtils.isBlank((CharSequence)loginUser.getPhone())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_APENLCEyoLLDWVWPTWmLGRWsHcLDW_107bddd3", (String)"\u5f53\u524d\u767b\u5165\u4eba\u7535\u8bdd\u53f7\u7801\u672a\u7ef4\u62a4\uff0c\u8bf7\u5148\u524d\u5f80\u3010\u4e2a\u4eba\u8bbe\u7f6e\u3011\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002"));
        }
        JSONObject object = new JSONObject();
        object.put("elsAccount", (Object)loginUser.getElsAccount());
        object.put("userName", (Object)loginUser.getSubAccount());
        object.put("phone", (Object)loginUser.getPhone());
        ElsEnterpriseInfo elsEnterpriseInfo = this.elsEnterpriseInfoService.getByElsAccount(loginUser.getElsAccount());
        if (elsEnterpriseInfo != null) {
            object.put("companyName", (Object)elsEnterpriseInfo.getName());
        }
        object.put("source", (Object)this.MINING_SOURCE);
        object.put("siteType", (Object)this.MINING_SITE_TYPE);
        object.put("languageType", (Object)1);
        object.put("createTime", (Object)System.currentTimeMillis());
        String key = ConvertUtils.randomGen((int)32);
        try {
            System.out.println("\u5165\u53c2\uff1a" + object);
            String requestUrl = this.MINING_URL + URLEncoder.encode(AESUtil.encrypt((String)object.toString(), (String)key), "utf-8") + "&secret=" + URLEncoder.encode(RsaEncryptUtil.encrypt((String)key, (String)this.MINING_PUBLIC_KEY), "utf-8");
            return Result.ok((String)requestUrl);
        }
        catch (Exception exception) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ENKm_371899de", (String)"\u767b\u5165\u5931\u8d25"));
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u4f9b\u5e94\u5546\u5bf9\u5e94\u7684\u91c7\u8d2d", notes="\u83b7\u53d6\u4f9b\u5e94\u5546\u5bf9\u5e94\u7684\u91c7\u8d2d")
    @GetMapping(value={"/getPurchaseAccount"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result<?> getPurchaseAccount(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="frozenFunction", required=false) String frozenFunction) {
        List<String> elsAccounts = this.enterpriseInvokeSupplierRpcService.list(toElsAccount, frozenFunction);
        if (elsAccounts == null || elsAccounts.isEmpty() || elsAccounts.size() < 1) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_YxuIdjnRWF_ceeb2a8c", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u6570\u636e"));
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"els_account", elsAccounts);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsEnterpriseInfoService.page((IPage)page, (Wrapper)wrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4f01\u4e1a\u591a\u8bed\u8a00\u67e5\u8be2", busModule="\u4f01\u4e1a\u591a\u8bed\u8a00")
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u91c7\u8d2d", notes="\u83b7\u53d6\u6240\u6709\u7684\u91c7\u8d2d")
    @GetMapping(value={"/getPurchaseEnterprise"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result<?> getPurchaseEnterprise(ElsTenant elsTenant, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        List<String> elsAccounts = this.enterpriseInvokeSupplierRpcService.getSupplierMasterDataBigB(null);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTenant), (Map)req.getParameterMap());
        queryWrapper.in((Object)"els_account", elsAccounts);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTenantService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f-\u66f4\u65b0\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @ApiOperation(value="\u66f4\u65b0\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f", notes="\u66f4\u65b0\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @PostMapping(value={"/editEnterpriseInfo"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:save"})
    @SrmValidated
    public Result<?> editEnterpriseInfo(@RequestBody EnterpriseInfoVo enterpriseInfoVo) {
        this.elsEnterpriseInfoService.update(enterpriseInfoVo);
        return Result.ok((Object)((Object)enterpriseInfoVo));
    }

    @ApiOperation(value="\u4f01\u4e1a\u67e5\u8be2", notes="\u4f01\u4e1a\u67e5\u8be2")
    @GetMapping(value={"/queryAccessSupplier"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result<?> queryAccessSupplier(EnterpriseInfoVo enterpriseInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        ElsEnterpriseInfo enterprise = new ElsEnterpriseInfo();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfo), (Object)((Object)enterprise));
        QueryWrapper wrapper = QueryGenerator.initQueryWrapper((Object)((Object)enterprise), (Map)req.getParameterMap());
        Map<List<String>, Map<String, String>> map = this.enterpriseInvokeSupplierRpcService.queryAccessSupplier(enterpriseInfo.getFrozenFunctionValue(), enterpriseInfo.getCateCodeValue(), enterpriseInfo.getPurchaseOrgValue(), enterpriseInfo.getSupplierStatus());
        IPage iPage = null;
        if (map != null && map.keySet().size() > 0) {
            Iterator<List<String>> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                List<String> list;
                List<String> accounts = list = iterator.next();
                Map<String, String> supplier = map.get(list);
                wrapper.in((Object)"els_account", accounts);
                wrapper.select(new String[]{"els_account", "name", "industry"});
                Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
                iPage = this.elsEnterpriseInfoService.page((IPage)page, (Wrapper)wrapper);
                List infos = iPage.getRecords();
                for (ElsEnterpriseInfo elsEnterpriseInfo : infos) {
                    elsEnterpriseInfo.setFbk1(supplier.get(elsEnterpriseInfo.getElsAccount()));
                }
                if (map.keySet().size() != 1) continue;
                break;
            }
            return Result.ok(iPage);
        }
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f", notes="\u83b7\u53d6\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"/getElsEnterpriseInfo"})
    @RequiresPermissions(value={"enterpriseInfo#enterpriseInfo:list"})
    public Result<?> getElsEnterpriseInfo(@RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)toElsAccount);
        IPage pageList = this.elsEnterpriseInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u83b7\u53d6B2B\u5546\u673a\u5355\u70b9\u767b\u5165\u94fe\u63a5", notes="\u83b7\u53d6B2B\u5546\u673a\u5355\u70b9\u767b\u5165\u94fe\u63a5")
    @GetMapping(value={"/getLoginB2BBusinessUrl"})
    public Result<?> getLoginB2BBusinessUrl(@RequestParam(name="detailUrl") String detailUrl) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (StringUtils.isBlank((CharSequence)loginUser.getPhone())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_APENLCEyoLLDWVWPTWmLGRWsHcLDW_107bddd3", (String)"\u5f53\u524d\u767b\u5165\u4eba\u7535\u8bdd\u53f7\u7801\u672a\u7ef4\u62a4\uff0c\u8bf7\u5148\u524d\u5f80\u3010\u4e2a\u4eba\u8bbe\u7f6e\u3011\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002"));
        }
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        JSONObject object = new JSONObject();
        object.put("elsAccount", (Object)elsAccount);
        object.put("subAccount", (Object)subAccount);
        object.put("mobile", (Object)loginUser.getPhone());
        object.put("companyName", (Object)loginUser.getEnterpriseName());
        object.put("source", (Object)this.SOURCE);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        object.put("roleCode", (Object)("1".equals(adminFlag) ? "admin" : ""));
        JSONObject returnObject = this.invokeBaseRpcService.callIPaasInterface(object, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("get_b2b_login_token"));
        return Result.ok((Object)returnObject);
    }
}

