/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.rpc.service.JustAuthInvokeSupplierRpcService;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.justauth.mapper.JustAuthConfigMapper;
import com.els.modules.justauth.service.JustAuthConfigService;
import com.els.modules.justauth.vo.JustAuthConfigVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JustAuthConfigServiceImpl
extends BaseServiceImpl<JustAuthConfigMapper, JustAuthConfig>
implements JustAuthConfigService {
    private static final Logger log = LoggerFactory.getLogger(JustAuthConfigServiceImpl.class);
    @Autowired
    private JustAuthInvokeSupplierRpcService justAuthInvokeSupplierRpcService;

    @Override
    public IPage<JustAuthConfig> findPageList(Page<JustAuthConfig> page, QueryWrapper<JustAuthConfig> wrapper) {
        List<JustAuthConfig> list = ((JustAuthConfigMapper)this.baseMapper).findList(TenantContext.getTenant(), SysUtil.getPurchaseAccount(), wrapper);
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setIndex(i);
        }
        Map<String, Long> countMap = list.stream().collect(Collectors.groupingBy(BaseEntity::getId, Collectors.counting())).entrySet().stream().filter(c -> (Long)c.getValue() > 1L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List<JustAuthConfig> finalList = list;
        List removeList = countMap.entrySet().stream().flatMap(c -> finalList.stream().filter(x -> x.getId().equals(c.getKey()))).collect(Collectors.toList());
        list.removeAll(removeList);
        Map allIds = removeList.stream().collect(Collectors.groupingBy(x -> x.getCompanyConfigId() + "_" + x.getAuthType() + "_" + x.getDataType() + "_" + x.getCreateTime(), Collectors.mapping(BaseEntity::getId, Collectors.toList())));
        Map<String, List<JustAuthConfig>> groupIds = removeList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<JustAuthConfig>(Comparator.comparing(x -> x.getCompanyConfigId() + "_" + x.getAuthType() + "_" + x.getDataType() + "_" + x.getCreateTime()))), ArrayList::new)).stream().collect(Collectors.groupingBy(BaseEntity::getId));
        ArrayList last = new ArrayList();
        groupIds.forEach((k, v) -> {
            JustAuthConfig x = (JustAuthConfig)((Object)((Object)v.get(0)));
            String key = x.getCompanyConfigId() + "_" + x.getAuthType() + "_" + x.getDataType() + "_" + x.getCreateTime();
            List strings = (List)allIds.get(key);
            if (CollectionUtil.isNotEmpty((Collection)strings)) {
                for (int i = 0; i < strings.size(); ++i) {
                    JustAuthConfig config = (JustAuthConfig)((Object)((Object)v.get(i)));
                    config.setId((String)strings.get(i));
                    last.add(config);
                }
            }
        });
        list.addAll(last);
        list = list.stream().sorted(Comparator.comparingInt(JustAuthConfig::getIndex)).collect(Collectors.toList());
        int size = list.size();
        list = list.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
        page.setRecords(list);
        page.setTotal((long)size);
        return page;
    }

    @Override
    public void companyEdit(JustAuthConfig config) {
        config.setEnterpriseName(SysUtil.getLoginUser().getEnterpriseName());
        if (StrUtil.isBlank((CharSequence)config.getCompanyConfigId())) {
            config.setId(null);
            config.setCreateBy(this.getLoginSubAndName());
            config.setCreateTime(new Date());
            config.setUpdateBy(this.getLoginSubAndName());
            config.setUpdateTime(new Date());
            this.save((Object)config);
        } else {
            config.setId(config.getCompanyConfigId());
            this.updateById((Object)config);
        }
    }

    @Override
    public JustAuthConfig getOneConfig(String elsAccount, String authType) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(JustAuthConfig::getAuthType, (Object)authType)).ne(JustAuthConfig::getDataType, (Object)"templateConfig")).last(" limit 1");
        wrapper.orderByDesc(BaseEntity::getUpdateTime);
        return (JustAuthConfig)((Object)this.getOne((Wrapper)wrapper));
    }

    @Override
    public JustAuthConfig getOneConfig(String elsAccount, String authType, String dataType) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).likeRight(JustAuthConfig::getAuthType, (Object)authType)).eq(JustAuthConfig::getDataType, (Object)dataType)).last(" limit 1");
        wrapper.orderByDesc(BaseEntity::getUpdateTime);
        return (JustAuthConfig)((Object)this.getOne((Wrapper)wrapper));
    }

    @Override
    public void saveJustAuth(JustAuthConfig config) {
        if (this.getOneConfig(TenantContext.getTenant(), config.getAuthType()) != null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rAcIOMK_bd2ff142", (String)"\u8be5\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        config.setEnterpriseName(SysUtil.getLoginUser().getEnterpriseName());
        this.save((Object)config);
    }

    @Override
    public void updateJustAuth(JustAuthConfig config) {
        config.setAuthType(null);
        this.updateById((Object)config);
    }

    @Override
    public void createAuth(JustAuthConfig wechatMp, JSONObject jsonObject) {
        JSONObject authCorpInfo = jsonObject.getJSONObject("auth_corp_info");
        String clientId = authCorpInfo.getString("corpid");
        String authcorpName = authCorpInfo.getString("corp_name");
        String clientSecret = jsonObject.getString("permanent_code");
        JSONArray jsonArray = jsonObject.getJSONObject("auth_info").getJSONArray("agent");
        JSONObject jsonObject2 = jsonArray.getJSONObject(0);
        String agentId = jsonObject2.getString("agentid");
        log.info("#createAuth \u81ea\u52a8\u521b\u5efa\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u5f00\u53d1\u6388\u6743\u914d\u7f6e:{},clientId:{} \u5f00\u59cb", (Object)jsonObject.toJSONString(), (Object)clientId);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(JustAuthConfig::getAuthType, (Object)"WECHAT_ENTERPRISE_DEVELOP")).eq(JustAuthConfig::getClientId, (Object)clientId)).eq(JustAuthConfig::getSuiteId, (Object)wechatMp.getSuiteId())).eq(JustAuthConfig::getDataType, (Object)"dataConfig")).last(" limit 1");
        JustAuthConfig config = (JustAuthConfig)((Object)((JustAuthConfigMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == config) {
            config = new JustAuthConfig();
            config.setCustomAppToken(wechatMp.getCustomAppToken());
            config.setCustomAppKey(wechatMp.getCustomAppKey());
            config.setAuthType(wechatMp.getAuthType());
            config.setEnterpriseName(authcorpName);
            config.setDataType("dataConfig");
            config.setClientId(clientId);
            config.setElsAccount(clientId);
            config.setClientSecret(clientSecret);
            config.setUsertype(wechatMp.getUsertype());
        }
        config.setSuiteId(wechatMp.getSuiteId());
        config.setSuitesSecret(wechatMp.getSuitesSecret());
        config.setAgentId(agentId);
        this.saveOrUpdate((Object)config);
        log.info("#createAuth \u81ea\u52a8\u521b\u5efa\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u5f00\u53d1\u6388\u6743\u914d\u7f6e:{},clientId:{} \u5b8c\u6bd5", (Object)jsonObject.toJSONString(), (Object)clientId);
    }

    @Override
    public void bindAuth(String corpId, String suiteId, String busAccount) {
        LambdaQueryWrapper countWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)countWrapper.eq(JustAuthConfig::getClientId, (Object)corpId)).eq(JustAuthConfig::getSuiteId, (Object)suiteId)).eq(BaseEntity::getElsAccount, (Object)busAccount);
        Integer count = ((JustAuthConfigMapper)this.baseMapper).selectCount((Wrapper)countWrapper);
        if (count > 0) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(JustAuthConfig::getClientId, (Object)corpId)).eq(JustAuthConfig::getSuiteId, (Object)suiteId)).eq(BaseEntity::getElsAccount, (Object)corpId)).last("limit 1");
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        JustAuthConfig configs = (JustAuthConfig)((Object)((JustAuthConfigMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null != configs) {
            configs.setElsAccount(busAccount);
            this.updateById((Object)configs);
            log.info("bindAuth \u4f01\u4e1a\u5e94\u7528\u4ee3\u5f00\u53d1\u9996\u6b21\u7ed1\u5b9a\u79df\u6237,corpId:{},suiteId:{},busAccount:{}", new Object[]{corpId, suiteId, busAccount});
            return;
        }
        wrapper.clear();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(JustAuthConfig::getClientId, (Object)corpId)).eq(JustAuthConfig::getSuiteId, (Object)suiteId)).ne(BaseEntity::getElsAccount, (Object)busAccount)).last("limit 1");
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        configs = (JustAuthConfig)((Object)((JustAuthConfigMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null != configs) {
            configs.setElsAccount(busAccount);
            this.updateById((Object)configs);
            log.info("bindAuth \u4f01\u4e1a\u5e94\u7528\u4ee3\u5f00\u53d1\u53d8\u66f4\u7ed1\u5b9a\u79df\u6237,corpId:{},suiteId:{},busAccount:{},id:{}", new Object[]{corpId, suiteId, busAccount, configs.getId()});
        }
    }

    private void buildNewAuth() {
    }

    @Override
    public void resetAuth(JustAuthConfig wechatMp, JSONObject jsonObject) {
        JSONObject authCorpInfo = jsonObject.getJSONObject("auth_corp_info");
        String clientId = authCorpInfo.getString("corpid");
        String clientSecret = jsonObject.getString("permanent_code");
        log.info("#resetAuth \u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u5f00\u53d1\u91cd\u8bbe\u6388\u6743\u79d8\u94a5:{},clientId:{} \u5f00\u59cb", (Object)jsonObject.toJSONString(), (Object)clientId);
        LambdaQueryWrapper countWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)countWrapper.eq(JustAuthConfig::getAuthType, (Object)"WECHAT_ENTERPRISE_DEVELOP")).eq(JustAuthConfig::getClientId, (Object)clientId)).eq(JustAuthConfig::getSuiteId, (Object)wechatMp.getSuiteId())).eq(JustAuthConfig::getDataType, (Object)"dataConfig");
        JustAuthConfig config = (JustAuthConfig)((Object)((JustAuthConfigMapper)this.baseMapper).selectOne((Wrapper)countWrapper));
        if (null == config) {
            String authcorpName = authCorpInfo.getString("corp_name");
            JSONArray jsonArray = jsonObject.getJSONObject("auth_info").getJSONArray("agent");
            JSONObject jsonObject2 = jsonArray.getJSONObject(0);
            String agentId = jsonObject2.getString("agentid");
            config = new JustAuthConfig();
            config.setCustomAppToken(wechatMp.getCustomAppToken());
            config.setCustomAppKey(wechatMp.getCustomAppKey());
            config.setAuthType(wechatMp.getAuthType());
            config.setEnterpriseName(authcorpName);
            config.setDataType("dataConfig");
            config.setClientId(clientId);
            config.setElsAccount(clientId);
            config.setClientSecret(clientSecret);
            config.setUsertype(wechatMp.getUsertype());
            config.setSuiteId(wechatMp.getSuiteId());
            config.setSuitesSecret(wechatMp.getSuitesSecret());
            config.setAgentId(agentId);
            config.setClientSecret(clientSecret);
            ((JustAuthConfigMapper)this.baseMapper).insert((Object)config);
            return;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(JustAuthConfig::getClientSecret, (Object)clientSecret);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(JustAuthConfig::getAuthType, (Object)"WECHAT_ENTERPRISE_DEVELOP")).eq(JustAuthConfig::getClientId, (Object)clientId)).eq(JustAuthConfig::getSuiteId, (Object)wechatMp.getSuiteId())).eq(JustAuthConfig::getDataType, (Object)"dataConfig");
        ((JustAuthConfigMapper)this.baseMapper).update((Object)new JustAuthConfig(), (Wrapper)wrapper);
        log.info("#resetAuth \u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u5f00\u53d1\u6388\u6743\u91cd\u8bbe\u6388\u6743\u79d8\u94a5:{},clientId:{} \u5b8c\u6bd5", (Object)jsonObject.toJSONString(), (Object)clientId);
    }

    public void updateAuthSuitesSecret(JustAuthConfig wechatMp, JSONObject jsonObject, String busAccount) {
        log.info("#updateAuthSuitesSecret \u66f4\u65b0\u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801:{},busAccount:{} \u5f00\u59cb", (Object)jsonObject.toJSONString(), (Object)busAccount);
        JSONObject authCorpInfo = jsonObject.getJSONObject("auth_corp_info");
        String clientId = authCorpInfo.getString("corpid");
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)busAccount)).eq(JustAuthConfig::getClientId, (Object)clientId)).eq(JustAuthConfig::getAuthType, (Object)"WECHAT_ENTERPRISE_DEVELOP")).eq(JustAuthConfig::getDataType, (Object)"dataConfig")).last(" limit 1");
        JustAuthConfig config = (JustAuthConfig)((Object)((JustAuthConfigMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == config) {
            return;
        }
        String clientSecret = jsonObject.getString("permanent_code");
        config.setClientSecret(clientSecret);
        this.updateById((Object)config);
        log.info("#updateAuthSuitesSecret \u66f4\u65b0\u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801:{},busAccount:{} \u5b8c\u6bd5", (Object)jsonObject.toJSONString(), (Object)busAccount);
    }

    @Override
    public void cancelAuth(String authCorpId, String suiteId, String busAccount, String type) {
        if ("100000".equals(busAccount)) {
            return;
        }
        log.info("#cancelAuth \u5220\u9664\u4f01\u4e1a\u6388\u6743\uff0cauthCorpId :{},suiteId::{},busAccount:{}", new Object[]{authCorpId, suiteId, busAccount});
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(JustAuthConfig::getClientId, (Object)authCorpId)).eq(JustAuthConfig::getSuiteId, (Object)suiteId)).eq(JustAuthConfig::getDataType, (Object)"dataConfig")).eq(JustAuthConfig::getAuthType, (Object)type);
        ((JustAuthConfigMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public List<JustAuthConfigVO> findBindList(String elsAccount, String userId) {
        List<String> elsAccountList = this.justAuthInvokeSupplierRpcService.listPurchaseSupplier(elsAccount);
        if (elsAccountList != null && !elsAccountList.contains("100000")) {
            elsAccountList.add("100000");
        }
        return ((JustAuthConfigMapper)this.baseMapper).findBindList(elsAccount, userId, elsAccountList);
    }
}

