/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.util;

import cn.hutool.core.util.StrUtil;
import com.els.common.util.I18nUtil;
import com.els.modules.esign.enumerate.RequestType;
import com.els.modules.esign.util.HttpHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import sun.misc.BASE64Encoder;

public class FileHelper {
    private FileHelper() {
    }

    public static byte[] getBytes(String filePath) throws Exception {
        File file = new File(filePath);
        FileInputStream fis = null;
        byte[] buffer = null;
        try {
            fis = new FileInputStream(file);
            buffer = new byte[(int)file.length()];
            while (fis.read(buffer) > 0) {
            }
        }
        catch (Exception e) {
            throw new Exception(I18nUtil.translate((String)"i18n_alert_SMQIJyQKm_9630d45c", (String)"\u83b7\u53d6\u6587\u4ef6\u5b57\u8282\u6d41\u5931\u8d25"));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer;
    }

    public static String getContentMD5(String filePath) throws Exception {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(FileHelper.getFileMd5Bytes128(filePath));
    }

    public static String getContentType(String filePath) throws Exception {
        Path path = Paths.get(filePath, new String[0]);
        try {
            String res = Files.probeContentType(path);
            return StrUtil.isEmpty((CharSequence)res) ? "application/pdf" : res;
        }
        catch (IOException e) {
            throw new Exception(I18nUtil.translate((String)"i18n_alert_SMQIWWWWAcKm_3a2c7a46", (String)"\u83b7\u53d6\u6587\u4ef6MIME\u7c7b\u578b\u5931\u8d25"));
        }
    }

    public static String getBase64Str(String path) throws Exception {
        InputStream is = null;
        try {
            is = new FileInputStream(new File(path));
            byte[] bytes = new byte[is.available()];
            while (is.read(bytes) > 0) {
            }
            String string = new BASE64Encoder().encode(bytes);
            return string;
        }
        catch (Exception e) {
            throw new Exception(I18nUtil.translate((String)"i18n_alert_SMQIWNQKm_5ff12cd5", (String)"\u83b7\u53d6\u6587\u4ef6\u8f93\u5165\u6d41\u5931\u8d25"));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getFileName(String path) {
        return new File(path).getName();
    }

    private static byte[] getFileMd5Bytes128(String filePath) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filePath));
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = fis.read(buffer, 0, 1024)) != -1) {
                md5.update(buffer, 0, len);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
        catch (Exception e) {
            throw new Exception(I18nUtil.translate((String)"i18n_alert_SMQIWWWxHRWVKm_6c510eff", (String)"\u83b7\u53d6\u6587\u4ef6md5\u4e8c\u8fdb\u5236\u6570\u7ec4\u5931\u8d25"));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void streamUpload(String filePath, String uploadUrl, String md5) throws Exception {
        byte[] bytes = FileHelper.getBytes(filePath);
        String contentMd5 = md5;
        String conentType = filePath.endsWith(".pdf") ? "application/pdf" : "application/octet-stream";
        HttpHelper.doUploadHttp(RequestType.PUT, uploadUrl, bytes, contentMd5, conentType);
    }

    public static void streamUploadFile(byte[] bytes, String path, String uploadUrl, String md5) throws Exception {
        String contentMd5 = md5;
        String conentType = path.endsWith(".pdf") ? "application/pdf" : "application/octet-stream";
        HttpHelper.doUploadHttp(RequestType.PUT, uploadUrl, bytes, contentMd5, conentType);
    }

    public static void streamUpload(byte[] bytes, String uploadUrl, String md5, String contentType) throws Exception {
        String contentMd5 = md5;
        HttpHelper.doUploadHttp(RequestType.PUT, uploadUrl, bytes, contentMd5, contentType);
    }
}

