/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contractlock.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.FileRpcService;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.SaleContractHeadDTO;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contractlock.entity.ElsClSignAttachment;
import com.els.modules.contractlock.entity.ElsClSignContract;
import com.els.modules.contractlock.entity.ElsClSigners;
import com.els.modules.contractlock.entity.PurchaseClPersonalInfo;
import com.els.modules.contractlock.enumerate.CLBusTypeEnum;
import com.els.modules.contractlock.enumerate.CLConstant;
import com.els.modules.contractlock.enumerate.CLContractStatusEnum;
import com.els.modules.contractlock.enumerate.CLFirstSealEnum;
import com.els.modules.contractlock.enumerate.ClContractSignStatusEmun;
import com.els.modules.contractlock.enumerate.ClContractTenantType;
import com.els.modules.contractlock.enumerate.ClSignerStatusEmun;
import com.els.modules.contractlock.mapper.ElsClContractMapper;
import com.els.modules.contractlock.service.ElsClContractService;
import com.els.modules.contractlock.service.ElsClSignAttachmentService;
import com.els.modules.contractlock.service.ElsClSignersService;
import com.els.modules.contractlock.service.PurchaseClPersonalInfoService;
import com.els.modules.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.contractlock.vo.ClCallback;
import com.els.modules.contractlock.vo.ClContractVO;
import com.els.modules.contractlock.vo.ClCreateContractVO;
import com.els.modules.contractlock.vo.ClDocumentContractVO;
import com.els.modules.contractlock.vo.ElsClSignersVo;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.esign.enumerate.EsignStatusEmun;
import com.els.modules.esign.enumerate.SignerVindicateStatusEnum;
import com.els.modules.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.esign.rpc.service.EsignInvokeOrderRpcService;
import com.els.modules.esign.service.EsignOperationService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.enumerate.EsignFinalStatusEnum;
import com.els.modules.order.api.enumerate.OrderEsignStatusEnum;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.rpc.service.InvokeSupplierRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsClContractServiceImpl
extends BaseServiceImpl<ElsClContractMapper, ElsClSignContract>
implements ElsClContractService {
    private static final Logger log = LoggerFactory.getLogger(ElsClContractServiceImpl.class);
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsClSignersService elsClSignersService;
    @Autowired
    private EsignOperationService operationService;
    @Autowired
    private FileRpcService fileRpcService;
    private static final String BIZ_PATH = "files";
    private static final String STR_FORMAT = "yyyyMMdd";
    @Autowired
    private EsignInvokeContractRpcService contractRpcService;
    @Autowired
    private EsignInvokeOrderRpcService orderRpcService;
    @Autowired
    private ElsClSignAttachmentService signAttachmentService;
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeSupplierRpcService invokeSupplierRpcService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private PurchaseClPersonalInfoService purchaseClPersonalInfoService;

    @Override
    public void add(ElsClSignContract elsClSignContract) {
        this.insert(elsClSignContract);
    }

    private void insert(ElsClSignContract elsClSignContract) {
        SupplierMasterDataDTO supplierMasterDataDTO;
        ElsEnterpriseInfo enterpriseInfo;
        elsClSignContract.setCreateTime(new Date());
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        elsClSignContract.setCreateBy(currentUser);
        elsClSignContract.setElsAccount(TenantContext.getTenant());
        if (StringUtils.isBlank((CharSequence)elsClSignContract.getPurchaseName()) && (enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(TenantContext.getTenant())) != null) {
            elsClSignContract.setPurchaseName(enterpriseInfo.getName());
        }
        if (StringUtils.isBlank((CharSequence)elsClSignContract.getSupplierName()) && (supplierMasterDataDTO = this.invokeSupplierRpcService.getToELsAccount(TenantContext.getTenant())) != null) {
            elsClSignContract.setSupplierName(supplierMasterDataDTO.getSupplierName());
        }
        elsClSignContract.setSignStatus("0");
        elsClSignContract.setPurchaseSignStatus(ClSignerStatusEmun.NO_SIGNERS_SET.getValue());
        elsClSignContract.setSaleSignStatus(ClSignerStatusEmun.NO_SIGNERS_SET.getValue());
        elsClSignContract.setBusAccount("100000");
        elsClSignContract.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
        if ("single".equals(elsClSignContract.getBusType())) {
            elsClSignContract.setBusNumber(this.invokeBaseRpcService.getNextCode("srmClSignNumber", (Object)elsClSignContract));
        }
        this.handleBusType(elsClSignContract, CLBusTypeEnum.ADD);
        ((ElsClContractMapper)this.baseMapper).insert((Object)elsClSignContract);
    }

    private void sendMsg(ElsClSignContract elsClSignContract) {
        List userRole;
        List userIds;
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(elsClSignContract.getElsAccount());
        String url = "id=" + elsClSignContract.getId();
        String elsAccount = elsClSignContract.getElsAccount();
        Role role = (Role)this.roleService.getOne((Wrapper)Wrappers.lambdaQuery().eq(Role::getRoleCode, (Object)"contractLockOpt"));
        if (ObjectUtil.isNotEmpty((Object)role) && CollUtil.isNotEmpty(userIds = (userRole = this.userRoleService.list((Wrapper)Wrappers.lambdaQuery().in(UserRole::getRoleId, new Object[]{role.getId()}))).stream().map(x -> x.getUserId()).distinct().collect(Collectors.toList()))) {
            List elsSubAccounts = this.elsSubAccountService.listByIds(userIds);
            List subAccounts = elsSubAccounts.stream().map(x -> x.getSubAccount()).distinct().collect(Collectors.toList());
            super.sendMsg("100000", elsAccount, subAccounts, (Object)elsClSignContract, url, "contractLock", "contract_add_sign");
        }
    }

    private void handleContractStatus(ElsClSignContract elsClSignContract, CLBusTypeEnum type) {
        PurchaseContractHeadDTO contractHead = this.contractRpcService.getPurchaseContractById(elsClSignContract.getRelationId());
        if (contractHead != null) {
            if ("1".equals(contractHead.getStartSign()) && CLBusTypeEnum.isAdd(type)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            if (CLBusTypeEnum.isAdd(type)) {
                contractHead.setStartSign("1");
                contractHead.setSignType("contractLock");
                this.sendMsg(elsClSignContract);
            }
            if (CLBusTypeEnum.isFINISH(type)) {
                contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                contractHead.setEndSign(elsClSignContract.getSignStatus());
            }
            if (CLBusTypeEnum.isReturn(type)) {
                contractHead.setStartSign("0");
            }
            if (CLBusTypeEnum.isRevoke(type)) {
                contractHead.setEndSign(elsClSignContract.getSignStatus());
            }
            this.contractRpcService.updatePurchaseEntityById(contractHead);
            SaleContractHeadDTO saleContractHead = this.contractRpcService.getSaleContractById(contractHead.getRelationId());
            if (saleContractHead != null) {
                if (CLBusTypeEnum.isAdd(type)) {
                    saleContractHead.setStartSign("1");
                }
                if (CLBusTypeEnum.isFINISH(type)) {
                    saleContractHead.setContractStatus(contractHead.getContractStatus());
                    saleContractHead.setEndSign(contractHead.getEndSign());
                }
                if (CLBusTypeEnum.isReturn(type)) {
                    saleContractHead.setEndSign(contractHead.getEndSign());
                }
                this.contractRpcService.updateSaleEntityById(saleContractHead);
            }
        }
    }

    private void handleOrderStatus(ElsClSignContract elsClSignContract, CLBusTypeEnum type) {
        PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.orderRpcService.getPurchaseOrderById(elsClSignContract.getRelationId());
        if (purchaseOrderHeadDTO != null) {
            if (CLBusTypeEnum.isAdd(type) && (OrderEsignStatusEnum.START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus()) || OrderEsignStatusEnum.CHANGED_START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus()))) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            if (CLBusTypeEnum.isAdd(type)) {
                purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.START_END.getValue() : OrderEsignStatusEnum.CHANGED_START_END.getValue());
                purchaseOrderHeadDTO.setSignType("contractLock");
            }
            if (CLBusTypeEnum.isReturn(type)) {
                purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.NO_START.getValue() : OrderEsignStatusEnum.CHANGED_NO_START.getValue());
            }
        }
        if (CLBusTypeEnum.isFINISH(type)) {
            purchaseOrderHeadDTO.setEsignFinalStatus(EsignFinalStatusEnum.FINAL.getValue());
            this.orderRpcService.updateSaleOrderByRelationId(purchaseOrderHeadDTO);
        }
        this.orderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
    }

    private void handleBusType(ElsClSignContract elsClSignContract, CLBusTypeEnum type) {
        switch (elsClSignContract.getBusType()) {
            case "contract": {
                this.handleContractStatus(elsClSignContract, type);
                break;
            }
            case "order": {
                this.handleOrderStatus(elsClSignContract, type);
                break;
            }
        }
    }

    @Override
    public void edit(ElsClSignContract elsClSignContract) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        elsClSignContract.setUpdateBy(currentUser);
        elsClSignContract.setUpdateTime(new Date());
        int count = ((ElsClContractMapper)this.baseMapper).updateById((Object)elsClSignContract);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsClContractMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsClContractMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ClContractVO req) {
        this.insert(req);
        ArrayList signers = this.converSigners(req.getSigners());
        if (CollUtil.isEmpty(signers)) {
            signers = Lists.newArrayList();
            if (CollUtil.isNotEmpty(req.getPurchaseSigners())) {
                signers.addAll(this.converSigners(req.getPurchaseSigners()));
            }
            if (CollUtil.isNotEmpty(req.getSaleSigners())) {
                signers.addAll(this.converSigners(req.getSaleSigners()));
            }
        }
        if (CollUtil.isNotEmpty((Collection)signers)) {
            this.initSigner(signers, req);
            this.elsClSignersService.saveBatch(signers);
            req.setSigners(req.getSigners());
        }
    }

    private List<ElsClSigners> converSigners(List<ElsClSignersVo> vos) {
        if (CollUtil.isEmpty(vos)) {
            return Lists.newArrayList();
        }
        List<ElsClSigners> list = vos.stream().map(vo -> {
            ElsClSigners signers = new ElsClSigners();
            BeanUtil.copyProperties((Object)vo, (Object)((Object)signers), (String[])new String[0]);
            signers.setTenantType(vo.getTenantTypeArr().stream().collect(Collectors.joining(",")));
            return signers;
        }).collect(Collectors.toList());
        return list;
    }

    private List<ElsClSignersVo> converSignersVo(List<ElsClSigners> dbs) {
        List<ElsClSignersVo> list = dbs.stream().map(db -> {
            ElsClSignersVo vo = new ElsClSignersVo();
            BeanUtil.copyProperties((Object)db, (Object)((Object)vo), (String[])new String[0]);
            vo.setTenantTypeArr(Arrays.asList(db.getTenantType().split(",")));
            return vo;
        }).collect(Collectors.toList());
        return list;
    }

    private void handleSignerVindicateStatus(ClContractVO req) {
        if (CollUtil.isNotEmpty(req.getPurchaseSigners()) && "1".equals(req.getOnlineSealed())) {
            req.setSignerVindicateStatus(SignerVindicateStatusEnum.SALE_NO_MAINTENANCE.getValue());
        }
        if (CollUtil.isNotEmpty(req.getSaleSigners())) {
            req.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
        }
        if (CollUtil.isNotEmpty(req.getPurchaseSigners()) && "0".equals(req.getOnlineSealed())) {
            req.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
        }
        if (req.getBusType().equals("single") && CollUtil.isNotEmpty(req.getPurchaseSigners()) && CollUtil.isNotEmpty(req.getPurchaseAttachmentList())) {
            req.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void editMain(ClContractVO req) {
        if (CollUtil.isNotEmpty(req.getPurchaseSigners()) || CollUtil.isNotEmpty(req.getSaleSigners())) {
            List<ElsClSigners> signers = this.initUpdateSigner(req.getPurchaseSigners(), req.getSaleSigners(), req);
            this.elsClSignersService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsClSigners::getHeadId, (Object)req.getId())).notIn(BaseEntity::getId, (Collection)signers.stream().map(x -> x.getId()).collect(Collectors.toList())));
            ArrayList inserts = Lists.newArrayList();
            ArrayList updates = Lists.newArrayList();
            signers.forEach(x -> {
                if (StrUtil.isNotBlank((CharSequence)x.getId())) {
                    updates.add(x);
                } else {
                    x.setCreateTime(new Date());
                    LoginUser sysUser = SysUtil.getLoginUser();
                    String currentUser = sysUser.getSubAccount();
                    x.setCreateBy(currentUser);
                    x.setElsAccount(TenantContext.getTenant());
                    x.setSignStatus("0");
                    x.setBusAccount("100000");
                    inserts.add(x);
                }
            });
            if (CollUtil.isNotEmpty((Collection)inserts)) {
                this.elsClSignersService.saveBatch(inserts);
            }
            if (CollUtil.isNotEmpty((Collection)updates)) {
                this.elsClSignersService.updateBatchById(updates);
            }
        } else {
            this.elsClSignersService.remove((Wrapper)Wrappers.lambdaQuery().eq(ElsClSigners::getHeadId, (Object)req.getId()));
        }
        this.handleSignAttachment(req);
        this.handleSignerVindicateStatus(req);
        this.edit(req);
    }

    private void handleSignAttachment(ClContractVO req) {
        if (CollUtil.isNotEmpty(req.getPurchaseAttachmentList())) {
            this.signAttachmentService.remove((Wrapper)Wrappers.lambdaQuery().eq(ElsClSignAttachment::getHeadId, (Object)req.getId()));
            req.getPurchaseAttachmentList().forEach(row -> row.setAccountType("0"));
            this.signAttachmentService.saveBatch(req.getPurchaseAttachmentList());
        }
        if (CollUtil.isNotEmpty(req.getSaleAttachmentList())) {
            this.signAttachmentService.remove((Wrapper)Wrappers.lambdaQuery().eq(ElsClSignAttachment::getHeadId, (Object)req.getId()));
            req.getSaleAttachmentList().forEach(row -> row.setAccountType("1"));
            this.signAttachmentService.saveBatch(req.getSaleAttachmentList());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public ClContractVO createDraft(String id, String companyId, String creatorId) {
        ClContractVO dbVo = this.getMainById(id);
        dbVo.setCreatorId(creatorId);
        if (ObjectUtil.isNotEmpty((Object)dbVo.getPurchaseSigners().get(0).getPersonal()) && dbVo.getPurchaseSigners().get(0).getPersonal().booleanValue()) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)companyId), (String)I18nUtil.translate((String)"i18n_field_AnImPWLLSAEjmLKWViFPWdD_4b0f671b", (String)"\u5f53\u7b2c\u4e00\u4e2a\u7b7e\u7f72\u4eba\u4e3a\u65e0\u4f01\u4e1a\u7684\u4e2a\u4eba\u65f6\uff0c\u8bf7\u9009\u62e9\u7b7e\u7f72\u4e3b\u4f53"));
            dbVo.setCompanyId(companyId);
        } else {
            dbVo.setCompanyId(dbVo.getPurchaseSigners().get(0).getCompanyId());
        }
        ClCreateContractVO createParams = this.buildCreateDraftParams(dbVo);
        Result<?> response = this.getIPassResponse(createParams, "create-contract-draft");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            dbVo.setContractId(jsonObject.getString("id"));
            dbVo.setContractStatus(jsonObject.getString("status"));
            dbVo.setContractStatus(CLContractStatusEnum.DRAFT.getValue());
            dbVo.setUploaded("0");
            dbVo.setDocumentId(null);
            dbVo.setDocumentName(null);
            this.edit(dbVo);
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
        return null;
    }

    private ClCreateContractVO buildCreateDraftParams(ClContractVO db) {
        PurchaseClPersonalInfo purchaseClPersonalInfo;
        ClCreateContractVO req = new ClCreateContractVO();
        req.setCompanyId(db.getCompanyId());
        req.setCallBackUrl(this.address + "/els/contractLock/elsClContract/noToken/callback/contract");
        req.getBody().setSubject(db.getSubject());
        if (StrUtil.isNotBlank((CharSequence)db.getCreatorId()) && ObjectUtil.isNotEmpty((Object)((Object)(purchaseClPersonalInfo = (PurchaseClPersonalInfo)((Object)this.purchaseClPersonalInfoService.getById((Serializable)((Object)db.getCreatorId()))))))) {
            ClCreateContractVO.Receiver create = new ClCreateContractVO.Receiver();
            create.setContact(purchaseClPersonalInfo.getApplyContact());
            create.setContactType(purchaseClPersonalInfo.getApplyContactType());
            req.getBody().setCreator(create);
            db.setCreateContact(purchaseClPersonalInfo.getApplyContact());
            db.setCreateContactType(purchaseClPersonalInfo.getApplyContactType());
        }
        ArrayList signatories = Lists.newArrayList();
        List<ElsClSigners> dbSigners = this.converSigners(db.getSigners());
        Assert.isTrue((boolean)CollUtil.isNotEmpty(dbSigners), (String)I18nUtil.translate((String)"i18n_alert_PWLxOLV_9c982296", (String)"\u7b7e\u7f72\u4eba\u4e0d\u80fd\u4e3a\u7a7a"));
        for (ElsClSigners signer : dbSigners) {
            ClCreateContractVO.Signatories toParams;
            List<String> tentTypeAyy = Arrays.asList(signer.getTenantType().split(","));
            ClCreateContractVO.Receiver receiver = new ClCreateContractVO.Receiver();
            receiver.setContact(signer.getSignatoryContact());
            receiver.setContactType(signer.getSignatoryContactType());
            if (tentTypeAyy.contains(ClContractTenantType.COMPANY.getValue()) || tentTypeAyy.contains(ClContractTenantType.LP.getValue())) {
                ClCreateContractVO.Actions actions;
                toParams = new ClCreateContractVO.Signatories();
                toParams.setTenantType(ClContractTenantType.COMPANY.getValue());
                toParams.setTenantName(signer.getCompanyName());
                toParams.setReceiver(receiver);
                toParams.setSerialNo(signer.getSerialNo());
                int actionNo = 1;
                if (tentTypeAyy.contains(ClContractTenantType.COMPANY.getValue())) {
                    actions = new ClCreateContractVO.Actions();
                    actions.setType(ClContractTenantType.COMPANY.getValue());
                    actions.setSerialNo(actionNo);
                    ++actionNo;
                    if (StrUtil.isNotBlank((CharSequence)signer.getSealIds())) {
                        List<String> seals = Arrays.asList(signer.getSealIds().split(","));
                        actions.setSealIds(seals.stream().map(x -> Long.valueOf(x)).distinct().collect(Collectors.toList()));
                    } else {
                        actions.setSealId(signer.getSealId());
                    }
                    if (StrUtil.isNotBlank((CharSequence)db.getCompanyId()) && db.getCompanyId().equals(signer.getCompanyId())) {
                        actions.setOperators(Arrays.asList(receiver));
                    }
                    toParams.getActions().add(actions);
                }
                if (tentTypeAyy.contains(ClContractTenantType.LP.getValue())) {
                    actions = new ClCreateContractVO.Actions();
                    actions.setType(ClContractTenantType.LP.getValue());
                    actions.setSerialNo(actionNo);
                    toParams.getActions().add(actions);
                }
                signatories.add(toParams);
            }
            if (!tentTypeAyy.contains(ClContractTenantType.PERSONAL.getValue())) continue;
            toParams = new ClCreateContractVO.Signatories();
            toParams.setTenantType(ClContractTenantType.PERSONAL.getValue());
            toParams.setTenantName(signer.getSignatoryName());
            toParams.setReceiver(receiver);
            toParams.setSerialNo(signer.getSerialNo());
            signatories.add(toParams);
        }
        req.getBody().setSignatories(signatories);
        return req;
    }

    @Override
    public ClContractVO getMainById(String id) {
        List<ElsClSignAttachment> signAttachments;
        PurchaseClPersonalInfo personalInfo;
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClContractVO vo = new ClContractVO();
        BeanUtil.copyProperties((Object)((Object)contract), (Object)((Object)vo), (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)contract.getCreatorId()) && ObjectUtil.isNotEmpty((Object)((Object)(personalInfo = (PurchaseClPersonalInfo)((Object)this.purchaseClPersonalInfoService.getById((Serializable)((Object)contract.getCreatorId()))))))) {
            vo.setCreator(personalInfo.getApplyUserName());
        }
        List<ElsClSigners> signers = this.elsClSignersService.listByHeadId(id);
        vo.setSigners(this.converSignersVo(signers));
        if (CollUtil.isNotEmpty(signers)) {
            List<ElsClSigners> purchaseSigners = signers.stream().filter(x -> CLFirstSealEnum.PURCHASE.getCode().equals(x.getRoleType())).collect(Collectors.toList());
            List<ElsClSigners> saleSigners = signers.stream().filter(x -> CLFirstSealEnum.SALE.getCode().equals(x.getRoleType())).collect(Collectors.toList());
            vo.setPurchaseSigners(this.converSignersVo(purchaseSigners));
            vo.setSaleSigners(this.converSignersVo(saleSigners));
        }
        if (CollUtil.isNotEmpty(signAttachments = this.signAttachmentService.listByHeadId(id))) {
            vo.setAttachmentList(signAttachments);
            List<ElsClSignAttachment> purchaseSignAttachments = signAttachments.stream().filter(x -> "0".equals(x.getAccountType())).collect(Collectors.toList());
            vo.setPurchaseAttachmentList(purchaseSignAttachments);
            List<ElsClSignAttachment> saleAttachmentList = signAttachments.stream().filter(x -> "1".equals(x.getAccountType())).collect(Collectors.toList());
            vo.setSaleAttachmentList(saleAttachmentList);
        }
        return vo;
    }

    private List<ElsClSignAttachment> getBusUrl(ClContractVO contract, ClContractVO req, HttpServletRequest request) {
        if (contract.getBusType().equals("single")) {
            List<ElsClSignAttachment> attachments = contract.getAttachmentList();
            Assert.isTrue((boolean)CollUtil.isNotEmpty(attachments), (String)"attachments is null");
            return attachments;
        }
        if ("0".equals(contract.getOnlineSealed())) {
            List<ElsClSignAttachment> attachments = contract.getSaleAttachmentList();
            Assert.isTrue((boolean)CollUtil.isNotEmpty(attachments), (String)"attachments is null");
            return attachments;
        }
        String cookie = request.getHeader("cookie");
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        File file = this.operationService.getFileById(contract.getRelationId(), contract.getBusType(), contract.getBusNumber(), "1", req.getReportUrl(), req.getToken(), cookie);
        String documentLocation = File.separator + BIZ_PATH + File.separator + TenantContext.getTenant() + File.separator + nowDay + File.separator + file.getName();
        if (documentLocation.contains("\\")) {
            documentLocation = documentLocation.replace("\\", "/");
        }
        if (documentLocation.startsWith("\\")) {
            documentLocation.replace("\\", "");
        }
        if (documentLocation.startsWith("/")) {
            documentLocation = documentLocation.substring(1);
        }
        String fileResult = this.fileRpcService.uploadFiles(FileUtil.readBytes((File)file), documentLocation, file.getName(), "oss");
        log.info("\u5951\u7ea6\u9501\u6587\u6863result:[{}]", (Object)fileResult);
        String url = this.fileRpcService.getRealPath(documentLocation, "oss", false);
        log.info("\u5951\u7ea6\u9501\u6587\u6863url:[{}]", (Object)url);
        ElsClSignAttachment attachment = new ElsClSignAttachment();
        attachment.setAbsoluteFilePath(url);
        attachment.setFileName(file.getName());
        attachment.setFilePath(documentLocation);
        attachment.setRelationId(contract.getId());
        attachment.setHeadId(contract.getId());
        attachment.setFileName(file.getName());
        attachment.setBusinessType("contractLock");
        attachment.setFileType("5");
        attachment.setSignType("1");
        attachment.setAccountType("0");
        attachment.setUploadTime(new Date());
        attachment.setUploadElsAccount(contract.getElsAccount());
        attachment.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
        attachment.setFileSize(String.valueOf(file.length()));
        attachment.setCreateBy(contract.getCreateBy());
        attachment.setCreateById(contract.getCreateById());
        this.signAttachmentService.save((Object)attachment);
        return Arrays.asList(attachment);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public ClContractVO uploadFileToContractLock(ClContractVO req, HttpServletRequest request, HttpServletResponse response) {
        ClContractVO contract = this.getMainById(req.getId());
        Assert.notNull((Object)((Object)contract), (String)"contract is null");
        Assert.notNull((Object)contract.getContractId(), (String)I18nUtil.translate((String)"i18n_alert_VWcInetx_b478644a", (String)"\u8bf7\u5148\u521b\u5efa\u5408\u540c\u8349\u7a3f"));
        List<ElsClSignAttachment> uf = this.getBusUrl(contract, req, request);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(uf), (String)"contract is null");
        ArrayList documentIds = Lists.newArrayList();
        uf.forEach(file -> {
            String fileUrl = file.getAbsoluteFilePath();
            String fileName = file.getFileName();
            ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
            documentContractVO.setCompanyId(contract.getCompanyId());
            ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
            body.setFile(fileUrl);
            body.setTitle(fileName);
            body.setFileSuffix(fileUrl.substring(fileUrl.lastIndexOf(".") + 1));
            body.setContractId(contract.getContractId());
            documentContractVO.setBody(body);
            Result<?> result = this.getIPassResponse(documentContractVO, "upload-contract-document");
            if (result.isSuccess()) {
                JSONObject jsonObject = (JSONObject)result.getResult();
                documentIds.add(jsonObject.getString("documentId"));
                file.setUploaded("1");
                file.setFileId(jsonObject.getString("documentId"));
                this.signAttachmentService.updateById(file);
            } else {
                Assert.isTrue((boolean)false, (String)result.getMessage());
            }
        });
        contract.setLocalFilePath(uf.stream().map(x -> x.getAbsoluteFilePath()).collect(Collectors.joining(",")));
        String fileName = uf.get(0).getFileName();
        contract.setDocumentName(DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss") + fileName);
        contract.setUploaded("1");
        contract.setDocumentId(documentIds.stream().collect(Collectors.joining(",")));
        this.edit(contract);
        return null;
    }

    @Override
    public String browsePage(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body base = new ClDocumentContractVO.Body();
        base.setContractId(contract.getContractId());
        documentContractVO.setBase(base);
        Result<?> response = this.getIPassResponse(documentContractVO, "get-contract-page");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            return jsonObject.getString("pageUrl");
        }
        Assert.isTrue((boolean)false, (String)response.getMessage());
        return null;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void initiate(String id) {
        ClContractVO contract = this.getMainById(id);
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
        body.setContractId(contract.getContractId());
        body.setDocumentId(contract.getDocumentId());
        List<ElsClSigners> signers = this.converSigners(contract.getSigners());
        body.setStampers(Lists.newArrayList());
        signers.forEach(signer -> {
            if ("1".equals(signer.getAutoSign())) {
                ClDocumentContractVO.Stampers stampers = new ClDocumentContractVO.Stampers();
                stampers.setActionId(signer.getActionId());
                stampers.setDocumentId(contract.getDocumentId());
                stampers.setType(signer.getTenantType());
                Double x = Double.valueOf(signer.getOffsetX());
                Double xp = x / 546.0;
                stampers.setOffsetX(xp.toString());
                Double y = Double.valueOf(signer.getOffsetY());
                Double yp = y / 739.0;
                stampers.setOffsetY(yp.toString());
                stampers.setPage(Integer.valueOf(signer.getPage()));
                stampers.setActionId(signer.getActionId());
                stampers.setSignatoryId(signer.getSignatoryId());
                body.getStampers().add(stampers);
            }
        });
        documentContractVO.setBody(body);
        Result<?> response = this.getIPassResponse(documentContractVO, "initiate-contract-document");
        if (response.isSuccess()) {
            contract.setContractStatus(CLContractStatusEnum.SIGNING.getValue());
            contract.setLaunch("1");
            this.edit(contract);
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
    }

    @Override
    public String getSignPage(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
        body.setContractId(contract.getContractId());
        documentContractVO.setBase(body);
        Result<?> response = this.getIPassResponse(documentContractVO, "get-sign-short-url");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            return jsonObject.getString("shorturl");
        }
        Assert.isTrue((boolean)false, (String)response.getMessage());
        return null;
    }

    private ElsClSignContract getByRelationId(String id) {
        return (ElsClSignContract)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsClSignContract::getRelationId, (Object)id)).eq(BaseEntity::getDeleted, (Object)"0")));
    }

    @Override
    public ElsClSignContract downloadArchive(String id, String relationId) {
        ElsClSignContract contract = null;
        if (StrUtil.isNotBlank((CharSequence)id)) {
            contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        } else if (StrUtil.isNotBlank((CharSequence)relationId)) {
            contract = this.getByRelationId(relationId);
        }
        Assert.notNull((Object)((Object)contract), (String)I18nUtil.translate((String)"i18n_alert_QLIH_338001e0", (String)"\u6d41\u7a0b\u5f02\u5e38"));
        return contract;
    }

    private ElsClSignContract getByContractId(String id) {
        return ((ElsClContractMapper)this.baseMapper).selectByRequestId(id);
    }

    @Override
    public void handleCallBackContract(ClCallback.Contract contract) {
        String ty;
        ElsClSigners signers;
        ElsClSignContract dbContract = this.getByContractId(contract.getContractId());
        if (StrUtil.isNotBlank((CharSequence)contract.getTenantType()) && StrUtil.isNotBlank((CharSequence)contract.getContact()) && ObjectUtil.isNotNull((Object)((Object)(signers = this.elsClSignersService.selectByParam(ty = "LEGAL_PERSON".equals(Optional.ofNullable(contract.getCallbackType()).orElse("")) ? ClContractTenantType.LP.getValue() : contract.getTenantType(), contract.getContact(), dbContract.getId()))))) {
            signers.setSignStatus(contract.getContractStatus());
            if (CLConstant.CONTRACT_SUCCESS_STATS.contains(contract.getCallbackType()) || CLContractStatusEnum.COMPLETE.getValue().equals(contract.getContractStatus())) {
                signers.setSignTime(new Date());
                if (CLFirstSealEnum.PURCHASE.getCode().equals(signers.getRoleType())) {
                    dbContract.setPurchaseSignStatus(ClSignerStatusEmun.SUCCESS.getValue());
                } else {
                    dbContract.setSignStatus(ClSignerStatusEmun.SUCCESS.getValue());
                }
            }
            this.elsClSignersService.updateById((Object)signers);
        }
        if (ObjectUtil.isNotNull((Object)((Object)dbContract)) && !CLContractStatusEnum.COMPLETE.getValue().equals(dbContract.getContractStatus())) {
            dbContract.setContractStatus(contract.getContractStatus());
            if (CLContractStatusEnum.COMPLETE.getValue().equals(contract.getContractStatus())) {
                this.handleSuccess(dbContract);
            }
            dbContract.setLaunch("1");
            this.updateById((Object)dbContract);
        }
    }

    private void handleSuccess(ElsClSignContract dbContract) {
        dbContract.setSignStatus(ClContractSignStatusEmun.FINISHED.getValue());
        dbContract.setPurchaseSignStatus(ClSignerStatusEmun.SUCCESS.getValue());
        dbContract.setSaleSignStatus(ClSignerStatusEmun.SUCCESS.getValue());
        dbContract.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
        this.handleBusType(dbContract, CLBusTypeEnum.FINISH);
        if ("1".equals(dbContract.getAutoArchiving())) {
            TenantContext.setTenant((String)dbContract.getElsAccount());
            try {
                this.handelArchive(dbContract);
            }
            catch (Exception e) {
                log.error("contract[{}]handelArchive error{}", (Object)dbContract.getId(), (Object)e);
            }
        }
        if (dbContract.getBusType().equals("single") && "1".equals(dbContract.getAutoSend())) {
            dbContract.setSendStatus("1");
        }
    }

    @Override
    public Result<?> flowQuery(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body base = new ClDocumentContractVO.Body();
        base.setContractId(contract.getContractId());
        documentContractVO.setBase(base);
        Result<?> result = this.getIPassResponse(documentContractVO, "query-contract-document");
        JSONObject respone = (JSONObject)result.getResult();
        String status = respone.getString("status");
        if (status.equals(CLContractStatusEnum.COMPLETE.getValue()) && !CLContractStatusEnum.COMPLETE.getValue().equals(contract.getContractStatus())) {
            contract.setContractStatus(CLContractStatusEnum.COMPLETE.getValue());
            this.handleSuccess(contract);
            this.updateById((Object)contract);
        }
        return Result.ok((String)CLContractStatusEnum.getDesc(status));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void sendBack(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)contract), (String)I18nUtil.translate((String)"i18n_field_neLV_27784384", (String)"\u5408\u540c\u4e3a\u7a7a"));
        if (!EsignStatusEmun.UNDONE.getValue().equals(contract.getSignStatus())) {
            Assert.isTrue((!"1".equals(contract.getLaunch()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PWQLIhAWShYM_a3d2ed05", (String)"\u7b7e\u7f72\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u9000\u56de"));
        }
        if (CLContractStatusEnum.DRAFT.getValue().equals(contract.getContractStatus()) || CLContractStatusEnum.RECALLED.getValue().equals(contract.getContractStatus())) {
            ClDocumentContractVO vo = new ClDocumentContractVO();
            vo.setCompanyId(contract.getCompanyId());
            ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
            body.setContractId(contract.getContractId());
            vo.setBody(body);
            Result<?> result = this.getIPassResponse(vo, "revoke-contract");
            Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        }
        this.handleBusType(contract, CLBusTypeEnum.RETURN);
        contract.setSendBack("1");
        this.updateById((Object)contract);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void backout(String id, String reason) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)contract), (String)I18nUtil.translate((String)"i18n_field_neLV_27784384", (String)"\u5408\u540c\u4e3a\u7a7a"));
        Assert.isTrue((!"1".equals(contract.getSignStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_PWQLIyW_5e495400", (String)"\u7b7e\u7f72\u6d41\u7a0b\u5df2\u7ed3\u675f"));
        ClDocumentContractVO vo = new ClDocumentContractVO();
        vo.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
        body.setContractId(contract.getContractId());
        body.setReason(reason);
        vo.setBody(body);
        Result<?> result = this.getIPassResponse(vo, "revoke-contract");
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        contract.setContractStatus(CLContractStatusEnum.RECALLED.getValue());
        contract.setSignStatus(EsignStatusEmun.UNDONE.getValue());
        contract.setPurchaseSignStatus(ClSignerStatusEmun.UNDONE.getValue());
        contract.setSaleSignStatus(ClSignerStatusEmun.UNDONE.getValue());
        contract.setReason(reason);
        contract.setDocumentId(null);
        contract.setDocumentName(null);
        contract.setUploaded("0");
        contract.setLaunch("0");
        contract.setRejectReason(null);
        contract.setReason(null);
        this.updateById((Object)contract);
        this.handleBusType(contract, CLBusTypeEnum.REVOKE);
    }

    @Override
    public void send(ClContractVO req, HttpServletRequest request, HttpServletResponse response) {
        ClContractVO contract = this.getMainById(req.getId());
        try {
            contract.setLocalFilePath(this.getBusUrl(contract, req, request).stream().map(x -> x.getAbsoluteFilePath()).collect(Collectors.joining(",")));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6url\u5f02\u5e38", (Throwable)e);
        }
        contract.setSendStatus("1");
        this.updateById((Object)contract);
    }

    private void handelArchive(ElsClSignContract contract) {
        String documentIds = contract.getDocumentId();
        if (StrUtil.isBlank((CharSequence)documentIds)) {
            return;
        }
        ArrayList remoteFilePaths = Lists.newArrayList();
        for (String documentId : documentIds.split(",")) {
            ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
            documentContractVO.setCompanyId(contract.getCompanyId());
            ClDocumentContractVO.Body base = new ClDocumentContractVO.Body();
            base.setDocumentId(documentId);
            base.setFileName(contract.getDocumentName());
            documentContractVO.setBase(base);
            ElsClSignAttachment signAttachment = null;
            String fileName = contract.getDocumentName();
            signAttachment = (ElsClSignAttachment)((Object)this.signAttachmentService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsClSignAttachment::getHeadId, (Object)contract.getId())).eq(ElsClSignAttachment::getFileId, (Object)documentId)));
            base.setFileName(signAttachment.getFileName());
            fileName = signAttachment.getFileName();
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)documentContractVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-contract-document-file"));
            JSONObject result = object.getJSONObject("data");
            if (!StrUtil.isNotBlank((CharSequence)result.getString("file"))) continue;
            byte[] bytes = Base64.decode((CharSequence)result.getString("file"));
            LocalDateTime time = LocalDateTime.now();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
            String nowDay = dtf.format(time);
            String documentLocation = File.separator + BIZ_PATH + File.separator + TenantContext.getTenant() + File.separator + nowDay + File.separator + fileName;
            if (documentLocation.contains("\\")) {
                documentLocation = documentLocation.replace("\\", "/");
            }
            if (documentLocation.startsWith("\\")) {
                documentLocation.replace("\\", "");
            }
            if (documentLocation.startsWith("/")) {
                documentLocation = documentLocation.substring(1);
            }
            String fileResult = this.fileRpcService.uploadFiles(bytes, documentLocation, fileName, "oss");
            String url = this.fileRpcService.getRealPath(documentLocation, "oss", false);
            if (!StrUtil.isNotBlank((CharSequence)url)) continue;
            remoteFilePaths.add(url);
            if (!ObjectUtil.isNotEmpty((Object)((Object)signAttachment))) continue;
            signAttachment.setSignFilePath(url);
            this.signAttachmentService.updateById((Object)signAttachment);
        }
        if (CollUtil.isNotEmpty((Collection)remoteFilePaths)) {
            contract.setRemoteFilePath(remoteFilePaths.stream().collect(Collectors.joining(",")));
            contract.setArchiving("1");
            this.updateById((Object)contract);
        }
    }

    @Override
    public void archive(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        this.handelArchive(contract);
    }

    @Override
    public Object downSignFile(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)contract.getFbk1())) {
            return contract.getFbk1();
        }
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body base = new ClDocumentContractVO.Body();
        base.setDocumentId(contract.getDocumentId());
        base.setFileName(contract.getDocumentName());
        documentContractVO.setBase(base);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)documentContractVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-contract-document-file"));
        if (object.getBoolean("success").booleanValue()) {
            JSONObject result = object.getJSONObject("data");
            if (StrUtil.isNotBlank((CharSequence)result.getString("file"))) {
                byte[] bytes = Base64.decode((CharSequence)result.getString("file"));
                LocalDateTime time = LocalDateTime.now();
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
                String nowDay = dtf.format(time);
                String documentLocation = File.separator + BIZ_PATH + File.separator + TenantContext.getTenant() + File.separator + nowDay + File.separator + contract.getDocumentName();
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                if (documentLocation.startsWith("\\")) {
                    documentLocation.replace("\\", "");
                }
                if (documentLocation.startsWith("/")) {
                    documentLocation = documentLocation.substring(1);
                }
                String fileResult = this.fileRpcService.uploadFiles(bytes, documentLocation, contract.getDocumentName(), "oss");
                String url = this.fileRpcService.getRealPath(documentLocation, "oss", false);
                if (StrUtil.isNotBlank((CharSequence)url)) {
                    contract.setFbk1(url);
                    this.updateById((Object)contract);
                }
            }
            return contract.getFbk1();
        }
        Assert.isTrue((boolean)false, (String)object.getString("messsage"));
        return null;
    }

    @Override
    public byte[] downSignFileByDocumentId(String id, String fileName, String documentId) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body base = new ClDocumentContractVO.Body();
        base.setDocumentId(documentId);
        base.setFileName(fileName);
        documentContractVO.setBase(base);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)documentContractVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-contract-document-file"));
        if (object.getBoolean("success").booleanValue()) {
            JSONObject result = object.getJSONObject("data");
            if (StrUtil.isNotBlank((CharSequence)result.getString("file"))) {
                byte[] bytes = Base64.decode((CharSequence)result.getString("file"));
                return bytes;
            }
            Assert.isTrue((boolean)false, (String)object.getString("messsage"));
        }
        return null;
    }

    @Override
    public void saleSend(ClContractVO req) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(req.getSaleAttachmentList()), (String)"\u56de\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        req.getSaleAttachmentList().forEach(x -> x.setAccountType("1"));
        this.signAttachmentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsClSignAttachment::getHeadId, (Object)req.getId())).eq(ElsClSignAttachment::getAccountType, (Object)"1"));
        this.signAttachmentService.saveBatch(req.getSaleAttachmentList());
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)req.getId())));
        contract.setReturnSignedFile("1");
        contract.setReject("0");
        contract.setRejectReason("");
        this.updateById((Object)contract);
    }

    @Override
    public void confirm(String id) {
        this.updateById((Object)((ElsClSignContract)((Object)this.getById((Serializable)((Object)id)))).setReturnFileConfirm("1"));
    }

    @Override
    public void reject(String id, String rejectReason) {
        this.updateById((Object)((ElsClSignContract)((Object)this.getById((Serializable)((Object)id)))).setReject("1").setRejectReason(rejectReason));
    }

    private void initSigner(List<ElsClSigners> list, ElsClSignContract contract) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        List purchaseSigners = list.stream().filter(x -> CLFirstSealEnum.PURCHASE.getCode().equals(x.getRoleType())).collect(Collectors.toList());
        List saleSigners = list.stream().filter(x -> CLFirstSealEnum.SALE.getCode().equals(x.getRoleType())).collect(Collectors.toList());
        list = Lists.newArrayList();
        if (CLFirstSealEnum.PURCHASE.getValue().equals(contract.getFirstSeal())) {
            list.addAll(purchaseSigners);
            list.addAll(saleSigners);
        } else {
            list.addAll(saleSigners);
            list.addAll(purchaseSigners);
        }
        Integer serialNo = 0;
        for (ElsClSigners row : list) {
            row.setHeadId(contract.getId());
            row.setBusAccount(TenantContext.getTenant());
            if (StrUtil.isBlank((CharSequence)row.getElsAccount())) {
                row.setElsAccount(TenantContext.getTenant());
            }
            Integer n = serialNo;
            Integer n2 = serialNo = Integer.valueOf(serialNo + 1);
            row.setSerialNo(n);
            row.setCreateTime(new Date());
            row.setCreateBy(currentUser);
        }
    }

    private List<ElsClSigners> initUpdateSigner(List<ElsClSignersVo> purchaseSigners, List<ElsClSignersVo> saleSigners, ElsClSignContract contract) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        ArrayList list = Lists.newArrayList();
        if (CLFirstSealEnum.PURCHASE.getValue().equals(contract.getFirstSeal())) {
            if (CollUtil.isNotEmpty(purchaseSigners)) {
                list.addAll(this.converSigners(purchaseSigners));
            }
            if (CollUtil.isNotEmpty(saleSigners)) {
                list.addAll(this.converSigners(saleSigners));
            }
        } else {
            if (CollUtil.isNotEmpty(saleSigners)) {
                list.addAll(this.converSigners(saleSigners));
            }
            if (CollUtil.isNotEmpty(purchaseSigners)) {
                list.addAll(this.converSigners(purchaseSigners));
            }
        }
        Integer serialNo = 0;
        for (ElsClSigners row : list) {
            row.setHeadId(contract.getId());
            row.setBusAccount(TenantContext.getTenant());
            if (StrUtil.isBlank((CharSequence)row.getElsAccount())) {
                row.setElsAccount(TenantContext.getTenant());
            }
            Integer n = serialNo;
            Integer n2 = serialNo = Integer.valueOf(serialNo + 1);
            row.setSerialNo(n);
            row.setHeadId(contract.getId());
            row.setUpdateTime(new Date());
            row.setUpdateBy(currentUser);
            row.setBusAccount("100000");
        }
        return list;
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }
}

