/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.InterfaceApp;
import com.els.modules.system.entity.InterfaceAppPermission;
import com.els.modules.system.entity.OpenInterfaceInfo;
import com.els.modules.system.service.InterfaceAppPermissionService;
import com.els.modules.system.service.InterfaceAppService;
import com.els.modules.system.service.OpenInterfaceInfoService;
import com.els.modules.system.vo.InterfaceAppVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e94\u7528\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/account/interfaceApp"})
public class InterfaceAppController
extends BaseController<InterfaceApp, InterfaceAppService> {
    @Autowired
    private InterfaceAppService interfaceAppService;
    @Autowired
    private InterfaceAppPermissionService interfaceAppPermissionService;
    @Autowired
    private OpenInterfaceInfoService openInterfaceInfoService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"app#interfaceApp:list"})
    public Result<?> queryPageList(InterfaceApp interfaceApp, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)interfaceApp), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String elsAccount = this.getTenantId();
        if (!"100000".equals(elsAccount)) {
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        }
        IPage pageList = this.interfaceAppService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listOwn"})
    @RequiresPermissions(value={"app#interfaceApp:list"})
    public Result<?> listOwn(InterfaceApp interfaceApp, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)interfaceApp), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)this.getTenantId());
        IPage pageList = this.interfaceAppService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"app#interfaceApp:add"})
    public Result<?> add(@RequestBody InterfaceApp interfaceApp) {
        this.interfaceAppService.saveInterfaceApp(interfaceApp);
        return Result.ok((Object)((Object)interfaceApp));
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"app#interfaceApp:edit"})
    public Result<?> edit(@RequestBody InterfaceApp interfaceApp) {
        this.interfaceAppService.updateInterfaceApp(interfaceApp);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u91cd\u7f6e\u5bc6\u94a5")
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u94a5", notes="\u91cd\u7f6e\u5bc6\u94a5")
    @GetMapping(value={"/resetSecret"})
    @RequiresPermissions(value={"app#interfaceApp:resetSecret"})
    public Result<?> resetSecret(@RequestParam(name="id") String id) {
        String secret = this.interfaceAppService.resetSecret(id);
        JSONObject object = new JSONObject();
        object.put("secret", (Object)secret);
        return Result.ok((Object)object);
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u542f\u7528/\u505c\u7528")
    @ApiOperation(value="\u542f\u7528/\u505c\u7528", notes="\u542f\u7528/\u505c\u7528")
    @GetMapping(value={"/startOrStop"})
    @RequiresPermissions(value={"app#interfaceApp:startOrStop"})
    public Result<?> startOrStop(@RequestParam(name="id") String id) {
        this.interfaceAppService.startOrStop(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5e94\u7528\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"app#interfaceApp:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.interfaceAppService.delInterfaceApp(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"app#interfaceApp:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        InterfaceApp interfaceApp = (InterfaceApp)((Object)this.interfaceAppService.getById((Serializable)((Object)id)));
        if (interfaceApp == null) {
            throw new ELSBootException("id \u4e0d\u5b58\u5728\uff01");
        }
        InterfaceAppVO appVO = new InterfaceAppVO();
        BeanUtils.copyProperties((Object)((Object)interfaceApp), (Object)((Object)appVO));
        Map<String, String> permissionMap = this.interfaceAppPermissionService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"app_id", (Object)id)).stream().collect(Collectors.toMap(InterfaceAppPermission::getInterfaceCode, InterfaceAppPermission::getId));
        String purcahseAccount = SysUtil.getPurchaseAccount();
        QueryWrapper queryWrapper = new QueryWrapper();
        if ("100000".equals(purcahseAccount)) {
            queryWrapper.eq((Object)"els_account", (Object)purcahseAccount);
        } else {
            queryWrapper.in((Object)"els_account", new Object[]{purcahseAccount, "100000"});
        }
        List infoList = this.openInterfaceInfoService.list((Wrapper)queryWrapper);
        for (OpenInterfaceInfo info : infoList) {
            if (permissionMap.containsKey(info.getInterfaceCode())) {
                info.setOpenStatus("1");
                info.setId(permissionMap.get(info.getInterfaceCode()));
                continue;
            }
            info.setOpenStatus("0");
        }
        appVO.setInterfacePermissionList(infoList);
        return Result.ok((Object)((Object)appVO));
    }

    @PostMapping(value={"/testJsonArray"})
    public Result<?> testJsonArray(@RequestBody JSONArray array) {
        return Result.ok((Object)array);
    }
}

