/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.system.api.CommonAPI;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.service.ElsEnterpriseInfoService;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.enums.AccountStatusEnum;
import com.els.modules.system.mapper.ElsTenantMapper;
import com.els.modules.system.service.ElsTenantService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElsTenantServiceImpl
extends ServiceImpl<ElsTenantMapper, ElsTenant>
implements ElsTenantService {
    @Autowired
    private CommonAPI sysBaseAPI;
    @Autowired
    private ElsEnterpriseInfoService enterpriseInfoService;

    @Override
    public void saveElsTenant(ElsTenant elsTenant) {
        ((ElsTenantMapper)this.baseMapper).insert((Object)elsTenant);
    }

    @Override
    public void updateElsTenant(ElsTenant elsTenant) {
        ((ElsTenantMapper)this.baseMapper).updateById((Object)elsTenant);
    }

    @Override
    public void delElsTenant(String id) {
        ((ElsTenantMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsTenant(List<String> idList) {
        ((ElsTenantMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<JSONObject> checkTenantIsEffective(String elsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        ElsTenant tenant = (ElsTenant)((Object)((ElsTenantMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        Result result = new Result();
        if (!SysUtil.getDeployWay().equals("cloud")) {
            return result;
        }
        if (tenant == null) {
            result.error500(I18nUtil.translate((String)"i18n_alert_rWWWeyxMKWVKHRvj_27123a7c", (String)"\u8be5ELS\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7\u4e0d\u5b58\u5728\uff01", Integer.valueOf(1), null);
            return result;
        }
        if (AccountStatusEnum.FROZEN.getCode().equals(tenant.getAccountStatus())) {
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7:" + elsAccount + "\u5df2\u51bb\u7ed3\uff01", Integer.valueOf(1), null);
            result.error500(I18nUtil.translate((String)"i18n_alert_rWWWeyIOyWVKHRvj_55c5118f", (String)"\u8be5ELS\u8d26\u53f7\u5df2\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            return result;
        }
        if (new Date().after(tenant.getExpiryDate())) {
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7:" + elsAccount + "\u5df2\u5931\u6548\uff01", Integer.valueOf(1), null);
            result.error500(I18nUtil.translate((String)"i18n_alert_rWWWeyIRjXBAWVKHRvj_883acc3b", (String)"\u8be5ELS\u8d26\u53f7\u5df2\u8fc7\u6709\u6548\u65e5\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            return result;
        }
        return result;
    }

    @Override
    public ElsTenant findByElsAccount(String elsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)"100000");
        ElsTenant elsTenant = (ElsTenant)((Object)this.getOne((Wrapper)wrapper));
        ElsTenant tenant = null;
        if (StringUtils.isNotEmpty((CharSequence)elsAccount)) {
            QueryWrapper wrapper1 = new QueryWrapper();
            wrapper1.eq((Object)"els_account", (Object)elsAccount);
            tenant = (ElsTenant)((Object)this.getOne((Wrapper)wrapper1));
        }
        if (tenant == null) {
            tenant = elsTenant;
        } else if (elsTenant != null) {
            if (StringUtils.isEmpty((CharSequence)tenant.getCompanyShortName())) {
                tenant.setCompanyShortName(elsTenant.getCompanyShortName());
            }
            if (StringUtils.isEmpty((CharSequence)tenant.getCompanyLogo())) {
                tenant.setCompanyLogo(elsTenant.getCompanyLogo());
            }
            if (StringUtils.isEmpty((CharSequence)tenant.getCompanyBackground())) {
                tenant.setCompanyBackground(elsTenant.getCompanyBackground());
                tenant.setFbk1(elsTenant.getFbk1());
            }
            if (StringUtils.isEmpty((CharSequence)tenant.getLoginLayout())) {
                tenant.setLoginLayout(elsTenant.getLoginLayout());
            }
        }
        return tenant;
    }

    @Override
    public List<ElsTenantDTO> getTenantList(List<String> elsAccounts) {
        if (CollectionUtils.isEmpty(elsAccounts)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getElsAccount, ElsTenant::getCompanyShortName, ElsTenant::getCompanyName});
        wrapper.in(BaseEntity::getElsAccount, elsAccounts);
        List list = ((ElsTenantMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return Convert.toList(ElsTenantDTO.class, (Object)list);
    }

    @Override
    public ElsTenant findTenant(String elsAccount) {
        ElsEnterpriseInfo enterpriseInfo;
        ElsTenant tenant = (ElsTenant)((Object)this.getOne((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)));
        if (tenant == null) {
            tenant = new ElsTenant();
        }
        if ((enterpriseInfo = this.enterpriseInfoService.getByElsAccount(elsAccount)) != null) {
            tenant.setCompanyLogo(enterpriseInfo.getEnterpriseLogo());
            tenant.setCompanyName(enterpriseInfo.getName());
            tenant.setCompanyShortName(enterpriseInfo.getAlias());
        }
        return tenant;
    }
}

