/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ThirdAuth;
import com.els.modules.system.mapper.ThirdAuthMapper;
import com.els.modules.system.service.ThirdAuthService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdAuthServiceImpl
extends BaseServiceImpl<ThirdAuthMapper, ThirdAuth>
implements ThirdAuthService {
    private static final Logger log = LoggerFactory.getLogger(ThirdAuthServiceImpl.class);
    public static final String REDIS_KEY = "sys:thirdAuth:";
    public static final String THIRD_MAIL = "1";
    @Resource
    private RedisUtil redisUtil;

    private String getRedisKey(String elsAccount, String appType) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(appType);
        return redisKey.toString();
    }

    @Override
    public void saveThirdAuth(ThirdAuth thirdAuth) {
        if (THIRD_MAIL.equals(thirdAuth.getAppType())) {
            ThirdAuth auth = (ThirdAuth)((Object)((ThirdAuthMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"app_type", (Object)thirdAuth.getAppType())).eq((Object)"app_key", (Object)thirdAuth.getAppKey())).last(" limit 1")));
            if (auth != null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IOMKnICXLUEBKWxOVBSuW_433ba513", (String)"\u5df2\u7ecf\u5b58\u5728\u7b2c\u4e09\u65b9\u5546\u57ce\u5e73\u53f0\u6807\u8bc6\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01"));
            }
        } else {
            ThirdAuth auth = (ThirdAuth)((Object)((ThirdAuthMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"app_type", (Object)thirdAuth.getAppType())).last(" limit 1")));
            if (auth != null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IOMKdjAcWxOVBSuW_9f614151", (String)"\u5df2\u7ecf\u5b58\u5728\u5e94\u7528\u7c7b\u578b\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01"));
            }
        }
        ((ThirdAuthMapper)this.baseMapper).insert((Object)thirdAuth);
    }

    @Override
    public void updateThirdAuth(ThirdAuth thirdAuth) {
        String appType = thirdAuth.getAppType();
        thirdAuth.setAppType(null);
        ((ThirdAuthMapper)this.baseMapper).updateById((Object)thirdAuth);
        if (!THIRD_MAIL.equals(appType)) {
            this.redisUtil.del(new String[]{this.getRedisKey(thirdAuth.getElsAccount(), appType)});
        }
    }

    @Override
    public void delThirdAuth(String id) {
        ThirdAuth thirdAuth = (ThirdAuth)((Object)((ThirdAuthMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        ((ThirdAuthMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        if (!THIRD_MAIL.equals(thirdAuth.getAppType())) {
            this.redisUtil.del(new String[]{this.getRedisKey(thirdAuth.getElsAccount(), thirdAuth.getAppType())});
        }
    }

    @Override
    public ThirdAuth getThirdAuthByType(String elsAccount, String appType) {
        if (THIRD_MAIL.equals(appType)) {
            return null;
        }
        ThirdAuth auth = (ThirdAuth)((Object)this.redisUtil.get(this.getRedisKey(elsAccount, appType)));
        if (auth != null) {
            return auth;
        }
        auth = (ThirdAuth)((Object)((ThirdAuthMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"app_type", (Object)appType)).last(" limit 1")));
        if (auth != null) {
            this.redisUtil.set(this.getRedisKey(elsAccount, appType), (Object)auth, 14400L);
        }
        return auth;
    }

    @Override
    public List<ThirdAuth> getAllPoolConfig(String elsAccount, String appType) {
        if (!THIRD_MAIL.equals(appType)) {
            return null;
        }
        List authList = ((ThirdAuthMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"app_type", (Object)appType));
        return authList;
    }

    @Override
    public ThirdAuth getPoolConfigByCode(String elsAccount, String appType, String code) {
        if (!THIRD_MAIL.equals(appType)) {
            return null;
        }
        ThirdAuth auth = (ThirdAuth)((Object)((ThirdAuthMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"app_type", (Object)appType)).eq((Object)"app_key", (Object)code)).last(" limit 1")));
        return auth;
    }

    @Override
    public String getSSOUrl(String type) {
        String elsAccount = TenantContext.getTenant();
        if (type.equals("2")) {
            InvokeBaseRpcService baseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
            JSONObject param = new JSONObject();
            JSONObject body = new JSONObject();
            body.put("elsAccount", (Object)elsAccount);
            param.put("interface_code", (Object)"getToken");
            param.put("body", (Object)body);
            JSONObject object = baseRpcService.callIPaasInterface(param, "valueAddedApplication", baseRpcService.getIpaasInterfaceCode("get-tenant-token"));
            if ("200".equals(object.getString("code"))) {
                log.info("callIPaasInterface_result:" + object.toJSONString());
                return object.getJSONObject("data").getJSONObject("result").getString("token");
            }
            throw new ELSBootException(object.getString("message"));
        }
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_AcxMKW_6151ff74", (String)"\u7c7b\u578b\u4e0d\u5b58\u5728\uff01"));
    }
}

